/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.security;

import java.lang.reflect.Method;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.scout.commons.TTLCache;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.clientnotification.ClientNotificationConsumerEvent;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerListener;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerService;
import org.eclipse.scout.rt.client.servicetunnel.ServiceTunnelUtility;
import org.eclipse.scout.rt.shared.security.BasicHierarchyPermission;
import org.eclipse.scout.rt.shared.security.FineGrainedAccessCheckRequiredException;
import org.eclipse.scout.rt.shared.services.common.security.AccessControlChangedNotification;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.rt.shared.services.common.security.ResetAccessControlChangedNotification;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;

@Priority(value=-3.0f)
public class AccessControlServiceClientProxy
extends AbstractService
implements IAccessControlService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AccessControlServiceClientProxy.class);
    private static final String SESSION_DATA_KEY = "accessControlServiceState";

    private ServiceState getServiceState() {
        IClientSession session = ClientJob.getCurrentSession();
        if (session == null) {
            LOG.warn("could not find a client session");
            return null;
        }
        ServiceState data = (ServiceState)session.getData(SESSION_DATA_KEY);
        if (data == null) {
            data = new ServiceState();
            session.setData(SESSION_DATA_KEY, data);
        }
        return data;
    }

    public void initializeService() {
        super.initializeService();
        ((IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class)).addGlobalClientNotificationConsumerListener(new IClientNotificationConsumerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(ClientNotificationConsumerEvent e, boolean sync) {
                if (e.getClientNotification().getClass() == AccessControlChangedNotification.class) {
                    ServiceState state = AccessControlServiceClientProxy.this.getServiceState();
                    Object object = state.m_cacheLock;
                    synchronized (object) {
                        state.m_permissions = ((AccessControlChangedNotification)e.getClientNotification()).getPermissions();
                    }
                } else if (e.getClientNotification().getClass() == ResetAccessControlChangedNotification.class) {
                    AccessControlServiceClientProxy.this.clearCache();
                }
            }
        });
    }

    public boolean checkPermission(Permission p) {
        ServiceState state = this.getServiceState();
        this.ensureCacheLoaded(state);
        if (p == null) {
            return true;
        }
        if (state.m_permissions == null) {
            return true;
        }
        Boolean b = (Boolean)state.m_checkPermissionCache.get((Object)p.getName());
        if (b == null) {
            try {
                b = state.m_permissions.implies(p);
            }
            catch (FineGrainedAccessCheckRequiredException e) {
                b = this.getRemoteService().checkPermission(p);
            }
            state.m_checkPermissionCache.put((Object)p.getName(), (Object)b);
        }
        return b;
    }

    public int getPermissionLevel(Permission p) {
        ServiceState state = this.getServiceState();
        this.ensureCacheLoaded(state);
        if (p == null) {
            return 0;
        }
        if (!(p instanceof BasicHierarchyPermission)) {
            if (this.checkPermission(p)) {
                return 100;
            }
            return 0;
        }
        BasicHierarchyPermission hp = (BasicHierarchyPermission)p;
        if (state.m_permissions == null) {
            List levels = hp.getValidLevels();
            return (Integer)levels.get(levels.size() - 1);
        }
        int maxLevel = -1;
        Enumeration<Permission> en = state.m_permissions.elements();
        while (en.hasMoreElements()) {
            BasicHierarchyPermission hgrantedPermission;
            Permission grantedPermission = en.nextElement();
            if (grantedPermission instanceof AllPermission) {
                return 100;
            }
            if (grantedPermission instanceof BasicHierarchyPermission && (hgrantedPermission = (BasicHierarchyPermission)grantedPermission).getClass().isAssignableFrom(hp.getClass()) && (maxLevel = Math.max(maxLevel, hgrantedPermission.getLevel())) >= 100) break;
        }
        return maxLevel;
    }

    public Permissions getPermissions() {
        ServiceState state = this.getServiceState();
        this.ensureCacheLoaded(state);
        return state.m_permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCacheLoaded(ServiceState state) {
        Object object = state.m_cacheLock;
        synchronized (object) {
            if (state.m_permissions == null) {
                state.m_checkPermissionCache = new TTLCache(BasicHierarchyPermission.getCacheTimeoutMillis());
                state.m_permissions = this.getRemoteService().getPermissions();
            }
        }
    }

    public boolean isProxyService() {
        return true;
    }

    public String getUserIdOfCurrentSubject() {
        return this.getRemoteService().getUserIdOfCurrentSubject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            state.m_permissions = null;
        }
    }

    public void clearCacheOfUserIds(String ... userIds) {
    }

    @Deprecated
    public void clearCacheOfPrincipals(String ... userIds) {
    }

    private IAccessControlService getRemoteService() {
        return ServiceTunnelUtility.createProxy(IAccessControlService.class, ClientSyncJob.getCurrentSession().getServiceTunnel());
    }

    public boolean checkServiceTunnelAccess(Class serviceInterface, Method method, Object[] args) {
        return false;
    }

    private static class ServiceState {
        final Object m_cacheLock = new Object();
        Permissions m_permissions;
        TTLCache<String, Boolean> m_checkPermissionCache = new TTLCache();

        private ServiceState() {
        }
    }
}

