/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.shell;

import java.io.File;
import java.io.IOException;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.shell.IShellService;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.eclipse.scout.service.AbstractService;

@Priority(value=0.0f)
public class DefaultShellService
extends AbstractService
implements IShellService {
    public void shellOpen(String path) throws ProcessingException {
        if (UserAgentUtility.isWebClient()) {
            ClientSyncJob.getCurrentSession().getDesktop().openBrowserWindow(path);
        } else {
            this.openWithRuntimeExec(path);
        }
    }

    protected String validatePath(String path) throws IOException {
        if (new File(path = path.replace('\\', File.separatorChar)).exists()) {
            path = new File(path).getCanonicalPath();
            String osName = System.getProperty("os.name");
            if (osName != null && osName.startsWith("Mac OS")) {
                String ext = path.substring(path.lastIndexOf(46));
                File f = new File(new File(path).getParentFile(), System.nanoTime() + ext);
                new File(path).renameTo(f);
                f.deleteOnExit();
                path = f.getAbsolutePath();
            }
        }
        return path;
    }

    protected void openWithRuntimeExec(String path) throws ProcessingException {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return;
        }
        try {
            String pathQuoted;
            String commandline = null;
            if (osName.startsWith("Windows")) {
                pathQuoted = "\"" + this.validatePath(path) + "\"";
                commandline = "cmd.exe /c start \"\" " + pathQuoted;
            } else if (osName.startsWith("Mac OS")) {
                commandline = "open " + this.validatePath(path);
            } else if (osName.startsWith("Linux")) {
                pathQuoted = "\"" + this.validatePath(path) + "\"";
                commandline = "xdg-open " + pathQuoted;
            }
            if (commandline == null) {
                return;
            }
            Process process = Runtime.getRuntime().exec(commandline);
            process.waitFor();
        }
        catch (InterruptedException ie) {
            throw new ProcessingException(ScoutTexts.get((String)"Interrupted", (String[])new String[0]), (Throwable)ie);
        }
        catch (Throwable t) {
            throw new ProcessingException("Unexpected: " + path, t);
        }
    }
}

