/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.servicetunnel;

import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Arrays;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerService;
import org.eclipse.scout.rt.client.services.common.perf.IPerformanceAnalyzerService;
import org.eclipse.scout.rt.client.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.shared.OfflineState;
import org.eclipse.scout.rt.shared.services.common.offline.IOfflineDispatcherService;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.eclipse.scout.rt.shared.servicetunnel.VersionMismatchException;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.scout.service.ServiceUtility;

public abstract class AbstractServiceTunnel
implements IServiceTunnel {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractServiceTunnel.class);
    private final String m_version;
    private URL m_serverURL;
    private final IClientSession m_clientSession;
    private long m_pollInterval = -1L;
    private boolean m_analyzeNetworkLatency = true;

    public AbstractServiceTunnel(IClientSession session, String version) {
        this.m_clientSession = session;
        if (version == null && Platform.getProduct() != null) {
            version = (String)Platform.getProduct().getDefiningBundle().getHeaders().get("Bundle-Version");
        }
        this.m_version = version;
    }

    @Override
    public void setClientNotificationPollInterval(long intervallMillis) {
        this.m_pollInterval = intervallMillis;
    }

    @Override
    public long getClientNotificationPollInterval() {
        return this.m_pollInterval;
    }

    @Override
    public boolean isAnalyzeNetworkLatency() {
        return this.m_analyzeNetworkLatency;
    }

    @Override
    public void setAnalyzeNetworkLatency(boolean b) {
        this.m_analyzeNetworkLatency = b;
    }

    public String getVersion() {
        return this.m_version;
    }

    @Override
    public URL getServerURL() {
        return this.m_serverURL;
    }

    @Override
    public void setServerURL(URL url) {
        this.m_serverURL = url;
    }

    public IClientSession getClientSession() {
        return this.m_clientSession;
    }

    public Object invokeService(Class serviceInterfaceClass, Method operation, Object[] callerArgs) throws ProcessingException {
        if (this.getServerURL() == null) {
            throw new ProcessingException("serverURL is null. Check proxyHandler extension. Example value is: http://localhost:8080/myapp/process");
        }
        long t0 = System.nanoTime();
        try {
            Throwable t;
            IClientNotificationConsumerService cns;
            IPerformanceAnalyzerService perf;
            if (callerArgs == null) {
                callerArgs = new Object[]{};
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(serviceInterfaceClass + "." + operation + "(" + Arrays.asList(callerArgs) + ")");
            }
            Object[] serializableArgs = ServiceUtility.filterHolderArguments((Object[])callerArgs);
            ServiceTunnelRequest call = new ServiceTunnelRequest(this.getVersion(), serviceInterfaceClass, operation, serializableArgs);
            call.setClientSubject(this.getClientSession().getSubject());
            call.setVirtualSessionId(this.getClientSession().getVirtualSessionId());
            call.setUserAgent(this.getClientSession().getUserAgent().createIdentifier());
            ServiceTunnelResponse response = this.tunnel(call);
            if (response == null) {
                response = new ServiceTunnelResponse(null, null, (Throwable)new InterruptedException());
            }
            if ((perf = (IPerformanceAnalyzerService)SERVICES.getService(IPerformanceAnalyzerService.class)) != null) {
                long totalMillis = (System.nanoTime() - t0) / 1000000L;
                Long execMillis = response.getProcessingDuration();
                if (execMillis != null) {
                    perf.addNetworkLatencySample(totalMillis - execMillis);
                    perf.addServerExecutionTimeSample(execMillis);
                } else {
                    perf.addNetworkLatencySample(totalMillis);
                }
            }
            if ((cns = (IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class)) != null) {
                cns.dispatchClientNotifications(response.getClientNotifications(), this.m_clientSession);
            }
            if ((t = response.getException()) != null) {
                Object pe;
                String msg = "Calling " + serviceInterfaceClass.getSimpleName() + "." + operation.getName() + "()";
                if (t instanceof VersionMismatchException) {
                    VersionMismatchException ve = (VersionMismatchException)t;
                    this.handleVersionMismatch(ve);
                    pe = ve;
                } else if (t instanceof ProcessingException) {
                    ((ProcessingException)t).addContextMessage(msg);
                    pe = (ProcessingException)t;
                } else {
                    pe = new ProcessingException(msg, t);
                }
                StackTraceElement[] trace1 = pe.getStackTrace();
                StackTraceElement[] trace2 = new Exception().getStackTrace();
                StackTraceElement[] both = new StackTraceElement[trace1.length + trace2.length];
                System.arraycopy(trace1, 0, both, 0, trace1.length);
                System.arraycopy(trace2, 0, both, trace1.length, trace2.length);
                pe.setStackTrace(both);
                throw pe;
            }
            ServiceUtility.updateHolderArguments((Object[])callerArgs, (Object[])response.getOutVars(), (boolean)false);
            return response.getData();
        }
        catch (Throwable t) {
            if (t instanceof ProcessingException) {
                throw (ProcessingException)t;
            }
            throw new ProcessingException(String.valueOf(serviceInterfaceClass.getSimpleName()) + "." + operation.getName() + "(" + VerboseUtility.dumpObjects((Object[])callerArgs) + ")", t);
        }
    }

    protected ServiceTunnelResponse tunnel(ServiceTunnelRequest call) {
        boolean offline = OfflineState.isOfflineInCurrentThread();
        if (offline) {
            return this.tunnelOffline(call);
        }
        return this.tunnelOnline(call);
    }

    protected abstract ServiceTunnelResponse tunnelOnline(ServiceTunnelRequest var1);

    @Deprecated
    protected void handleVersionMismatch(VersionMismatchException ve) {
    }

    protected ServiceTunnelResponse tunnelOffline(final ServiceTunnelRequest call) {
        Job job = Job.getJobManager().currentJob();
        final Object monitor = job instanceof ClientJob ? ((ClientJob)job).getMonitor() : new NullProgressMonitor();
        IClientSession clientSession = ClientSyncJob.getCurrentSession();
        if (clientSession != null && clientSession.getOfflineSubject() != null) {
            ServiceTunnelResponse response = Subject.doAs(clientSession.getOfflineSubject(), new PrivilegedAction<ServiceTunnelResponse>(){

                @Override
                public ServiceTunnelResponse run() {
                    return ((IOfflineDispatcherService)SERVICES.getService(IOfflineDispatcherService.class)).dispatch(call, monitor);
                }
            });
            return response;
        }
        return ((IOfflineDispatcherService)SERVICES.getService(IOfflineDispatcherService.class)).dispatch(call, monitor);
    }
}

