/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.keystroke;

import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeLong;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;

public class DefaultFormEnterKeyStroke
extends AbstractKeyStroke {
    private final IForm m_form;

    public DefaultFormEnterKeyStroke(IForm form) {
        this.m_form = form;
    }

    @Override
    protected String getConfiguredKeyStroke() {
        return "enter";
    }

    @Override
    protected void execAction() throws ProcessingException {
        IForm f = this.m_form;
        while (f != null) {
            TreeMap<CompositeLong, IButton> prioMap = new TreeMap<CompositeLong, IButton>();
            IButton[] iButtonArray = f.getRootGroupBox().getSystemProcessButtons();
            int n = iButtonArray.length;
            int n2 = 0;
            while (n2 < n) {
                IButton b = iButtonArray[n2];
                switch (b.getSystemType()) {
                    case 3: {
                        prioMap.put(new CompositeLong(3L, (long)prioMap.size()), b);
                        break;
                    }
                    case 5: {
                        prioMap.put(new CompositeLong(4L, (long)prioMap.size()), b);
                        break;
                    }
                    case 6: {
                        prioMap.put(new CompositeLong(5L, (long)prioMap.size()), b);
                    }
                }
                ++n2;
            }
            int visibleCount = 0;
            for (IButton b : prioMap.values()) {
                if (b.isEnabled() && b.isVisible() && b.isEnabledProcessingButton()) {
                    b.doClick();
                    return;
                }
                if (!b.isVisible()) continue;
                ++visibleCount;
            }
            f = visibleCount == 0 ? f.getOuterForm() : null;
        }
    }
}

