/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;

public class CalendarEvent
extends EventObject {
    public static final int TYPE_COMPONENT_ACTION = 20;
    public static final int TYPE_COMPONENT_POPUP = 30;
    public static final int TYPE_NEW_POPUP = 31;
    private int m_type;
    private CalendarComponent m_component;
    private List<IMenu> m_popupMenus;

    public CalendarEvent(ICalendar source, int type) {
        super(source);
        this.m_type = type;
    }

    public CalendarEvent(ICalendar source, int type, CalendarComponent comp) {
        super(source);
        this.m_type = type;
        this.m_component = comp;
    }

    public ICalendar getCalendar() {
        return (ICalendar)this.getSource();
    }

    public int getType() {
        return this.m_type;
    }

    public CalendarComponent getComponent() {
        return this.m_component;
    }

    public void addPopupMenu(IMenu menu) {
        if (menu != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.add(menu);
        }
    }

    public void addPopupMenus(IMenu[] menus) {
        if (menus != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.addAll(Arrays.asList(menus));
        }
    }

    public IMenu[] getPopupMenus() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.toArray(new IMenu[0]);
        }
        return new IMenu[0];
    }

    public int getPopupMenuCount() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.size();
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CalendarEvent[");
        try {
            Field[] f = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if (Modifier.isPublic(f[i].getModifiers()) && Modifier.isStatic(f[i].getModifiers()) && f[i].getName().startsWith("TYPE_") && ((Number)f[i].get(null)).intValue() == this.m_type) {
                    buf.append(f[i].getName());
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            buf.append("#" + this.m_type);
        }
        if (this.m_component != null) {
            buf.append(", component=" + this.m_component.getCell().getText());
        }
        buf.append("]");
        return buf.toString();
    }
}

