/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.dnd.TextTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.action.ActionFinder;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuSeparator;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTableRowBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.DefaultTableEventHistory;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable2;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowFilter;
import org.eclipse.scout.rt.client.ui.basic.table.ITableUIFacade;
import org.eclipse.scout.rt.client.ui.basic.table.KeyStrokeBuffer;
import org.eclipse.scout.rt.client.ui.basic.table.RowIndexComparator;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableRowComparator;
import org.eclipse.scout.rt.client.ui.basic.table.TableRowDataMapper;
import org.eclipse.scout.rt.client.ui.basic.table.TableUtility;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ColumnFilterMenu;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.DefaultTableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.AddCustomColumnMenu;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ITableCustomizer;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ModifyCustomColumnMenu;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.RemoveCustomColumnMenu;
import org.eclipse.scout.rt.client.ui.basic.table.internal.InternalTableRow;
import org.eclipse.scout.rt.client.ui.basic.table.menus.CopyWidthsOfColumnsMenu;
import org.eclipse.scout.rt.client.ui.basic.table.menus.OrganizeColumnsMenu;
import org.eclipse.scout.rt.client.ui.basic.table.menus.ResetColumnsMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldData;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupResultCache;
import org.eclipse.scout.rt.shared.services.lookup.IBatchLookupService;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractTable
extends AbstractPropertyObserver
implements ITable2 {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTable.class);
    private boolean m_initialized;
    private final OptimisticLock m_initLock;
    private ColumnSet m_columnSet;
    private final List<ITableRow> m_rows;
    private final Object m_cachedRowsLock;
    private ITableRow[] m_cachedRows;
    private final HashMap<CompositeObject, ITableRow> m_deletedRows;
    private TreeSet<ITableRow> m_selectedRows = new TreeSet<ITableRow>(new RowIndexComparator());
    private IMenu[] m_menus;
    private Map<Class<?>, Class<? extends IMenu>> m_menuReplacementMapping;
    private ITableUIFacade m_uiFacade;
    private final ArrayList<ITableRowFilter> m_rowFilters;
    private String m_userPreferenceContext;
    private boolean m_autoDiscardOnDelete;
    private boolean m_sortEnabled;
    private boolean m_sortValid;
    private boolean m_initialMultiLineText;
    private int m_tableChanging;
    private ArrayList<TableEvent> m_tableEventBuffer = new ArrayList();
    private final HashSet<P_CellLookup> m_cellLookupBuffer = new HashSet();
    private HashSet<ITableRow> m_rowDecorationBuffer = new HashSet();
    private final KeyStrokeBuffer m_keyStrokeBuffer;
    private final EventListenerList m_listenerList = new EventListenerList();
    private P_CellEditorContext m_editContext;
    private Set<ITableRow> m_rowValidty;
    private IBooleanColumn m_checkableColumn;
    private final Object m_cachedFilteredRowsLock;
    private ITableRow[] m_cachedFilteredRows;
    private ITableColumnFilterManager m_columnFilterManager;
    private ITableCustomizer m_tableCustomizer;
    private IEventHistory<TableEvent> m_eventHistory;
    private boolean m_actionRunning;
    private int m_processEventBufferLoopDetection;

    public AbstractTable() {
        this(true);
    }

    public AbstractTable(boolean callInitializer) {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerTable(this);
        }
        this.m_rowValidty = new HashSet<ITableRow>();
        this.m_cachedRowsLock = new Object();
        this.m_cachedFilteredRowsLock = new Object();
        this.m_rows = Collections.synchronizedList(new ArrayList(1));
        this.m_deletedRows = new HashMap();
        this.m_keyStrokeBuffer = new KeyStrokeBuffer(500L);
        this.m_rowFilters = new ArrayList(1);
        this.m_initLock = new OptimisticLock();
        this.m_actionRunning = false;
        this.addTableListener(new P_TableListener());
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        this.initConfig();
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDefaultIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredMultiSelect() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=32.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredMultiCheck() {
        return true;
    }

    @ConfigProperty(value="MENU_CLASS")
    @Order(value=35.0)
    @ConfigPropertyValue(value="null")
    protected Class<? extends IMenu> getConfiguredDefaultMenu() {
        return null;
    }

    protected Class<? extends IMenu> getDefaultMenuInternal() {
        return this.getConfiguredDefaultMenu();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredAutoDiscardOnDelete() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredSortEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=70.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredHeaderVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredAutoResizeColumns() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredMultilineText() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=92.0)
    @ConfigPropertyValue(value="-1")
    protected int getConfiguredRowHeightHint() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredCheckable() {
        return false;
    }

    @ConfigProperty(value="TABLE_COLUMN")
    @Order(value=102.0)
    @ConfigPropertyValue(value="false")
    protected Class<? extends AbstractBooleanColumn> getConfiguredCheckableColumn() {
        return null;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=190.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=190.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredDragType() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredKeyboardNavigation() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=230.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredScrollToSelection() {
        return false;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected TransferObject execDrag(ITableRow[] rows) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execDrop(ITableRow row, TransferObject t) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected TransferObject execCopy(ITableRow[] rows) throws ProcessingException {
        if (rows.length == 0) {
            return null;
        }
        StringBuilder plainText = new StringBuilder();
        StringBuilder htmlText = new StringBuilder("<html>");
        htmlText.append("<head><style type=\"text/css\"> br {mso-data-placement:same-cell;} </style></head>");
        htmlText.append("<body><table border=\"0\">");
        IColumn[] columns = this.getColumnSet().getVisibleColumns();
        Pattern patternHtmlCheck = Pattern.compile(".*?<\\s*html.*?>.*", 42);
        Pattern patternBodyContent = Pattern.compile("<\\s*body.*?>(.*?)<\\s*/\\s*body\\s*>", 42);
        boolean firstRow = true;
        ITableRow[] iTableRowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            ITableRow row = iTableRowArray[n2];
            htmlText.append("<tr>");
            if (!firstRow) {
                plainText.append(System.getProperty("line.separator"));
            }
            boolean firstColumn = true;
            IColumn[] iColumnArray = columns;
            int n3 = columns.length;
            int n4 = 0;
            while (n4 < n3) {
                Matcher matcher;
                boolean value;
                IColumn column = iColumnArray[n4];
                String text = column instanceof IBooleanColumn ? ((value = BooleanUtility.nvl((Boolean)((Boolean)((IBooleanColumn)column).getValue(row)), (boolean)false)) ? "X" : "") : StringUtility.emptyIfNull((Object)row.getCell(column).getText());
                if (!firstColumn) {
                    plainText.append("\t");
                }
                plainText.append(StringUtility.emptyIfNull((Object)StringUtility.unwrapText((String)text)));
                String html = null;
                if (patternHtmlCheck.matcher(text).matches() && (matcher = patternBodyContent.matcher(HTMLUtility.cleanupHtml((String)text, (boolean)false, (boolean)false, null))).find()) {
                    html = matcher.group(1);
                }
                if (html == null) {
                    html = StringUtility.htmlEncode((String)text);
                }
                htmlText.append("<td>");
                htmlText.append(html);
                htmlText.append("</td>");
                firstColumn = false;
                ++n4;
            }
            htmlText.append("</tr>");
            firstRow = false;
            ++n2;
        }
        htmlText.append("</table></body></html>");
        TextTransferObject transferObject = new TextTransferObject(plainText.toString(), htmlText.toString());
        return transferObject;
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execContentChanged() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execDecorateCell(Cell view, ITableRow row, IColumn<?> col) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execInitTable() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execDisposeTable() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execRowClick(ITableRow row) throws ProcessingException {
        TableEvent e = new TableEvent(this, 810, new ITableRow[]{row});
        this.fireTableEventInternal(e);
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execRowAction(ITableRow row) throws ProcessingException {
        Class<? extends IMenu> defaultMenuType = this.getDefaultMenuInternal();
        if (defaultMenuType != null) {
            try {
                this.runMenu(defaultMenuType);
            }
            catch (ProcessingException ex) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(this.createNewUnexpectedProcessingExcpetion(t));
            }
        } else {
            TableEvent e = new TableEvent(this, 104, new ITableRow[]{row});
            this.fireTableEventInternal(e);
        }
    }

    @ConfigOperation
    @Order(value=100.0)
    protected void execRowsSelected(ITableRow[] rows) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=110.0)
    protected void execDecorateRow(ITableRow row) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
    }

    private Class<? extends IMenu>[] getConfiguredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((Class[])foca);
    }

    private Class<? extends IColumn>[] getConfiguredColumns() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IColumn.class);
        return ConfigurationUtility.removeReplacedClasses((Class[])foca);
    }

    private Class<? extends IKeyStroke>[] getConfiguredKeyStrokes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] fca = ConfigurationUtility.filterClasses((Class[])dca, IKeyStroke.class);
        return ConfigurationUtility.removeReplacedClasses((Class[])fca);
    }

    protected void initConfig() {
        this.m_eventHistory = this.createEventHistory();
        this.m_uiFacade = this.createUIFacade();
        this.setTitle(this.getConfiguredTitle());
        this.setAutoDiscardOnDelete(this.getConfiguredAutoDiscardOnDelete());
        this.setSortEnabled(this.getConfiguredSortEnabled());
        this.setDefaultIconId(this.getConfiguredDefaultIconId());
        this.setHeaderVisible(this.getConfiguredHeaderVisible());
        this.setAutoResizeColumns(this.getConfiguredAutoResizeColumns());
        this.setCheckable(this.getConfiguredCheckable());
        this.setMultiCheck(this.getConfiguredMultiCheck());
        this.setMultiSelect(this.getConfiguredMultiSelect());
        this.setInitialMultilineText(this.getConfiguredMultilineText());
        this.setMultilineText(this.getConfiguredMultilineText());
        this.setRowHeightHint(this.getConfiguredRowHeightHint());
        this.setKeyboardNavigation(this.getConfiguredKeyboardNavigation());
        this.setDragType(this.getConfiguredDragType());
        this.setDropType(this.getConfiguredDropType());
        this.setScrollToSelection(this.getConfiguredScrollToSelection());
        if (this.getTableCustomizer() == null) {
            this.setTableCustomizer(this.createTableCustomizer());
        }
        this.createColumnsInternal();
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        Class[] ma = this.getConfiguredMenus();
        Map replacements = ConfigurationUtility.getReplacementMapping((Class[])ma);
        if (!replacements.isEmpty()) {
            this.m_menuReplacementMapping = replacements;
        }
        int i = 0;
        while (i < ma.length) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, (Class)ma[i]);
                menuList.add(menu);
            }
            catch (Throwable t) {
                LOG.error("create " + ma[i].getName(), t);
            }
            ++i;
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e);
        }
        this.m_menus = menuList.toArray(new IMenu[menuList.size()]);
        ArrayList<IKeyStroke> ksList = new ArrayList<IKeyStroke>();
        Class<? extends IKeyStroke>[] ksArray = this.getConfiguredKeyStrokes();
        int i2 = 0;
        while (i2 < ksArray.length) {
            try {
                IKeyStroke ks = (IKeyStroke)ConfigurationUtility.newInnerInstance((Object)this, ksArray[i2]);
                ksList.add(ks);
            }
            catch (Throwable t) {
                LOG.error("create " + ksArray[i2].getName(), t);
            }
            ++i2;
        }
        Class<? extends IMenu> defaultMenuType = this.getDefaultMenuInternal();
        if (defaultMenuType != null || ConfigurationUtility.isMethodOverwrite(AbstractTable.class, (String)"execRowAction", (Class[])new Class[]{ITableRow.class}, this.getClass())) {
            ksList.add(new KeyStroke("ENTER"){

                @Override
                protected void execAction() throws ProcessingException {
                    AbstractTable.this.fireRowAction(AbstractTable.this.getSelectedRow());
                }
            });
        }
        this.setKeyStrokes(ksList.toArray(new IKeyStroke[ksList.size()]));
        this.addTableListener(new TableAdapter(){

            @Override
            public void tableChanged(TableEvent e) {
                IEventHistory<TableEvent> h = AbstractTable.this.getEventHistory();
                if (h != null) {
                    h.notifyEvent(e);
                }
                switch (e.getType()) {
                    case 730: {
                        if (e.getDragObject() != null) break;
                        try {
                            e.setDragObject(AbstractTable.this.execDrag(e.getRows()));
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                        break;
                    }
                    case 740: {
                        if (e.getDropObject() == null) break;
                        try {
                            AbstractTable.this.execDrop(e.getFirstRow(), e.getDropObject());
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                        break;
                    }
                    case 760: {
                        if (e.getCopyObject() != null) break;
                        try {
                            e.setCopyObject(AbstractTable.this.execCopy(e.getRows()));
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                        break;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 105: {
                        try {
                            AbstractTable.this.execContentChanged();
                            break;
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                    }
                }
            }
        });
    }

    private void initColumnsInternal() {
        IColumn[] iColumnArray = this.getColumnSet().getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn c = iColumnArray[n2];
            try {
                c.initColumn();
            }
            catch (Throwable t) {
                LOG.error("column " + c, t);
            }
            ++n2;
        }
        this.getColumnSet().initialize();
    }

    private void disposeColumnsInternal() {
        IColumn[] iColumnArray = this.getColumnSet().getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn c = iColumnArray[n2];
            try {
                c.disposeColumn();
            }
            catch (Throwable t) {
                LOG.error("column " + c, t);
            }
            ++n2;
        }
    }

    private void createColumnsInternal() {
        Class<? extends IColumn>[] ca = this.getConfiguredColumns();
        ArrayList colList = new ArrayList();
        int i = 0;
        while (i < ca.length) {
            try {
                IColumn column = (IColumn)ConfigurationUtility.newInnerInstance((Object)this, ca[i]);
                colList.add(column);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
        try {
            this.injectColumnsInternal(colList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contribute columns.", (Throwable)e);
        }
        ArrayList<IColumn> completeList = new ArrayList<IColumn>();
        completeList.addAll(colList);
        this.m_columnSet = new ColumnSet(this, completeList);
        if (this.getConfiguredCheckableColumn() != null) {
            AbstractBooleanColumn checkableColumn = this.getColumnSet().getColumnByClass(this.getConfiguredCheckableColumn());
            this.setCheckableColumn(checkableColumn);
        }
    }

    protected void injectColumnsInternal(List<IColumn<?>> columnList) {
        ITableCustomizer c = this.getTableCustomizer();
        if (c != null) {
            c.injectCustomColumns(columnList);
        }
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    protected ITableUIFacade createUIFacade() {
        return new P_TableUIFacade();
    }

    @Override
    public String getUserPreferenceContext() {
        return this.m_userPreferenceContext;
    }

    @Override
    public void setUserPreferenceContext(String context) {
        this.m_userPreferenceContext = context;
        if (this.isTableInitialized()) {
            try {
                this.initTable();
            }
            catch (ProcessingException e) {
                LOG.error("Failed re-initializing table " + this.getClass().getName(), (Throwable)e);
            }
        }
    }

    @Override
    public final void initTable() throws ProcessingException {
        block6: {
            try {
                if (!this.m_initLock.acquire()) break block6;
                try {
                    this.setTableChanging(true);
                    this.initTableInternal();
                    this.execInitTable();
                }
                finally {
                    this.setTableChanging(false);
                }
            }
            finally {
                this.m_initialized = true;
                this.m_initLock.release();
            }
        }
    }

    protected void initTableInternal() throws ProcessingException {
        this.initColumnsInternal();
        if (this.getColumnFilterManager() == null) {
            this.setColumnFilterManager(this.createColumnFilterManager());
        }
    }

    @Override
    public final void disposeTable() {
        try {
            this.disposeTableInternal();
            this.execDisposeTable();
        }
        catch (Throwable t) {
            LOG.warn(this.getClass().getName(), t);
        }
    }

    protected void disposeTableInternal() throws ProcessingException {
        this.disposeColumnsInternal();
    }

    @Override
    public void doHyperlinkAction(ITableRow row, IColumn<?> col, URL url) throws ProcessingException {
        if (!this.m_actionRunning) {
            try {
                this.m_actionRunning = true;
                if (row != null) {
                    this.selectRow(row);
                }
                if (col != null) {
                    this.setContextColumn(col);
                }
                this.execHyperlinkAction(url, url.getPath(), url != null && url.getHost().equals("local"));
            }
            finally {
                this.m_actionRunning = false;
            }
        }
    }

    @Override
    public ITableRowFilter[] getRowFilters() {
        return this.m_rowFilters.toArray(new ITableRowFilter[this.m_rowFilters.size()]);
    }

    @Override
    public void addRowFilter(ITableRowFilter filter) {
        if (filter != null) {
            boolean exists = false;
            for (ITableRowFilter existingFilter : this.m_rowFilters) {
                if (existingFilter != filter) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.m_rowFilters.add(filter);
            }
            this.applyRowFilters();
        }
    }

    @Override
    public void removeRowFilter(ITableRowFilter filter) {
        if (filter != null) {
            this.m_rowFilters.remove(filter);
            this.applyRowFilters();
        }
    }

    @Override
    public void applyRowFilters() {
        this.applyRowFiltersInternal();
        this.fireRowFilterChanged();
    }

    private void applyRowFiltersInternal() {
        for (ITableRow row : this.m_rows) {
            this.applyRowFiltersInternal((InternalTableRow)row);
        }
    }

    private void applyRowFiltersInternal(InternalTableRow row) {
        row.setFilterAcceptedInternal(true);
        if (this.m_rowFilters.size() > 0) {
            for (ITableRowFilter filter : this.m_rowFilters) {
                if (filter.accept(row)) continue;
                row.setFilterAcceptedInternal(false);
                if (!this.isSelectedRow(row)) break;
                this.deselectRow(row);
                break;
            }
        }
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public boolean isAutoResizeColumns() {
        return this.propertySupport.getPropertyBool("autoResizeColumns");
    }

    @Override
    public void setAutoResizeColumns(boolean b) {
        this.propertySupport.setPropertyBool("autoResizeColumns", b);
    }

    @Override
    public ColumnSet getColumnSet() {
        return this.m_columnSet;
    }

    @Override
    public int getColumnCount() {
        return this.getColumnSet().getColumnCount();
    }

    @Override
    public IColumn<?>[] getColumns() {
        return this.getColumnSet().getColumns();
    }

    @Override
    public String[] getColumnNames() {
        String[] a = new String[this.getColumnCount()];
        int i = 0;
        while (i < a.length) {
            a[i] = this.getColumnSet().getColumn(i).getHeaderCell().getText();
            ++i;
        }
        return a;
    }

    @Override
    public int getVisibleColumnCount() {
        return this.getColumnSet().getVisibleColumnCount();
    }

    @Override
    public IHeaderCell getVisibleHeaderCell(int visibleColumnIndex) {
        return this.getHeaderCell(this.getColumnSet().getVisibleColumn(visibleColumnIndex));
    }

    @Override
    public IHeaderCell getHeaderCell(int columnIndex) {
        return this.getHeaderCell(this.getColumnSet().getColumn(columnIndex));
    }

    @Override
    public IHeaderCell getHeaderCell(IColumn<?> col) {
        return col.getHeaderCell();
    }

    @Override
    public ICell getVisibleCell(int rowIndex, int visibleColumnIndex) {
        return this.getVisibleCell(this.getRow(rowIndex), visibleColumnIndex);
    }

    @Override
    public ICell getVisibleCell(ITableRow row, int visibleColumnIndex) {
        return this.getCell(row, this.getColumnSet().getVisibleColumn(visibleColumnIndex));
    }

    @Override
    public ICell getCell(int rowIndex, int columnIndex) {
        return this.getCell(this.getRow(rowIndex), this.getColumnSet().getColumn(columnIndex));
    }

    @Override
    public ICell getSummaryCell(int rowIndex) {
        return this.getSummaryCell(this.getRow(rowIndex));
    }

    @Override
    public ICell getSummaryCell(ITableRow row) {
        Cell cell;
        IColumn col;
        IColumn[] a = this.getColumnSet().getSummaryColumns();
        if (a.length == 0 && (col = this.getColumnSet().getFirstDefinedVisibileColumn()) != null) {
            a = new IColumn[]{col};
        }
        if (a.length == 0) {
            return new Cell();
        }
        if (a.length == 1) {
            cell = new Cell(this.getCell(row, a[0]));
            if (cell.getIconId() == null) {
                cell.setIconId(row.getIconId());
            }
            return cell;
        }
        cell = new Cell(this.getCell(row, a[0]));
        if (cell.getIconId() == null) {
            cell.setIconId(row.getIconId());
        }
        StringBuilder b = new StringBuilder();
        IColumn[] iColumnArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn c = iColumnArray[n2];
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(this.getCell(row, c).getText());
            ++n2;
        }
        cell.setText(b.toString());
        return cell;
    }

    @Override
    public ICell getCell(ITableRow row, IColumn<?> col) {
        if ((row = this.resolveRow(row)) == null || col == null) {
            return null;
        }
        return row.getCell(col.getColumnIndex());
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isCellEditable(this.getRow(rowIndex), this.getColumnSet().getColumn(columnIndex));
    }

    @Override
    public boolean isCellEditable(ITableRow row, int visibleColumnIndex) {
        return this.isCellEditable(row, this.getColumnSet().getVisibleColumn(visibleColumnIndex));
    }

    @Override
    public boolean isCellEditable(ITableRow row, IColumn<?> column) {
        return row != null && column != null && column.isVisible() && column.isCellEditable(row);
    }

    @Override
    public Object getProperty(String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.propertySupport.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertySupport.hasProperty(name);
    }

    @Override
    public boolean isCheckable() {
        return this.propertySupport.getPropertyBool("checkable");
    }

    @Override
    public void setCheckable(boolean b) {
        this.propertySupport.setPropertyBool("checkable", b);
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public boolean isMultilineText() {
        return this.propertySupport.getPropertyBool("multilineText");
    }

    @Override
    public void setMultilineText(boolean on) {
        this.propertySupport.setPropertyBool("multilineText", on);
    }

    @Override
    public int getRowHeightHint() {
        return this.propertySupport.getPropertyInt("rowHeightHint");
    }

    @Override
    public void setRowHeightHint(int h) {
        this.propertySupport.setPropertyInt("rowHeightHint", h);
    }

    @Override
    public boolean isInitialMultilineText() {
        return this.m_initialMultiLineText;
    }

    @Override
    public void setInitialMultilineText(boolean on) {
        this.m_initialMultiLineText = on;
    }

    @Override
    public boolean hasKeyboardNavigation() {
        return this.propertySupport.getPropertyBool("keyboardNavigation");
    }

    @Override
    public void setKeyboardNavigation(boolean on) {
        this.propertySupport.setPropertyBool("keyboardNavigation", on);
    }

    @Override
    public boolean isMultiSelect() {
        return this.propertySupport.getPropertyBool("multiSelect");
    }

    @Override
    public void setMultiSelect(boolean b) {
        this.propertySupport.setPropertyBool("multiSelect", b);
    }

    @Override
    public boolean isMultiCheck() {
        return this.propertySupport.getPropertyBool("multiCheck");
    }

    @Override
    public void setMultiCheck(boolean b) {
        this.propertySupport.setPropertyBool("multiCheck", b);
    }

    @Override
    public IBooleanColumn getCheckableColumn() {
        return this.m_checkableColumn;
    }

    @Override
    public void setCheckableColumn(IBooleanColumn checkableColumn) {
        this.m_checkableColumn = checkableColumn;
    }

    @Override
    public boolean isAutoDiscardOnDelete() {
        return this.m_autoDiscardOnDelete;
    }

    @Override
    public void setAutoDiscardOnDelete(boolean on) {
        this.m_autoDiscardOnDelete = on;
    }

    @Override
    public boolean isTableInitialized() {
        return this.m_initialized;
    }

    @Override
    public boolean isTableChanging() {
        return this.m_tableChanging > 0;
    }

    @Override
    public void setTableChanging(boolean b) {
        if (b) {
            ++this.m_tableChanging;
            if (this.m_tableChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_tableChanging > 0) {
            Throwable saveEx;
            block17: {
                saveEx = null;
                if (this.m_tableChanging == 1) {
                    try {
                        this.processDecorationBuffer();
                        if (!this.m_sortValid) {
                            this.sort();
                        }
                    }
                    catch (Throwable t) {
                        saveEx = t;
                    }
                }
                --this.m_tableChanging;
                if (this.m_tableChanging == 0) {
                    block16: {
                        try {
                            this.processEventBuffer();
                        }
                        catch (Throwable t) {
                            if (saveEx != null) break block16;
                            saveEx = t;
                        }
                    }
                    try {
                        this.propertySupport.setPropertiesChanging(false);
                    }
                    catch (Throwable t) {
                        if (saveEx != null) break block17;
                        saveEx = t;
                    }
                }
            }
            if (saveEx == null) {
                return;
            }
            if (saveEx instanceof RuntimeException) {
                throw (RuntimeException)saveEx;
            }
            if (saveEx instanceof Error) {
                throw (Error)saveEx;
            }
        }
    }

    @Override
    public IKeyStroke[] getKeyStrokes() {
        IKeyStroke[] keyStrokes = (IKeyStroke[])this.propertySupport.getProperty("keyStroks");
        if (keyStrokes == null) {
            keyStrokes = new IKeyStroke[]{};
        }
        return keyStrokes;
    }

    @Override
    public void setKeyStrokes(IKeyStroke[] keyStrokes) {
        this.propertySupport.setProperty("keyStroks", (Object)keyStrokes);
    }

    @Override
    public void requestFocus() {
        this.fireRequestFocus();
    }

    @Override
    public void requestFocusInCell(IColumn<?> column, ITableRow row) {
        if (this.isCellEditable(row, column)) {
            this.fireRequestFocusInCell(column, row);
        }
    }

    @ConfigOperation
    @Order(value=130.0)
    protected TableRowDataMapper execCreateTableRowDataMapper(Class<? extends AbstractTableRowData> rowType) throws ProcessingException {
        return new TableRowDataMapper(rowType, this.getColumnSet());
    }

    @Override
    public void exportToTableBeanData(AbstractTableFieldBeanData target) throws ProcessingException {
        TableRowDataMapper rowMapper = this.execCreateTableRowDataMapper(target.getRowType());
        int i = 0;
        int ni = this.getRowCount();
        while (i < ni) {
            ITableRow row = this.getRow(i);
            AbstractTableRowData rowData = target.addRow();
            rowMapper.exportTableRowData(row, rowData);
            ++i;
        }
        ITableRow[] deletedRows = this.getDeletedRows();
        int i2 = 0;
        int ni2 = deletedRows.length;
        while (i2 < ni2) {
            ITableRow row = deletedRows[i2];
            AbstractTableRowData rowData = target.addRow();
            rowMapper.exportTableRowData(row, rowData);
            rowData.setRowState(3);
            ++i2;
        }
    }

    @Override
    public void importFromTableBeanData(AbstractTableFieldBeanData source) throws ProcessingException {
        TableRow newTableRow;
        AbstractTableRowData rowData;
        this.discardAllDeletedRows();
        this.clearValidatedValuesOnAllColumns();
        this.clearAllRowsValidity();
        int deleteCount = 0;
        ArrayList<TableRow> newRows = new ArrayList<TableRow>();
        TableRowDataMapper mapper = this.execCreateTableRowDataMapper(source.getRowType());
        int i = 0;
        int ni = source.getRowCount();
        while (i < ni) {
            rowData = source.rowAt(i);
            if (rowData.getRowState() != 3) {
                newTableRow = new TableRow(this.getColumnSet());
                mapper.importTableRowData(newTableRow, rowData);
                newRows.add(newTableRow);
            } else {
                ++deleteCount;
            }
            ++i;
        }
        this.replaceRows(newRows.toArray(new ITableRow[newRows.size()]));
        if (deleteCount > 0) {
            try {
                this.setTableChanging(true);
                i = 0;
                ni = source.getRowCount();
                while (i < ni) {
                    rowData = source.rowAt(i);
                    if (rowData.getRowState() == 3) {
                        newTableRow = new TableRow(this.getColumnSet());
                        mapper.importTableRowData(newTableRow, rowData);
                        newTableRow.setStatus(0);
                        ITableRow addedRow = this.addRow(newTableRow);
                        this.deleteRow(addedRow);
                    }
                    ++i;
                }
            }
            finally {
                this.setTableChanging(false);
            }
        }
    }

    @Override
    public void extractTableData(AbstractTableFieldData target) throws ProcessingException {
        int i = 0;
        int ni = this.getRowCount();
        while (i < ni) {
            ITableRow row = this.getRow(i);
            int newRowIndex = target.addRow();
            int j = 0;
            int nj = row.getCellCount();
            while (j < nj) {
                target.setValueAt(newRowIndex, j, row.getCellValue(j));
                ++j;
            }
            target.setRowState(newRowIndex, row.getStatus());
            ++i;
        }
        ITableRow[] deletedRows = this.getDeletedRows();
        int i2 = 0;
        int ni2 = deletedRows.length;
        while (i2 < ni2) {
            ITableRow row = deletedRows[i2];
            int newRowIndex = target.addRow();
            int j = 0;
            int nj = row.getCellCount();
            while (j < nj) {
                target.setValueAt(newRowIndex, j, row.getCellValue(j));
                ++j;
            }
            target.setRowState(newRowIndex, 3);
            ++i2;
        }
        target.setValueSet(true);
    }

    @Override
    public void updateTable(AbstractTableFieldData source) throws ProcessingException {
        if (source.isValueSet()) {
            int nj;
            TableRow newTableRow;
            int importState;
            this.clearValidatedValuesOnAllColumns();
            this.clearAllRowsValidity();
            this.discardAllDeletedRows();
            int deleteCount = 0;
            ArrayList<TableRow> newRows = new ArrayList<TableRow>();
            int i = 0;
            int ni = source.getRowCount();
            while (i < ni) {
                importState = source.getRowState(i);
                if (importState != 3) {
                    newTableRow = new TableRow(this.getColumnSet());
                    int j = 0;
                    nj = source.getColumnCount();
                    while (j < nj) {
                        if (j < this.getColumnCount()) {
                            this.getColumnSet().getColumn(j).setValue(newTableRow, source.getValueAt(i, j));
                        } else {
                            newTableRow.setCellValue(j, source.getValueAt(i, j));
                        }
                        ++j;
                    }
                    newTableRow.setStatus(importState);
                    newRows.add(newTableRow);
                } else {
                    ++deleteCount;
                }
                ++i;
            }
            this.replaceRows(newRows.toArray(new ITableRow[newRows.size()]));
            if (deleteCount > 0) {
                try {
                    this.setTableChanging(true);
                    i = 0;
                    ni = source.getRowCount();
                    while (i < ni) {
                        importState = source.getRowState(i);
                        if (importState == 3) {
                            newTableRow = new TableRow(this.getColumnSet());
                            int j = 0;
                            nj = source.getColumnCount();
                            while (j < nj) {
                                if (j < this.getColumnCount()) {
                                    this.getColumnSet().getColumn(j).setValue(newTableRow, source.getValueAt(i, j));
                                } else {
                                    newTableRow.setCellValue(j, source.getValueAt(i, j));
                                }
                                ++j;
                            }
                            newTableRow.setStatus(0);
                            ITableRow addedRow = this.addRow(newTableRow);
                            this.deleteRow(addedRow);
                        }
                        ++i;
                    }
                }
                finally {
                    this.setTableChanging(false);
                }
            }
        }
    }

    @Override
    public IMenu[] getMenus() {
        return this.m_menus;
    }

    @Override
    public <T extends IMenu> T getMenu(Class<T> menuType) throws ProcessingException {
        return (T)((IMenu)new ActionFinder().findAction(this.getMenus(), menuType));
    }

    @Override
    public boolean runMenu(Class<? extends IMenu> menuType) throws ProcessingException {
        Class<? extends IMenu> c = this.getReplacingMenuClass(menuType);
        IMenu[] iMenuArray = this.getMenus();
        int n = iMenuArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu m = iMenuArray[n2];
            if (m.getClass() == c) {
                if (!m.isEnabledProcessingAction()) {
                    return false;
                }
                if (!m.isInheritAccessibility() || this.isEnabled()) {
                    m.prepareAction();
                    if (m.isVisible() && m.isEnabled()) {
                        m.doAction();
                        return true;
                    }
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    private <T extends IMenu> Class<? extends T> getReplacingMenuClass(Class<T> c) {
        Class<? extends IMenu> replacingMenuClass;
        if (this.m_menuReplacementMapping != null && (replacingMenuClass = this.m_menuReplacementMapping.get(c)) != null) {
            return replacingMenuClass;
        }
        return c;
    }

    protected ITableColumnFilterManager createColumnFilterManager() {
        return new DefaultTableColumnFilterManager(this);
    }

    protected ITableCustomizer createTableCustomizer() {
        return null;
    }

    public ITableRow createRow() throws ProcessingException {
        return new P_TableRowBuilder().createRow();
    }

    public ITableRow createRow(Object rowValues) throws ProcessingException {
        return new P_TableRowBuilder().createRow(rowValues);
    }

    public ITableRow[] createRowsByArray(Object dataArray) throws ProcessingException {
        return new P_TableRowBuilder().createRowsByArray(dataArray);
    }

    public ITableRow[] createRowsByArray(Object dataArray, int rowStatus) throws ProcessingException {
        return new P_TableRowBuilder().createRowsByArray(dataArray, rowStatus);
    }

    public ITableRow[] createRowsByMatrix(Object dataMatrixOrReference) throws ProcessingException {
        return new P_TableRowBuilder().createRowsByMatrix(dataMatrixOrReference);
    }

    public ITableRow[] createRowsByMatrix(Object dataMatrixOrReference, int rowStatus) throws ProcessingException {
        return new P_TableRowBuilder().createRowsByMatrix(dataMatrixOrReference, rowStatus);
    }

    public ITableRow[] createRowsByCodes(ICode[] codes) throws ProcessingException {
        return new P_TableRowBuilder().createRowsByCodes(codes);
    }

    @Override
    public void replaceRowsByMatrix(Object dataMatrixOrReference) throws ProcessingException {
        this.replaceRows(this.createRowsByMatrix(dataMatrixOrReference));
    }

    @Override
    public void replaceRowsByArray(Object dataArray) throws ProcessingException {
        this.replaceRows(this.createRowsByArray(dataArray));
    }

    @Override
    public void replaceRows(ITableRow[] newRows) throws ProcessingException {
        if (this.isAutoDiscardOnDelete()) {
            this.replaceRowsCase1(newRows);
        } else {
            this.replaceRowsCase2(newRows);
        }
    }

    private void replaceRowsCase1(ITableRow[] newRows) throws ProcessingException {
        try {
            this.setTableChanging(true);
            ArrayList<CompositeObject> selectedKeys = new ArrayList<CompositeObject>();
            ITableRow[] iTableRowArray = this.getSelectedRows();
            int n = iTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITableRow r = iTableRowArray[n2];
                selectedKeys.add(new CompositeObject(this.getRowKeys(r)));
                ++n2;
            }
            this.discardAllRows();
            this.addRows(newRows, false);
            ArrayList<ITableRow> selectedRows = new ArrayList<ITableRow>();
            if (selectedKeys.size() > 0) {
                for (ITableRow r : this.m_rows) {
                    if (!selectedKeys.remove(new CompositeObject(this.getRowKeys(r)))) continue;
                    selectedRows.add(r);
                    if (selectedKeys.size() == 0) break;
                }
            }
            this.selectRows(selectedRows.toArray(new ITableRow[selectedRows.size()]), false);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void replaceRowsCase2(ITableRow[] newRows) throws ProcessingException {
        try {
            this.setTableChanging(true);
            int[] oldToNew = new int[this.getRowCount()];
            int[] newToOld = new int[newRows.length];
            Arrays.fill(oldToNew, -1);
            Arrays.fill(newToOld, -1);
            HashMap<CompositeObject, Integer> newRowIndexMap = new HashMap<CompositeObject, Integer>();
            int i = newRows.length - 1;
            while (i >= 0) {
                newRowIndexMap.put(new CompositeObject(this.getRowKeys(newRows[i])), i);
                --i;
            }
            int mappedCount = 0;
            int i2 = 0;
            int ni = this.getRowCount();
            while (i2 < ni) {
                ITableRow existingRow = this.m_rows.get(i2);
                Integer newIndex = (Integer)newRowIndexMap.remove(new CompositeObject(this.getRowKeys(existingRow)));
                if (newIndex != null) {
                    oldToNew[i2] = newIndex;
                    newToOld[newIndex.intValue()] = i2;
                    ++mappedCount;
                }
                ++i2;
            }
            ITableRow[] updatedRows = new ITableRow[mappedCount];
            int index = 0;
            int i3 = 0;
            while (i3 < oldToNew.length) {
                if (oldToNew[i3] >= 0) {
                    ITableRow oldRow = this.getRow(i3);
                    ITableRow newRow = newRows[oldToNew[i3]];
                    try {
                        oldRow.setRowChanging(true);
                        oldRow.setEnabled(newRow.isEnabled());
                        oldRow.setStatus(newRow.getStatus());
                        int columnIndex = 0;
                        while (columnIndex < this.getColumnCount()) {
                            if (columnIndex < newRow.getCellCount()) {
                                oldRow.getCellForUpdate(columnIndex).updateFrom(newRow.getCell(columnIndex));
                            } else {
                                oldRow.getCellForUpdate(columnIndex).setText(null);
                                oldRow.getCellForUpdate(columnIndex).setValue(null);
                            }
                            ++columnIndex;
                        }
                    }
                    finally {
                        oldRow.setRowPropertiesChanged(false);
                        oldRow.setRowChanging(false);
                    }
                    updatedRows[index] = oldRow;
                    ++index;
                }
                ++i3;
            }
            ITableRow[] deletedRows = new ITableRow[this.getRowCount() - mappedCount];
            index = 0;
            int i4 = 0;
            while (i4 < oldToNew.length) {
                if (oldToNew[i4] < 0) {
                    deletedRows[index] = this.m_rows.get(i4);
                    ++index;
                }
                ++i4;
            }
            ITableRow[] insertedRows = new ITableRow[newRows.length - mappedCount];
            int[] insertedRowIndexes = new int[newRows.length - mappedCount];
            index = 0;
            int i5 = 0;
            while (i5 < newToOld.length) {
                if (newToOld[i5] < 0) {
                    insertedRows[index] = newRows[i5];
                    insertedRowIndexes[index] = i5;
                    ++index;
                }
                ++i5;
            }
            this.updateRows(updatedRows);
            this.deleteRows(deletedRows);
            this.addRows(insertedRows, false, insertedRowIndexes);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void updateRow(ITableRow row) {
        if (row != null) {
            this.updateRows(new ITableRow[]{row});
        }
    }

    @Override
    public void updateAllRows() {
        ITableRow[] rows = this.getRows();
        this.updateRows(rows);
    }

    @Override
    public void setRowState(ITableRow row, int rowState) throws ProcessingException {
        this.setRowState(new ITableRow[]{row}, rowState);
    }

    @Override
    public void setAllRowState(int rowState) throws ProcessingException {
        this.setRowState(this.getRows(), rowState);
    }

    @Override
    public void setRowState(ITableRow[] rows, int rowState) throws ProcessingException {
        try {
            this.setTableChanging(true);
            int i = 0;
            while (i < rows.length) {
                rows[i].setStatus(rowState);
                ++i;
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void updateRows(ITableRow[] rows) {
        try {
            this.setTableChanging(true);
            ArrayList<ITableRow> resolvedRowList = new ArrayList<ITableRow>(rows.length);
            int i = 0;
            while (i < rows.length) {
                ITableRow resolvedRow = this.resolveRow(rows[i]);
                if (resolvedRow != null) {
                    resolvedRowList.add(resolvedRow);
                    this.updateRowImpl(resolvedRow);
                }
                ++i;
            }
            if (resolvedRowList.size() > 0) {
                this.fireRowsUpdated(resolvedRowList.toArray(new ITableRow[resolvedRowList.size()]));
            }
            if (this.getColumnSet().getSortColumnCount() > 0) {
                if (this.isTableChanging()) {
                    this.m_sortValid = false;
                } else {
                    this.sort();
                }
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void updateRowImpl(ITableRow row) {
        if (row != null) {
            IColumn<?>[] iColumnArray = this.getColumns();
            int n = iColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                IColumn<?> col = iColumnArray[n2];
                if (col instanceof AbstractColumn) {
                    ((AbstractColumn)col).validateColumnValue(row);
                }
                ++n2;
            }
            this.enqueueDecorationTasks(row);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_rows.size();
    }

    @Override
    public int getDeletedRowCount() {
        return this.m_deletedRows.size();
    }

    @Override
    public int getSelectedRowCount() {
        return this.m_selectedRows.size();
    }

    @Override
    public ITableRow getSelectedRow() {
        if (this.m_selectedRows.size() > 0) {
            return this.m_selectedRows.first();
        }
        return null;
    }

    @Override
    public ITableRow[] getSelectedRows() {
        return this.m_selectedRows.toArray(new ITableRow[this.m_selectedRows.size()]);
    }

    @Override
    public boolean isSelectedRow(ITableRow row) {
        if ((row = this.resolveRow(row)) == null) {
            return false;
        }
        return this.m_selectedRows.contains(row);
    }

    @Override
    public void selectRow(int rowIndex) {
        this.selectRow(this.getRow(rowIndex));
    }

    @Override
    public void selectRow(ITableRow row) {
        this.selectRow(row, false);
    }

    @Override
    public void selectRow(ITableRow row, boolean append) {
        if (row != null) {
            this.selectRows(new ITableRow[]{row}, append);
        } else {
            this.selectRows(new ITableRow[0], append);
        }
    }

    @Override
    public void selectRows(ITableRow[] rows) {
        this.selectRows(rows, false);
    }

    @Override
    public void selectRows(ITableRow[] rows, boolean append) {
        rows = this.resolveRows(rows);
        TreeSet<ITableRow> newSelection = new TreeSet<ITableRow>(new RowIndexComparator());
        if (append) {
            newSelection.addAll(this.m_selectedRows);
            newSelection.addAll(Arrays.asList(rows));
        } else {
            newSelection.addAll(Arrays.asList(rows));
        }
        if (newSelection.size() > 1 && !this.isMultiSelect()) {
            ITableRow first = newSelection.first();
            newSelection.clear();
            newSelection.add(first);
        }
        if (!this.m_selectedRows.equals(newSelection)) {
            this.m_selectedRows = newSelection;
            this.fireRowsSelected(this.m_selectedRows.toArray(new ITableRow[this.m_selectedRows.size()]));
        }
    }

    @Override
    public void selectFirstRow() {
        this.selectRow(this.getRow(0));
    }

    @Override
    public void selectNextRow() {
        ITableRow row = this.getSelectedRow();
        if (row != null && row.getRowIndex() + 1 < this.getRowCount()) {
            this.selectRow(this.getRow(row.getRowIndex() + 1));
        } else if (row == null && this.getRowCount() > 0) {
            this.selectRow(0);
        }
    }

    @Override
    public void selectPreviousRow() {
        ITableRow row = this.getSelectedRow();
        if (row != null && row.getRowIndex() - 1 >= 0) {
            this.selectRow(this.getRow(row.getRowIndex() - 1));
        } else if (row == null && this.getRowCount() > 0) {
            this.selectRow(this.getRowCount() - 1);
        }
    }

    @Override
    public void selectLastRow() {
        this.selectRow(this.getRow(this.getRowCount() - 1));
    }

    @Override
    public void deselectRow(ITableRow row) {
        if (row != null) {
            this.deselectRows(new ITableRow[]{row});
        } else {
            this.deselectRows(new ITableRow[0]);
        }
    }

    @Override
    public void deselectRows(ITableRow[] rows) {
        if ((rows = this.resolveRows(rows)) != null && rows.length > 0) {
            TreeSet<ITableRow> newSelection = new TreeSet<ITableRow>(new RowIndexComparator());
            newSelection.addAll(this.m_selectedRows);
            if (newSelection.removeAll(Arrays.asList(rows))) {
                this.m_selectedRows = newSelection;
                this.fireRowsSelected(this.m_selectedRows.toArray(new ITableRow[this.m_selectedRows.size()]));
            }
        }
    }

    @Override
    public void selectAllRows() {
        this.selectRows(this.getRows(), false);
    }

    @Override
    public void deselectAllRows() {
        this.selectRow(null, false);
    }

    @Override
    public void selectAllEnabledRows() {
        ArrayList<ITableRow> newList = new ArrayList<ITableRow>();
        int i = 0;
        int ni = this.getRowCount();
        while (i < ni) {
            ITableRow row = this.getRow(i);
            if (row.isEnabled()) {
                newList.add(row);
            } else if (this.isSelectedRow(row)) {
                newList.add(row);
            }
            ++i;
        }
        this.selectRows(newList.toArray(new ITableRow[newList.size()]), false);
    }

    @Override
    public void deselectAllEnabledRows() {
        ITableRow[] selectedRows = this.getSelectedRows();
        ArrayList<ITableRow> newList = new ArrayList<ITableRow>();
        int i = 0;
        while (i < selectedRows.length) {
            if (selectedRows[i].isEnabled()) {
                newList.add(selectedRows[i]);
            }
            ++i;
        }
        this.deselectRows(newList.toArray(new ITableRow[newList.size()]));
    }

    @Override
    public ITableRow[] getCheckedRows() {
        ArrayList<ITableRow> list = new ArrayList<ITableRow>();
        ITableRow[] iTableRowArray = this.getRows();
        int n = iTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITableRow row = iTableRowArray[n2];
            if (row.isChecked()) {
                list.add(row);
            }
            ++n2;
        }
        return list.toArray(new ITableRow[list.size()]);
    }

    @Override
    public void checkRow(int row, boolean value) throws ProcessingException {
        this.checkRow(this.getRow(row), value);
    }

    @Override
    public void checkRow(ITableRow row, boolean value) throws ProcessingException {
        if (!row.isEnabled()) {
            return;
        }
        if (!this.isMultiCheck() && value && this.getCheckedRows().length > 0) {
            this.uncheckAllRows();
        }
        row.setChecked(value);
        if (this.getCheckableColumn() != null) {
            this.getCheckableColumn().setValue(row, Boolean.valueOf(value));
        }
    }

    @Override
    public void checkRows(ITableRow[] rows, boolean value) throws ProcessingException {
        if ((rows = this.resolveRows(rows)).length > 1 && !this.isMultiCheck()) {
            ITableRow first = rows[0];
            first.setChecked(value);
        } else {
            ITableRow[] iTableRowArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                ITableRow row = iTableRowArray[n2];
                this.checkRow(row, value);
                ++n2;
            }
        }
    }

    @Override
    public void checkAllRows() throws ProcessingException {
        try {
            this.setTableChanging(true);
            int i = 0;
            while (i < this.getRowCount()) {
                this.checkRow(i, true);
                ++i;
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void uncheckAllRows() throws ProcessingException {
        try {
            this.setTableChanging(true);
            int i = 0;
            while (i < this.getRowCount()) {
                this.checkRow(i, false);
                ++i;
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public String getDefaultIconId() {
        String iconId = this.propertySupport.getPropertyString("defaultIcon");
        if (iconId != null && iconId.length() == 0) {
            iconId = null;
        }
        return iconId;
    }

    @Override
    public void setDefaultIconId(String iconId) {
        this.propertySupport.setPropertyString("defaultIcon", iconId);
    }

    @Override
    public boolean isEnabled() {
        return this.propertySupport.getPropertyBool("enabled");
    }

    @Override
    public final void setEnabled(boolean b) {
        boolean changed = this.propertySupport.setPropertyBool("enabled", b);
        if (changed) {
            try {
                ITableRow[] rows;
                this.setTableChanging(true);
                ITableRow[] iTableRowArray = rows = this.getRows();
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    ITableRow row = iTableRowArray[n2];
                    this.enqueueDecorationTasks(row);
                    ++n2;
                }
            }
            finally {
                this.setTableChanging(false);
            }
        }
    }

    @Override
    public boolean isScrollToSelection() {
        return this.propertySupport.getPropertyBool("scrollToSelection");
    }

    @Override
    public void setScrollToSelection(boolean b) {
        this.propertySupport.setPropertyBool("scrollToSelection", b);
    }

    @Override
    public void scrollToSelection() {
        this.fireTableEventInternal(new TableEvent(this, 830));
    }

    @Override
    public ITableRow getRow(int rowIndex) {
        ITableRow row = null;
        ITableRow[] rows = this.getRows();
        if (rowIndex >= 0 && rowIndex < rows.length) {
            row = rows[rowIndex];
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITableRow[] getRows() {
        Object object = this.m_cachedRowsLock;
        synchronized (object) {
            if (this.m_cachedRows == null) {
                this.m_cachedRows = this.m_rows.toArray(new ITableRow[this.m_rows.size()]);
            }
            return this.m_cachedRows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITableRow[] getFilteredRows() {
        ITableRow[] rows = this.getRows();
        if (this.m_rowFilters.size() > 0) {
            Object object = this.m_cachedFilteredRowsLock;
            synchronized (object) {
                if (this.m_cachedFilteredRows == null) {
                    if (this.m_rowFilters.size() > 0) {
                        ArrayList<ITableRow> list = new ArrayList<ITableRow>(this.getRowCount());
                        ITableRow[] iTableRowArray = rows;
                        int n = rows.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITableRow row = iTableRowArray[n2];
                            if (row != null && row.isFilterAccepted()) {
                                list.add(row);
                            }
                            ++n2;
                        }
                        this.m_cachedFilteredRows = list.toArray(new ITableRow[list.size()]);
                    } else {
                        this.m_cachedFilteredRows = new ITableRow[0];
                    }
                }
                return this.m_cachedFilteredRows;
            }
        }
        return rows;
    }

    @Override
    public int getFilteredRowCount() {
        if (this.m_rowFilters.size() > 0) {
            return this.getFilteredRows().length;
        }
        return this.getRowCount();
    }

    @Override
    public ITableRow getFilteredRow(int index) {
        if (this.m_rowFilters.size() > 0) {
            ITableRow row = null;
            ITableRow[] filteredRows = this.getFilteredRows();
            if (index >= 0 && index < filteredRows.length) {
                row = filteredRows[index];
            }
            return row;
        }
        return this.getRow(index);
    }

    @Override
    public int getFilteredRowIndex(ITableRow row) {
        ITableRow[] filteredRows = this.getFilteredRows();
        int i = 0;
        while (i < filteredRows.length) {
            if (filteredRows[i].equals(row)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Object[][] getTableData() {
        Object[][] data = new Object[this.getRowCount()][this.getColumnCount()];
        int r = 0;
        while (r < this.getRowCount()) {
            int c = 0;
            while (c < this.getColumnCount()) {
                data[r][c] = this.getRow(r).getCellValue(c);
                ++c;
            }
            ++r;
        }
        return data;
    }

    @Override
    public Object[][] exportTableRowsAsCSV(ITableRow[] rows, IColumn<?>[] columns, boolean includeLineForColumnNames, boolean includeLineForColumnTypes, boolean includeLineForColumnFormats) {
        return TableUtility.exportRowsAsCSV(rows, columns, includeLineForColumnNames, includeLineForColumnTypes, includeLineForColumnFormats);
    }

    @Override
    public ITableRow[] getRows(int[] rowIndexes) {
        if (rowIndexes == null) {
            return new ITableRow[0];
        }
        ITableRow[] rows = new ITableRow[rowIndexes.length];
        int missingCount = 0;
        int i = 0;
        while (i < rowIndexes.length) {
            rows[i] = this.getRow(rowIndexes[i]);
            if (rows[i] == null) {
                ++missingCount;
            }
            ++i;
        }
        if (missingCount > 0) {
            ITableRow[] newRows = new ITableRow[rowIndexes.length - missingCount];
            int index = 0;
            int i2 = 0;
            while (i2 < rows.length) {
                if (rows[i2] != null) {
                    newRows[index] = rows[i2];
                    ++index;
                }
                ++i2;
            }
            rows = newRows;
        }
        return rows;
    }

    @Override
    public ITableRow[] getDeletedRows() {
        return this.m_deletedRows.values().toArray(new ITableRow[this.m_deletedRows.size()]);
    }

    @Override
    public int getInsertedRowCount() {
        int count = 0;
        ITableRow[] rows = this.getRows();
        int i = 0;
        int ni = rows.length;
        while (i < ni) {
            if (rows[i].getStatus() == 1) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public ITableRow[] getInsertedRows() {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        ITableRow[] rows = this.getRows();
        int i = 0;
        int ni = rows.length;
        while (i < ni) {
            ITableRow row = rows[i];
            if (row.getStatus() == 1) {
                rowList.add(row);
            }
            ++i;
        }
        return rowList.toArray(new ITableRow[rowList.size()]);
    }

    @Override
    public int getUpdatedRowCount() {
        int count = 0;
        ITableRow[] rows = this.getRows();
        int i = 0;
        int ni = rows.length;
        while (i < ni) {
            if (rows[i].getStatus() == 2) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public ITableRow[] getUpdatedRows() {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        ITableRow[] rows = this.getRows();
        int i = 0;
        int ni = rows.length;
        while (i < ni) {
            ITableRow row = rows[i];
            if (row.getStatus() == 2) {
                rowList.add(row);
            }
            ++i;
        }
        return rowList.toArray(new ITableRow[rowList.size()]);
    }

    @Override
    public ITableRow addRowByArray(Object dataArray) throws ProcessingException {
        if (dataArray == null) {
            return null;
        }
        ITableRow[] a = this.addRowsByMatrix(new Object[]{dataArray});
        if (a.length > 0) {
            return a[0];
        }
        return null;
    }

    @Override
    public ITableRow[] addRowsByMatrix(Object dataMatrix) throws ProcessingException {
        return this.addRowsByMatrix(dataMatrix, 1);
    }

    @Override
    public ITableRow[] addRowsByMatrix(Object dataMatrix, int rowStatus) throws ProcessingException {
        return this.addRows(this.createRowsByMatrix(dataMatrix, rowStatus));
    }

    @Override
    public ITableRow[] addRowsByArray(Object dataArray) throws ProcessingException {
        return this.addRowsByArray(dataArray, 1);
    }

    @Override
    public ITableRow[] addRowsByArray(Object dataArray, int rowStatus) throws ProcessingException {
        return this.addRows(this.createRowsByArray(dataArray, rowStatus));
    }

    @Override
    public ITableRow addRow(ITableRow newRow) throws ProcessingException {
        return this.addRow(newRow, false);
    }

    @Override
    public ITableRow addRow(ITableRow newRow, boolean markAsInserted) throws ProcessingException {
        ITableRow[] addedRows = this.addRows(new ITableRow[]{newRow}, markAsInserted);
        if (addedRows.length > 0) {
            return addedRows[0];
        }
        return null;
    }

    @Override
    public ITableRow[] addRows(ITableRow[] newRows) throws ProcessingException {
        return this.addRows(newRows, false);
    }

    @Override
    public ITableRow[] addRows(ITableRow[] newRows, boolean markAsInserted) throws ProcessingException {
        return this.addRows(newRows, markAsInserted, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ITableRow[] addRows(ITableRow[] newRows, boolean markAsInserted, int[] insertIndexes) throws ProcessingException {
        if (newRows == null || newRows.length == 0) {
            return new ITableRow[0];
        }
        try {
            block13: {
                block12: {
                    this.setTableChanging(true);
                    oldRowCount = this.m_rows.size();
                    newIRows = new ITableRow[newRows.length];
                    i = 0;
                    while (i < newRows.length) {
                        newIRows[i] = this.addRowImpl(newRows[i], markAsInserted);
                        ++i;
                    }
                    this.fireRowsInserted(newIRows);
                    if (this.getColumnSet().getSortColumnCount() <= 0) break block12;
                    if (this.isTableChanging()) {
                        this.m_sortValid = false;
                    } else {
                        this.sort();
                    }
                    break block13;
                }
                if (insertIndexes == null) break block13;
                sortArray = new ITableRow[this.m_rows.size()];
                i = 0;
                while (i < insertIndexes.length) {
                    sortArray[insertIndexes[i]] = newIRows[i];
                    ++i;
                }
                sortArrayIndex = 0;
                i = 0;
                ** GOTO lbl35
                {
                    ++sortArrayIndex;
                    do {
                        if (sortArray[sortArrayIndex] != null) continue block5;
                        sortArray[sortArrayIndex] = this.m_rows.get(i);
                        ++i;
lbl35:
                        // 2 sources

                    } while (i < oldRowCount);
                }
                i = insertIndexes.length;
                ** GOTO lbl43
                {
                    ++sortArrayIndex;
                    do {
                        if (sortArray[sortArrayIndex] != null) continue block7;
                        sortArray[sortArrayIndex] = newIRows[i];
                        ++i;
lbl43:
                        // 2 sources

                    } while (i < newIRows.length);
                }
                this.sortInternal(sortArray);
            }
            var10_10 = newIRows;
            return var10_10;
        }
        finally {
            this.setTableChanging(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITableRow addRowImpl(ITableRow newRow, boolean markAsInserted) throws ProcessingException {
        IColumn<?> col;
        if (markAsInserted) {
            newRow.setStatus(1);
        }
        InternalTableRow newIRow = new InternalTableRow(this, newRow);
        IColumn<?>[] iColumnArray = this.getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            col = iColumnArray[n2];
            if (col instanceof AbstractColumn) {
                ((AbstractColumn)col).validateColumnValue(newIRow);
            }
            ++n2;
        }
        this.wasEverValid(newIRow);
        col = this.m_cachedRowsLock;
        synchronized (col) {
            this.m_cachedRows = null;
        }
        int newIndex = this.m_rows.size();
        newIRow.setRowIndex(newIndex);
        newIRow.setTableInternal(this);
        this.m_rows.add(newIRow);
        this.enqueueDecorationTasks(newIRow);
        return newIRow;
    }

    @Override
    public void moveRow(int sourceIndex, int targetIndex) {
        this.moveRowImpl(sourceIndex, targetIndex);
    }

    @Override
    public void moveRowBefore(ITableRow movingRow, ITableRow targetRow) {
        movingRow = this.resolveRow(movingRow);
        targetRow = this.resolveRow(targetRow);
        if (movingRow != null && targetRow != null) {
            this.moveRowImpl(movingRow.getRowIndex(), targetRow.getRowIndex());
        }
    }

    @Override
    public void moveRowAfter(ITableRow movingRow, ITableRow targetRow) {
        movingRow = this.resolveRow(movingRow);
        targetRow = this.resolveRow(targetRow);
        if (movingRow != null && targetRow != null) {
            this.moveRowImpl(movingRow.getRowIndex(), targetRow.getRowIndex() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveRowImpl(int sourceIndex, int targetIndex) {
        if (sourceIndex < 0) {
            sourceIndex = 0;
        }
        if (sourceIndex >= this.getRowCount()) {
            sourceIndex = this.getRowCount() - 1;
        }
        if (targetIndex < 0) {
            targetIndex = 0;
        }
        if (targetIndex >= this.getRowCount()) {
            targetIndex = this.getRowCount() - 1;
        }
        if (targetIndex != sourceIndex) {
            Object object = this.m_cachedRowsLock;
            synchronized (object) {
                this.m_cachedRows = null;
            }
            ITableRow row = this.m_rows.remove(sourceIndex);
            this.m_rows.add(targetIndex, row);
            int min = Math.min(sourceIndex, targetIndex);
            int max = Math.max(sourceIndex, targetIndex);
            ITableRow[] changedRows = new ITableRow[max - min + 1];
            int i = min;
            while (i <= max) {
                changedRows[i - min] = this.getRow(i);
                ((InternalTableRow)changedRows[i - min]).setRowIndex(i);
                ++i;
            }
            this.fireRowOrderChanged();
            this.selectRows(this.getSelectedRows(), false);
        }
    }

    @Override
    public void deleteRow(int rowIndex) {
        this.deleteRows(new int[]{rowIndex});
    }

    @Override
    public void deleteRows(int[] rowIndexes) {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        int i = 0;
        while (i < rowIndexes.length) {
            ITableRow row = this.getRow(rowIndexes[i]);
            if (row != null) {
                rowList.add(row);
            }
            ++i;
        }
        this.deleteRows(rowList.toArray(new ITableRow[rowList.size()]));
    }

    @Override
    public void deleteRow(ITableRow row) {
        if (row != null) {
            this.deleteRows(new ITableRow[]{row});
        }
    }

    @Override
    public void deleteAllRows() {
        this.deleteRows(this.getRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRows(ITableRow[] rows) {
        ITableRow[] existingRows = this.getRows();
        if (rows != existingRows) {
            rows = this.resolveRows(rows);
        }
        if (rows != null && rows.length > 0) {
            try {
                ITableRow candidateRow;
                int i;
                Object row;
                this.setTableChanging(true);
                int rowCountBefore = this.getRowCount();
                int min = this.getRowCount();
                int max = 0;
                int i2 = 0;
                while (i2 < rows.length) {
                    row = rows[i2];
                    min = Math.min(min, row.getRowIndex());
                    max = Math.max(max, row.getRowIndex());
                    ++i2;
                }
                ITableRow[] deletedRows = rows;
                this.deselectRows(deletedRows);
                if (rows == existingRows) {
                    this.m_rows.clear();
                    row = this.m_cachedRowsLock;
                    synchronized (row) {
                        this.m_cachedRows = null;
                    }
                    this.clearValidatedValuesOnAllColumns();
                    this.clearAllRowsValidity();
                    i = deletedRows.length - 1;
                    while (i >= 0) {
                        candidateRow = deletedRows[i];
                        if (candidateRow != null) {
                            this.deleteRowImpl(candidateRow);
                        }
                        --i;
                    }
                } else {
                    i = deletedRows.length - 1;
                    while (i >= 0) {
                        boolean removed;
                        candidateRow = deletedRows[i];
                        if (candidateRow != null && (removed = this.m_rows.remove(candidateRow))) {
                            Object object = this.m_cachedRowsLock;
                            synchronized (object) {
                                this.m_cachedRows = null;
                            }
                            this.clearValidatedValueOnColumns(candidateRow);
                            this.clearRowValidity(candidateRow);
                            this.deleteRowImpl(candidateRow);
                        }
                        --i;
                    }
                }
                HashSet<ITableRow> selectionRows = new HashSet<ITableRow>(Arrays.asList(this.getSelectedRows()));
                int minAffectedIndex = Math.max(min - 1, 0);
                ITableRow[] affectedRows = new ITableRow[this.getRowCount() - minAffectedIndex];
                int i3 = minAffectedIndex;
                while (i3 < this.getRowCount()) {
                    affectedRows[i3 - minAffectedIndex] = this.getRow(i3);
                    ((InternalTableRow)affectedRows[i3 - minAffectedIndex]).setRowIndex(i3);
                    selectionRows.remove(this.getRow(i3));
                    ++i3;
                }
                if (rowCountBefore == deletedRows.length) {
                    this.fireAllRowsDeleted(deletedRows);
                } else {
                    this.fireRowsDeleted(deletedRows);
                }
                this.selectRows(selectionRows.toArray(new ITableRow[selectionRows.size()]), false);
            }
            finally {
                this.setTableChanging(false);
            }
        }
    }

    private void deleteRowImpl(ITableRow row) {
        if (!(row instanceof InternalTableRow)) {
            return;
        }
        InternalTableRow internalRow = (InternalTableRow)row;
        if (this.isAutoDiscardOnDelete()) {
            internalRow.setTableInternal(null);
        } else if (internalRow.getStatus() == 1) {
            internalRow.setTableInternal(null);
        } else {
            internalRow.setStatus(3);
            this.m_deletedRows.put(new CompositeObject(this.getRowKeys(internalRow)), internalRow);
        }
    }

    private void clearValidatedValuesOnAllColumns() {
        IColumn[] iColumnArray = this.getColumnSet().getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn column = iColumnArray[n2];
            if (column instanceof AbstractColumn) {
                ((AbstractColumn)column).clearValidatedValues();
            }
            ++n2;
        }
    }

    private void clearValidatedValueOnColumns(ITableRow row) {
        IColumn[] iColumnArray = this.getColumnSet().getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn column = iColumnArray[n2];
            if (column instanceof AbstractColumn) {
                ((AbstractColumn)column).clearValidatedValue(row);
            }
            ++n2;
        }
    }

    @Override
    public void discardRow(int rowIndex) {
        this.discardRows(new int[]{rowIndex});
    }

    @Override
    public void discardRows(int[] rowIndexes) {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        int i = 0;
        while (i < rowIndexes.length) {
            ITableRow row = this.getRow(rowIndexes[i]);
            if (row != null) {
                rowList.add(row);
            }
            ++i;
        }
        this.discardRows(rowList.toArray(new ITableRow[rowList.size()]));
    }

    @Override
    public void discardRow(ITableRow row) {
        if (row != null) {
            this.discardRows(new ITableRow[]{row});
        }
    }

    @Override
    public void discardAllRows() {
        this.discardRows(this.getRows());
    }

    @Override
    public void discardRows(ITableRow[] rows) {
        try {
            this.setTableChanging(true);
            int i = 0;
            while (i < rows.length) {
                ((InternalTableRow)rows[i]).setStatus(1);
                ++i;
            }
            this.deleteRows(rows);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void discardAllDeletedRows() {
        Iterator<ITableRow> it = this.m_deletedRows.values().iterator();
        while (it.hasNext()) {
            ((InternalTableRow)it.next()).setTableInternal(null);
        }
        this.m_deletedRows.clear();
    }

    @Override
    public void discardDeletedRow(ITableRow deletedRow) {
        if (deletedRow != null) {
            this.discardDeletedRows(new ITableRow[]{deletedRow});
        }
    }

    @Override
    public void discardDeletedRows(ITableRow[] deletedRows) {
        if (deletedRows != null) {
            ITableRow[] iTableRowArray = deletedRows;
            int n = deletedRows.length;
            int n2 = 0;
            while (n2 < n) {
                ITableRow row = iTableRowArray[n2];
                this.m_deletedRows.remove(new CompositeObject(this.getRowKeys(row)));
                ((InternalTableRow)row).setTableInternal(null);
                ++n2;
            }
        }
    }

    @Override
    public void setContextColumn(IColumn<?> col) {
        this.propertySupport.setProperty("contextColumn", col);
    }

    @Override
    public IColumn<?> getContextColumn() {
        return (IColumn)this.propertySupport.getProperty("contextColumn");
    }

    @Override
    @Deprecated
    public void clearDeletedRows() {
        this.discardAllDeletedRows();
    }

    @Override
    public Object[] getRowKeys(int rowIndex) {
        ITableRow row = this.getRow(rowIndex);
        return this.getRowKeys(row);
    }

    @Override
    public Object[] getRowKeys(ITableRow row) {
        Object[] keys = new Object[]{};
        if (row != null) {
            keys = row.getKeyValues();
        }
        return keys;
    }

    @Override
    public ITableRow findRowByKey(Object[] keys) {
        IColumn[] keyColumns = this.getColumnSet().getKeyColumns();
        if (keyColumns.length == 0) {
            keyColumns = this.getColumnSet().getColumns();
        }
        for (ITableRow row : this.m_rows) {
            boolean match = true;
            if (keys != null && keys.length > 0) {
                int i = 0;
                while (i < keyColumns.length && i < keys.length) {
                    if (!CompareUtility.equals(keyColumns[i].getValue(row), (Object)keys[i])) {
                        match = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!match) continue;
            return row;
        }
        return null;
    }

    @Override
    public ITableColumnFilterManager getColumnFilterManager() {
        return this.m_columnFilterManager;
    }

    @Override
    public void setColumnFilterManager(ITableColumnFilterManager m) {
        this.m_columnFilterManager = m;
    }

    @Override
    public ITableCustomizer getTableCustomizer() {
        return this.m_tableCustomizer;
    }

    @Override
    public void setTableCustomizer(ITableCustomizer c) {
        this.m_tableCustomizer = c;
    }

    @Override
    public Object getContainer() {
        return this.propertySupport.getProperty("container");
    }

    public void setContainerInternal(Object container) {
        this.propertySupport.setProperty("container", container);
    }

    @Override
    public boolean isSortEnabled() {
        return this.m_sortEnabled;
    }

    @Override
    public void setSortEnabled(boolean b) {
        this.m_sortEnabled = b;
    }

    @Override
    public void sort() {
        try {
            IColumn[] sortCols;
            if (this.isSortEnabled() && (sortCols = this.getColumnSet().getSortColumns()).length > 0) {
                this.processDecorationBuffer();
                ITableRow[] a = this.getRows();
                Arrays.sort(a, new TableRowComparator(sortCols));
                this.sortInternal(a);
            }
        }
        finally {
            this.m_sortValid = true;
        }
    }

    @Override
    public void sort(ITableRow[] rowsInNewOrder) {
        ITableRow[] resolvedRows = this.resolveRows(rowsInNewOrder);
        if (resolvedRows.length == rowsInNewOrder.length) {
            this.sortInternal(resolvedRows);
        } else {
            ArrayList<ITableRow> list = new ArrayList<ITableRow>();
            list.addAll(this.m_rows);
            list.removeAll(Arrays.asList(resolvedRows));
            ArrayList<ITableRow> sortedList = new ArrayList<ITableRow>();
            sortedList.addAll(Arrays.asList(resolvedRows));
            sortedList.addAll(list);
            this.sortInternal(sortedList.toArray(new ITableRow[sortedList.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortInternal(ITableRow[] resolvedRows) {
        int i22 = 0;
        while (i22 < resolvedRows.length) {
            ((InternalTableRow)resolvedRows[i22]).setRowIndex(i22);
            ++i22;
        }
        Object i22 = this.m_cachedRowsLock;
        synchronized (i22) {
            this.m_cachedRows = null;
            this.m_rows.clear();
            this.m_rows.addAll(Arrays.asList(resolvedRows));
        }
        if (this.m_selectedRows != null && this.m_selectedRows.size() > 0) {
            TreeSet<ITableRow> newSelection = new TreeSet<ITableRow>(new RowIndexComparator());
            newSelection.addAll(this.m_selectedRows);
            this.m_selectedRows = newSelection;
        }
        this.fireRowOrderChanged();
    }

    @Override
    public void resetColumnConfiguration() {
        this.discardAllRows();
        try {
            IColumn<?> col;
            this.setTableChanging(true);
            HashMap<String, Boolean> displayableState = new HashMap<String, Boolean>();
            IColumn<?>[] iColumnArray = this.getColumns();
            int n = iColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                col = iColumnArray[n2];
                displayableState.put(col.getColumnId(), col.isDisplayable());
                ++n2;
            }
            this.disposeColumnsInternal();
            this.createColumnsInternal();
            this.initColumnsInternal();
            iColumnArray = this.getColumns();
            n = iColumnArray.length;
            n2 = 0;
            while (n2 < n) {
                col = iColumnArray[n2];
                if (displayableState.get(col.getColumnId()) != null) {
                    col.setDisplayable((Boolean)displayableState.get(col.getColumnId()));
                }
                ++n2;
            }
            ITableColumnFilterManager filterManager = this.getColumnFilterManager();
            if (filterManager != null && filterManager.getFilters() != null) {
                IColumn<?>[] iColumnArray2 = this.getColumns();
                int n3 = iColumnArray2.length;
                n = 0;
                while (n < n3) {
                    IColumn<?> col2 = iColumnArray2[n];
                    for (ITableColumnFilter filter : filterManager.getFilters()) {
                        if (!filter.getColumn().getClass().equals(col2.getClass())) continue;
                        filter.setColumn(col2);
                    }
                    filterManager.refresh();
                    ++n;
                }
            }
            this.fireTableEventInternal(new TableEvent(this, 1));
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void resetColumnVisibilities() {
        this.resetColumns(true, false, false, false);
    }

    @Override
    public void resetColumnOrder() {
        this.resetColumns(false, true, false, false);
    }

    @Override
    public void resetColumnSortOrder() {
        this.resetColumns(false, false, true, false);
    }

    @Override
    public void resetColumnWidths() {
        this.resetColumns(false, false, false, true);
    }

    @Override
    public void resetDisplayableColumns() {
        this.resetColumns(true, true, true, true);
    }

    @Override
    public void resetColumns(boolean visibility, boolean order, boolean sorting, boolean widths) {
        try {
            this.setTableChanging(true);
            try {
                if (sorting) {
                    this.m_sortValid = false;
                }
                this.resetColumnsInternal(visibility, order, sorting, widths);
                this.execResetColumns(visibility, order, sorting, widths);
            }
            catch (Throwable t) {
                LOG.error("reset columns " + visibility + "," + order + "," + sorting + "," + widths, t);
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void resetColumnsInternal(boolean visibility, boolean order, boolean sorting, boolean widths) {
        int n;
        ClientUIPreferences env = ClientUIPreferences.getInstance();
        env.removeAllTableColumnPreferences(this, visibility, order, sorting, widths);
        if (visibility) {
            ArrayList<IColumn> list = new ArrayList<IColumn>();
            IColumn[] iColumnArray = this.getColumnSet().getAllColumnsInUserOrder();
            n = iColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean configuredVisible;
                IColumn col = iColumnArray[n2];
                if (col.isDisplayable() && (configuredVisible = ((AbstractColumn)col).isInitialVisible())) {
                    list.add(col);
                }
                ++n2;
            }
            this.getColumnSet().setVisibleColumns(list.toArray(new IColumn[list.size()]));
        }
        if (order) {
            TreeMap orderMap = new TreeMap();
            int index = 0;
            IColumn<?>[] iColumnArray = this.getColumns();
            int n3 = iColumnArray.length;
            n = 0;
            while (n < n3) {
                IColumn<?> col = iColumnArray[n];
                if (col.isDisplayable() && col.isVisible()) {
                    orderMap.put(new CompositeObject(new Object[]{col.getViewOrder(), index}), col);
                    ++index;
                }
                ++n;
            }
            this.getColumnSet().setVisibleColumns(orderMap.values().toArray(new IColumn[orderMap.size()]));
        }
        if (sorting) {
            TreeMap sortMap = new TreeMap();
            int index = 0;
            IColumn<?>[] iColumnArray = this.getColumns();
            int n4 = iColumnArray.length;
            n = 0;
            while (n < n4) {
                IColumn<?> col = iColumnArray[n];
                if (col.getInitialSortIndex() >= 0) {
                    sortMap.put(new CompositeObject(new Object[]{col.getInitialSortIndex(), index}), col);
                }
                ++index;
                ++n;
            }
            this.getColumnSet().clearSortColumns();
            this.getColumnSet().clearPermanentHeadSortColumns();
            this.getColumnSet().clearPermanentTailSortColumns();
            for (IColumn col : sortMap.values()) {
                if (col.isInitialAlwaysIncludeSortAtBegin()) {
                    this.getColumnSet().addPermanentHeadSortColumn(col, col.isInitialSortAscending());
                    continue;
                }
                if (col.isInitialAlwaysIncludeSortAtEnd()) {
                    this.getColumnSet().addPermanentTailSortColumn(col, col.isInitialSortAscending());
                    continue;
                }
                this.getColumnSet().addSortColumn(col, col.isInitialSortAscending());
            }
        }
        if (widths) {
            IColumn<?>[] iColumnArray = this.getColumns();
            int n5 = iColumnArray.length;
            int n6 = 0;
            while (n6 < n5) {
                IColumn<?> col = iColumnArray[n6];
                if (col.isDisplayable()) {
                    col.setWidth(col.getInitialWidth());
                }
                ++n6;
            }
        }
    }

    private void processDecorationBuffer() {
        block15: {
            try {
                try {
                    BatchLookupCall batchCall = null;
                    ArrayList<ITableRow> tableRowList = null;
                    Object columnIndexList = null;
                    if (this.m_cellLookupBuffer.size() > 0) {
                        batchCall = new BatchLookupCall();
                        tableRowList = new ArrayList<ITableRow>();
                        columnIndexList = new ArrayList();
                        BatchLookupResultCache lookupResultCache = new BatchLookupResultCache();
                        for (P_CellLookup lookup : this.m_cellLookupBuffer) {
                            ITableRow row = lookup.getRow();
                            if (row.getTable() != this) continue;
                            ISmartColumn<?> col = lookup.getColumn();
                            LookupCall call = col.prepareLookupCall(row);
                            if (call != null && call.getKey() != null) {
                                if (call instanceof LocalLookupCall) {
                                    LookupRow[] result = lookupResultCache.getDataByKey(call);
                                    this.applyLookupResult((InternalTableRow)row, col.getColumnIndex(), result);
                                    continue;
                                }
                                tableRowList.add(row);
                                ((ArrayList)columnIndexList).add(col.getColumnIndex());
                                batchCall.addLookupCall(call);
                                continue;
                            }
                            this.applyLookupResult((InternalTableRow)row, col.getColumnIndex(), LookupRow.EMPTY_ARRAY);
                        }
                    }
                    this.m_cellLookupBuffer.clear();
                    if (batchCall != null && tableRowList != null && columnIndexList != null && !batchCall.isEmpty()) {
                        ITableRow[] tableRows = tableRowList.toArray(new ITableRow[tableRowList.size()]);
                        IBatchLookupService service = (IBatchLookupService)SERVICES.getService(IBatchLookupService.class);
                        LookupRow[][] resultArray = service.getBatchDataByKey(batchCall);
                        int i = 0;
                        while (i < tableRows.length) {
                            this.applyLookupResult((InternalTableRow)tableRows[i], ((Number)((ArrayList)columnIndexList).get(i)).intValue(), resultArray[i]);
                            ++i;
                        }
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.m_cellLookupBuffer.clear();
                    break block15;
                }
            }
            catch (Throwable throwable) {
                this.m_cellLookupBuffer.clear();
                throw throwable;
            }
            this.m_cellLookupBuffer.clear();
        }
        HashSet<ITableRow> set = this.m_rowDecorationBuffer;
        this.m_rowDecorationBuffer = new HashSet();
        for (ITableRow row : set) {
            if (row.getTable() != this) continue;
            this.applyRowDecorationsImpl(row);
        }
        if (this.m_rowFilters.size() > 0) {
            boolean filterChanged = false;
            for (ITableRow row : set) {
                if (row.getTable() != this || !(row instanceof InternalTableRow)) continue;
                InternalTableRow irow = (InternalTableRow)row;
                boolean oldFlag = irow.isFilterAccepted();
                this.applyRowFiltersInternal(irow);
                boolean newFlag = irow.isFilterAccepted();
                boolean bl = filterChanged = filterChanged || oldFlag != newFlag;
            }
            if (filterChanged) {
                this.fireRowFilterChanged();
            }
        }
    }

    private void processEventBuffer() {
        block29: {
            try {
                ++this.m_processEventBufferLoopDetection;
                if (this.m_processEventBufferLoopDetection > 100) {
                    LOG.error("LOOP DETECTION in " + this.getClass() + ". see stack trace for more details.", (Throwable)new Exception("LOOP DETECTION"));
                    return;
                }
                ArrayList<TableEvent> list = this.m_tableEventBuffer;
                this.m_tableEventBuffer = new ArrayList();
                if (list.size() <= 0) break block29;
                HashMap<Integer, ArrayList<TableEvent>> coalesceMap = new HashMap<Integer, ArrayList<TableEvent>>();
                for (TableEvent e : list) {
                    ArrayList<TableEvent> subList = (ArrayList<TableEvent>)coalesceMap.get(e.getType());
                    if (subList == null) {
                        subList = new ArrayList<TableEvent>();
                        coalesceMap.put(e.getType(), subList);
                    }
                    subList.add(e);
                }
                TreeMap<Integer, TableEvent> sortedCoalescedMap = new TreeMap<Integer, TableEvent>();
                for (Map.Entry entry : coalesceMap.entrySet()) {
                    int type = (Integer)entry.getKey();
                    List subList = (List)entry.getValue();
                    int lastIndex = subList.size() - 1;
                    switch (type) {
                        case 105: {
                            ArrayList<TableEvent> singleList = new ArrayList<TableEvent>(1);
                            singleList.add((TableEvent)subList.get(lastIndex));
                            sortedCoalescedMap.put(10, this.coalesceTableEvents(singleList, false, true));
                            break;
                        }
                        case 102: {
                            sortedCoalescedMap.put(20, this.coalesceTableEvents(subList, false, true));
                            break;
                        }
                        case 100: {
                            sortedCoalescedMap.put(30, this.coalesceTableEvents(subList, true, false));
                            break;
                        }
                        case 101: {
                            sortedCoalescedMap.put(40, this.coalesceTableEvents(subList, true, false));
                            break;
                        }
                        case 780: {
                            sortedCoalescedMap.put(60, this.coalesceTableEvents(subList, false, false));
                            break;
                        }
                        case 770: {
                            sortedCoalescedMap.put(70, this.coalesceTableEvents(subList, false, false));
                            break;
                        }
                        case 1: {
                            sortedCoalescedMap.put(80, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 200: {
                            sortedCoalescedMap.put(90, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 730: {
                            sortedCoalescedMap.put(100, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 740: {
                            sortedCoalescedMap.put(110, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 750: {
                            sortedCoalescedMap.put(130, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 701: {
                            sortedCoalescedMap.put(140, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 700: {
                            sortedCoalescedMap.put(150, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 104: {
                            sortedCoalescedMap.put(160, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 103: {
                            sortedCoalescedMap.put(170, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 830: {
                            sortedCoalescedMap.put(180, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        default: {
                            sortedCoalescedMap.put(-type, (TableEvent)subList.get(lastIndex));
                        }
                    }
                }
                try {
                    this.setTableChanging(true);
                    this.fireTableEventBatchInternal(sortedCoalescedMap.values().toArray(new TableEvent[sortedCoalescedMap.size()]));
                }
                finally {
                    this.setTableChanging(false);
                }
            }
            finally {
                --this.m_processEventBufferLoopDetection;
            }
        }
    }

    private TableEvent coalesceTableEvents(List<TableEvent> list, boolean includeExistingRows, boolean includeRemovedRows) {
        if (list.size() == 1) {
            return list.get(0);
        }
        TableEvent last = list.get(list.size() - 1);
        TableEvent ce = new TableEvent(last.getTable(), last.getType());
        ce.setSortInMemoryAllowed(last.isSortInMemoryAllowed());
        ce.setDragObject(last.getDragObject());
        ce.setDropObject(last.getDropObject());
        ce.setCopyObject(last.getCopyObject());
        ce.addPopupMenus(last.getPopupMenus());
        LinkedHashSet<IColumn> colList = new LinkedHashSet<IColumn>();
        for (TableEvent t : list) {
            if (t.getColumns() == null) continue;
            colList.addAll(Arrays.asList(t.getColumns()));
        }
        ce.setColumns(colList.toArray(new IColumn[colList.size()]));
        LinkedHashSet<ITableRow> rowList = new LinkedHashSet<ITableRow>();
        for (TableEvent t : list) {
            if (t.getRowCount() <= 0) continue;
            ITableRow[] iTableRowArray = t.getRows();
            int n = iTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITableRow row = iTableRowArray[n2];
                if (row.getTable() == this && includeExistingRows) {
                    rowList.add(row);
                } else if (row.getTable() != this && includeRemovedRows) {
                    rowList.add(row);
                }
                ++n2;
            }
        }
        ce.setRows(rowList.toArray(new ITableRow[rowList.size()]));
        return ce;
    }

    private void enqueueDecorationTasks(ITableRow row) {
        if (row != null) {
            int i = 0;
            while (i < row.getCellCount()) {
                ISmartColumn smartColumn;
                IColumn column = this.getColumnSet().getColumn(i);
                if (column instanceof ISmartColumn && (smartColumn = (ISmartColumn)column).getLookupCall() != null) {
                    this.m_cellLookupBuffer.add(new P_CellLookup(row, smartColumn));
                }
                ++i;
            }
            this.m_rowDecorationBuffer.add(row);
        }
    }

    private void applyRowDecorationsImpl(ITableRow tableRow) {
        try {
            try {
                tableRow.setRowChanging(true);
                this.decorateRow(tableRow);
                ColumnSet cset = this.getColumnSet();
                int c = 0;
                while (c < tableRow.getCellCount()) {
                    IColumn col = cset.getColumn(c);
                    col.decorateCell(tableRow);
                    this.decorateCell(tableRow, col);
                    ++c;
                }
            }
            catch (Throwable t) {
                LOG.error("Error occured while applying row decoration", t);
                tableRow.setRowPropertiesChanged(false);
                tableRow.setRowChanging(false);
            }
        }
        finally {
            tableRow.setRowPropertiesChanged(false);
            tableRow.setRowChanging(false);
        }
    }

    private void applyLookupResult(InternalTableRow tableRow, int columnIndex, LookupRow[] result) {
        try {
            tableRow.setRowChanging(true);
            Cell cell = (Cell)tableRow.getCell(columnIndex);
            if (result.length == 1) {
                cell.setText(result[0].getText());
                cell.setTooltipText(result[0].getTooltipText());
            } else if (result.length > 1) {
                StringBuffer buf = new StringBuffer();
                StringBuffer bufTooltip = new StringBuffer();
                int i = 0;
                while (i < result.length) {
                    if (i > 0) {
                        if (this.isMultilineText()) {
                            buf.append("\n");
                            bufTooltip.append("\n");
                        } else {
                            buf.append(", ");
                            bufTooltip.append(", ");
                        }
                    }
                    buf.append(result[i].getText());
                    bufTooltip.append(result[i].getTooltipText());
                    ++i;
                }
                cell.setText(buf.toString());
                cell.setTooltipText(bufTooltip.toString());
            } else {
                cell.setText("");
                cell.setTooltipText("");
            }
        }
        finally {
            tableRow.setRowPropertiesChanged(false);
            tableRow.setRowChanging(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tablePopulated() {
        if (this.m_tableEventBuffer.isEmpty()) {
            Object object = this.m_cachedFilteredRowsLock;
            synchronized (object) {
                this.m_cachedFilteredRows = null;
            }
            this.fireTableEventInternal(new TableEvent(this, 820, null));
        }
    }

    @Override
    public ITableRow resolveRow(ITableRow row) {
        if (row == null) {
            return null;
        }
        if (!(row instanceof InternalTableRow)) {
            throw new IllegalArgumentException("only accept InternalTableRow, not " + (row != null ? row.getClass() : null));
        }
        if (row.getTable() == this) {
            return row;
        }
        return null;
    }

    @Override
    public ITableRow[] resolveRows(ITableRow[] rows) {
        if (rows == null) {
            rows = new ITableRow[]{};
        }
        int mismatchCount = 0;
        int i = 0;
        while (i < rows.length) {
            if (this.resolveRow(rows[i]) != rows[i]) {
                LOG.warn("could not resolve row " + rows[i]);
                ++mismatchCount;
            }
            ++i;
        }
        if (mismatchCount > 0) {
            ITableRow[] resolvedRows = new ITableRow[rows.length - mismatchCount];
            int index = 0;
            int i2 = 0;
            while (i2 < rows.length) {
                if (this.resolveRow(rows[i2]) == rows[i2]) {
                    resolvedRows[index] = rows[i2];
                    ++index;
                }
                ++i2;
            }
            rows = resolvedRows;
        }
        return rows;
    }

    @Override
    public boolean isHeaderVisible() {
        return this.propertySupport.getPropertyBool("headerVisible");
    }

    @Override
    public void setHeaderVisible(boolean b) {
        this.propertySupport.setPropertyBool("headerVisible", b);
    }

    @Override
    public final void decorateCell(ITableRow row, IColumn<?> col) {
        Cell cell = row.getCellForUpdate(col.getColumnIndex());
        this.decorateCellInternal(cell, row, col);
        try {
            this.execDecorateCell(cell, row, col);
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(this.createNewUnexpectedProcessingExcpetion(t));
        }
    }

    public boolean wasEverValid(ITableRow row) {
        if (!this.m_rowValidty.contains(row)) {
            IColumn<?>[] iColumnArray = this.getColumns();
            int n = iColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                IColumn<?> col = iColumnArray[n2];
                if (row.getCell(col).getErrorStatus() != null) {
                    return false;
                }
                ++n2;
            }
            this.m_rowValidty.add(row);
        }
        return true;
    }

    private void clearRowValidity(ITableRow row) {
        this.m_rowValidty.remove(row);
    }

    private void clearAllRowsValidity() {
        this.m_rowValidty.clear();
    }

    protected void decorateCellInternal(Cell view, ITableRow row, IColumn<?> col) {
    }

    @Override
    public final void decorateRow(ITableRow row) {
        this.decorateRowInternal(row);
        try {
            this.execDecorateRow(row);
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(this.createNewUnexpectedProcessingExcpetion(t));
        }
    }

    protected void decorateRowInternal(ITableRow row) {
        String s;
        if (row.getIconId() == null && (s = this.getDefaultIconId()) != null) {
            row.setIconId(s);
        }
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execResetColumns(boolean visibility, boolean order, boolean sorting, boolean widths) throws ProcessingException {
    }

    @Override
    public void addTableListener(TableListener listener) {
        this.m_listenerList.add(TableListener.class, (EventListener)listener);
    }

    @Override
    public void removeTableListener(TableListener listener) {
        this.m_listenerList.remove(TableListener.class, (EventListener)listener);
    }

    @Override
    public void addUITableListener(TableListener listener) {
        this.m_listenerList.insertAtFront(TableListener.class, (EventListener)listener);
    }

    protected IEventHistory<TableEvent> createEventHistory() {
        return new DefaultTableEventHistory(5000L);
    }

    @Override
    public IEventHistory<TableEvent> getEventHistory() {
        return this.m_eventHistory;
    }

    @Override
    public IMenu[] fetchMenusForRowsInternal(ITableRow[] rows) {
        TableEvent e = rows.length == 0 ? new TableEvent(this, 701) : new TableEvent(this, 700, rows);
        this.fireTableEventInternal(e);
        return e.getPopupMenus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowsInserted(ITableRow[] rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 100, rows));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowsUpdated(ITableRow[] rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 101, rows));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowsDeleted(ITableRow[] rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 102, rows));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAllRowsDeleted(ITableRow[] rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 105, rows));
    }

    private void fireRowsSelected(ITableRow[] rows) {
        this.fireTableEventInternal(new TableEvent(this, 103, rows));
    }

    private void fireRowClick(ITableRow row) {
        if (row != null) {
            try {
                this.interceptRowClickSingleObserver(row);
                this.execRowClick(row);
            }
            catch (ProcessingException ex) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(this.createNewUnexpectedProcessingExcpetion(t));
            }
        }
    }

    protected void interceptRowClickSingleObserver(ITableRow row) throws ProcessingException {
        if (row.isEnabled() && this.isEnabled()) {
            IColumn<?> ctxCol = this.getContextColumn();
            if (this.isCellEditable(row, ctxCol)) {
                IFormField field;
                if (ctxCol instanceof IBooleanColumn && (field = ctxCol.prepareEdit(row)) instanceof IBooleanField) {
                    IBooleanField bfield;
                    bfield.setChecked(!(bfield = (IBooleanField)field).isChecked());
                    ctxCol.completeEdit(row, field);
                }
            } else if (this.isCheckable()) {
                row.setChecked(!row.isChecked());
            }
        }
    }

    private void fireRowAction(ITableRow row) {
        if (!this.m_actionRunning) {
            try {
                this.m_actionRunning = true;
                if (row != null) {
                    try {
                        this.execRowAction(row);
                    }
                    catch (ProcessingException ex) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                    }
                    catch (Throwable t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(this.createNewUnexpectedProcessingExcpetion(t));
                    }
                }
            }
            finally {
                this.m_actionRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowOrderChanged() {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 200, this.getRows()));
    }

    private void fireRequestFocus() {
        this.fireTableEventInternal(new TableEvent(this, 800));
    }

    private void fireRequestFocusInCell(IColumn<?> column, ITableRow row) {
        TableEvent e = new TableEvent(this, 805);
        e.setColumns(new IColumn[]{column});
        e.setRows(new ITableRow[]{row});
        this.fireTableEventInternal(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowFilterChanged() {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 210));
    }

    private TransferObject fireRowsDragRequest() {
        ITableRow[] rows = this.getSelectedRows();
        if (rows != null && rows.length > 0) {
            TableEvent e = new TableEvent(this, 730, rows);
            this.fireTableEventInternal(e);
            return e.getDragObject();
        }
        return null;
    }

    private void fireRowDropAction(ITableRow row, TransferObject dropData) {
        ITableRow[] rows = null;
        if (row != null) {
            rows = new ITableRow[]{row};
        }
        TableEvent e = new TableEvent(this, 740, rows);
        e.setDropObject(dropData);
        this.fireTableEventInternal(e);
    }

    private TransferObject fireRowsCopyRequest() {
        ITableRow[] rows = this.getSelectedRows();
        if (rows != null && rows.length > 0) {
            TableEvent e = new TableEvent(this, 760, rows);
            this.fireTableEventInternal(e);
            return e.getCopyObject();
        }
        return null;
    }

    private IMenu[] fireEmptySpacePopup() {
        TableEvent e = new TableEvent(this, 701);
        this.fireTableEventInternal(e);
        return e.getPopupMenus();
    }

    private IMenu[] fireRowPopup() {
        TableEvent e = new TableEvent(this, 700, this.getSelectedRows());
        this.fireTableEventInternal(e);
        return e.getPopupMenus();
    }

    private void addLocalPopupMenus(TableEvent e) {
        IMenu[] a;
        boolean singleSelect = this.getSelectedRowCount() == 1;
        boolean multiSelect = this.getSelectedRowCount() >= 2;
        boolean allRowsEnabled = true;
        ITableRow[] iTableRowArray = this.getSelectedRows();
        int n = iTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITableRow row = iTableRowArray[n2];
            if (!row.isEnabled()) {
                allRowsEnabled = false;
                break;
            }
            ++n2;
        }
        IMenu[] iMenuArray = a = this.getMenus();
        int n3 = a.length;
        n = 0;
        while (n < n3) {
            IMenu menu = iMenuArray[n];
            IAction validMenu = null;
            switch (e.getType()) {
                case 701: 
                case 750: {
                    if (!menu.isEmptySpaceAction() || menu.isInheritAccessibility() && !this.isEnabled()) break;
                    validMenu = menu;
                    break;
                }
                case 700: {
                    if (multiSelect) {
                        if (!menu.isMultiSelectionAction() || menu.isInheritAccessibility() && (!this.isEnabled() || !allRowsEnabled)) break;
                        validMenu = menu;
                        break;
                    }
                    if (!singleSelect || !menu.isSingleSelectionAction() || menu.isInheritAccessibility() && (!this.isEnabled() || !allRowsEnabled)) break;
                    validMenu = menu;
                }
            }
            if (validMenu != null) {
                validMenu.prepareAction();
                if (validMenu.isVisible()) {
                    e.addPopupMenu((IMenu)validMenu);
                }
            }
            ++n;
        }
    }

    @ConfigOperation
    @Order(value=100.0)
    protected void execAddHeaderMenus(TableEvent e) throws ProcessingException {
        IMenu m;
        int n;
        int n2;
        IMenu[] iMenuArray;
        if (this.getTableCustomizer() != null) {
            if (e.getPopupMenuCount() > 0) {
                e.addPopupMenu(new MenuSeparator());
            }
            iMenuArray = new IMenu[]{new AddCustomColumnMenu(this), new ModifyCustomColumnMenu(this), new RemoveCustomColumnMenu(this)};
            n2 = iMenuArray.length;
            n = 0;
            while (n < n2) {
                m = iMenuArray[n];
                m.prepareAction();
                if (m.isVisible()) {
                    e.addPopupMenu(m);
                }
                ++n;
            }
        }
        if (e.getPopupMenuCount() > 0) {
            e.addPopupMenu(new MenuSeparator());
        }
        iMenuArray = new IMenu[]{new ResetColumnsMenu(this), new OrganizeColumnsMenu(this), new ColumnFilterMenu(this), new CopyWidthsOfColumnsMenu(this)};
        n2 = iMenuArray.length;
        n = 0;
        while (n < n2) {
            m = iMenuArray[n];
            m.prepareAction();
            if (m.isVisible()) {
                e.addPopupMenu(m);
            }
            ++n;
        }
    }

    private IMenu[] fireHeaderPopup() {
        TableEvent e = new TableEvent(this, 750);
        this.fireTableEventInternal(e);
        try {
            this.execAddHeaderMenus(e);
        }
        catch (ProcessingException ex) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
        }
        return e.getPopupMenus();
    }

    protected void fireTableEventInternal(TableEvent e) {
        if (this.isTableChanging()) {
            this.m_tableEventBuffer.add(e);
        } else {
            EventListener[] listeners = this.m_listenerList.getListeners(TableListener.class);
            if (listeners != null && listeners.length > 0) {
                int i = 0;
                while (i < listeners.length) {
                    try {
                        ((TableListener)listeners[i]).tableChanged(e);
                    }
                    catch (Throwable t) {
                        LOG.error("fire " + e, t);
                    }
                    ++i;
                }
            }
        }
    }

    private void fireTableEventBatchInternal(TableEvent[] batch) {
        EventListener[] listeners;
        if (batch.length == 0) {
            return;
        }
        if (batch.length > 0 && (listeners = this.m_listenerList.getListeners(TableListener.class)) != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ((TableListener)listeners[i]).tableChangedBatch(batch);
                ++i;
            }
        }
    }

    protected boolean handleKeyStroke(String keyName, char keyChar) {
        if (keyName == null) {
            return false;
        }
        keyName = keyName.toLowerCase();
        IAction[] iActionArray = this.getMenus();
        int n = iActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu m = iActionArray[n2];
            if (m.getKeyStroke() != null && m.getKeyStroke().equalsIgnoreCase(keyName)) {
                return false;
            }
            ++n2;
        }
        iActionArray = this.getKeyStrokes();
        n = iActionArray.length;
        n2 = 0;
        while (n2 < n) {
            IAction k = iActionArray[n2];
            if (k.getKeyStroke() != null && k.getKeyStroke().equalsIgnoreCase(keyName)) {
                return false;
            }
            ++n2;
        }
        if (!(keyChar <= ' ' || keyName.contains("control") || keyName.contains("ctrl") || keyName.contains("alt"))) {
            String newText = "" + Character.toLowerCase(keyChar);
            this.m_keyStrokeBuffer.append(newText);
            String prefix = this.m_keyStrokeBuffer.getText();
            IColumn col = this.getContextColumn();
            if (col == null) {
                IColumn[] sortCols = this.getColumnSet().getSortColumns();
                if (sortCols.length > 0) {
                    col = sortCols[sortCols.length - 1];
                } else {
                    TreeMap<CompositeObject, IColumn> sortMap = new TreeMap<CompositeObject, IColumn>();
                    int index = 0;
                    IColumn[] iColumnArray = this.getColumnSet().getVisibleColumns();
                    int n3 = iColumnArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IColumn c = iColumnArray[n4];
                        if (c.getDataType() == String.class) {
                            sortMap.put(new CompositeObject(new Object[]{1, index}), c);
                        } else if (c.getDataType() == Boolean.class) {
                            sortMap.put(new CompositeObject(new Object[]{3, index}), c);
                        } else {
                            sortMap.put(new CompositeObject(new Object[]{2, index}), c);
                        }
                        ++index;
                        ++n4;
                    }
                    if (sortMap.size() > 0) {
                        col = (IColumn)sortMap.get(sortMap.firstKey());
                    }
                }
            }
            if (col != null) {
                int colIndex = col.getColumnIndex();
                String pattern = StringUtility.toRegExPattern((String)prefix.toLowerCase());
                pattern = String.valueOf(pattern) + ".*";
                if (LOG.isInfoEnabled()) {
                    LOG.info("finding regex:" + pattern + " in column " + this.getColumnSet().getColumn(colIndex).getHeaderCell().getText());
                }
                int rowCount = this.getRowCount();
                ITableRow selRow = this.getSelectedRow();
                int startIndex = 0;
                if (selRow != null) {
                    startIndex = prefix.length() <= 1 ? selRow.getRowIndex() + 1 : selRow.getRowIndex();
                }
                int i = 0;
                while (i < rowCount) {
                    ITableRow row = this.m_rows.get((startIndex + i) % rowCount);
                    String text = row.getCell(colIndex).getText();
                    if (text != null && text.toLowerCase().matches(pattern)) {
                        this.selectRow(row, false);
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    @Override
    public ITableUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private ProcessingException createNewUnexpectedProcessingExcpetion(Throwable t) {
        return new ProcessingException("Unexpected", t);
    }

    private static class P_CellEditorContext {
        private final ITableRow m_row;
        private final IColumn<?> m_column;
        private final IFormField m_formField;

        public P_CellEditorContext(ITableRow row, IColumn<?> col, IFormField f) {
            this.m_row = row;
            this.m_column = col;
            this.m_formField = f;
        }

        public ITableRow getRow() {
            return this.m_row;
        }

        public IColumn<?> getColumn() {
            return this.m_column;
        }

        public IFormField getFormField() {
            return this.m_formField;
        }
    }

    private class P_CellLookup {
        private final ITableRow m_row;
        private final ISmartColumn<?> m_column;

        public P_CellLookup(ITableRow row, ISmartColumn<?> col) {
            this.m_row = row;
            this.m_column = col;
        }

        public ITableRow getRow() {
            return this.m_row;
        }

        public ISmartColumn<?> getColumn() {
            return this.m_column;
        }
    }

    private class P_TableListener
    extends TableAdapter {
        private P_TableListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            switch (e.getType()) {
                case 701: {
                    AbstractTable.this.addLocalPopupMenus(e);
                    break;
                }
                case 750: {
                    AbstractTable.this.addLocalPopupMenus(e);
                    break;
                }
                case 700: {
                    AbstractTable.this.addLocalPopupMenus(e);
                    break;
                }
                case 103: {
                    try {
                        AbstractTable.this.execRowsSelected(e.getRows());
                        break;
                    }
                    catch (ProcessingException ex) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        break;
                    }
                    catch (Throwable t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                    }
                }
            }
        }
    }

    private class P_TableRowBuilder
    extends AbstractTableRowBuilder {
        private P_TableRowBuilder() {
        }

        @Override
        protected ITableRow createEmptyTableRow() {
            return new TableRow(AbstractTable.this.getColumnSet());
        }
    }

    protected class P_TableUIFacade
    implements ITableUIFacade {
        private int m_uiProcessorCount = 0;

        protected P_TableUIFacade() {
        }

        protected void pushUIProcessor() {
            ++this.m_uiProcessorCount;
        }

        protected void popUIProcessor() {
            --this.m_uiProcessorCount;
        }

        @Override
        public boolean isUIProcessing() {
            return this.m_uiProcessorCount > 0;
        }

        @Override
        public void fireRowClickFromUI(ITableRow row) {
            try {
                this.pushUIProcessor();
                row = AbstractTable.this.resolveRow(row);
                if (row != null) {
                    AbstractTable.this.fireRowClick(AbstractTable.this.resolveRow(row));
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireRowActionFromUI(ITableRow row) {
            try {
                this.pushUIProcessor();
                row = AbstractTable.this.resolveRow(row);
                if (row != null) {
                    AbstractTable.this.fireRowAction(row);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public IMenu[] fireRowPopupFromUI() {
            try {
                this.pushUIProcessor();
                IMenu[] iMenuArray = AbstractTable.this.fireRowPopup();
                return iMenuArray;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public IMenu[] fireEmptySpacePopupFromUI() {
            try {
                this.pushUIProcessor();
                IMenu[] iMenuArray = AbstractTable.this.fireEmptySpacePopup();
                return iMenuArray;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public IMenu[] fireHeaderPopupFromUI() {
            try {
                this.pushUIProcessor();
                IMenu[] iMenuArray = AbstractTable.this.fireHeaderPopup();
                return iMenuArray;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public boolean fireKeyTypedFromUI(String keyStrokeText, char keyChar) {
            try {
                this.pushUIProcessor();
                boolean bl = AbstractTable.this.handleKeyStroke(keyStrokeText, keyChar);
                return bl;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireVisibleColumnsChangedFromUI(IColumn<?>[] visibleColumns) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.getColumnSet().setVisibleColumns(visibleColumns);
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireColumnMovedFromUI(IColumn<?> c, int toViewIndex) {
            try {
                this.pushUIProcessor();
                c = AbstractTable.this.getColumnSet().resolveColumn(c);
                if (c != null) {
                    AbstractTable.this.getColumnSet().moveColumnToVisibleIndex(c.getColumnIndex(), toViewIndex);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setColumnWidthFromUI(IColumn<?> c, int newWidth) {
            try {
                this.pushUIProcessor();
                c = AbstractTable.this.getColumnSet().resolveColumn(c);
                if (c != null) {
                    c.setWidthInternal(newWidth);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireHeaderSortFromUI(IColumn<?> c, boolean multiSort) {
            try {
                this.pushUIProcessor();
                if (AbstractTable.this.isSortEnabled() && (c = AbstractTable.this.getColumnSet().resolveColumn(c)) != null) {
                    AbstractTable.this.getColumnSet().handleSortEvent(c, multiSort);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                    AbstractTable.this.sort();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setSelectedRowsFromUI(ITableRow[] rows) {
            try {
                this.pushUIProcessor();
                HashSet<ITableRow> requestedRows = new HashSet<ITableRow>(Arrays.asList(AbstractTable.this.resolveRows(rows)));
                ArrayList<ITableRow> validRows = new ArrayList<ITableRow>();
                ITableRow[] iTableRowArray = AbstractTable.this.getSelectedRows();
                int n = iTableRowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITableRow row = iTableRowArray[n2];
                    if (!row.isFilterAccepted()) {
                        validRows.add(row);
                    }
                    ++n2;
                }
                requestedRows.removeAll(validRows);
                for (ITableRow row : requestedRows) {
                    validRows.add(row);
                }
                AbstractTable.this.selectRows(validRows.toArray(new ITableRow[validRows.size()]), false);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public TransferObject fireRowsDragRequestFromUI() {
            try {
                this.pushUIProcessor();
                TransferObject transferObject = AbstractTable.this.fireRowsDragRequest();
                return transferObject;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireRowDropActionFromUI(ITableRow row, TransferObject dropData) {
            try {
                this.pushUIProcessor();
                row = AbstractTable.this.resolveRow(row);
                AbstractTable.this.fireRowDropAction(row, dropData);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public TransferObject fireRowsCopyRequestFromUI() {
            try {
                this.pushUIProcessor();
                TransferObject transferObject = AbstractTable.this.fireRowsCopyRequest();
                return transferObject;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireHyperlinkActionFromUI(ITableRow row, IColumn<?> col, URL url) {
            try {
                try {
                    this.pushUIProcessor();
                    AbstractTable.this.doHyperlinkAction(AbstractTable.this.resolveRow(row), col, url);
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setContextColumnFromUI(IColumn<?> col) {
            try {
                this.pushUIProcessor();
                if (col != null && col.getTable() != AbstractTable.this) {
                    col = null;
                }
                AbstractTable.this.setContextColumn(col);
            }
            finally {
                this.popUIProcessor();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public IFormField prepareCellEditFromUI(ITableRow row, IColumn<?> col) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void completeCellEditFromUI() {
            block10: {
                try {
                    this.pushUIProcessor();
                    if (AbstractTable.this.m_editContext == null) break block10;
                    try {
                        try {
                            AbstractTable.this.m_editContext.getColumn().completeEdit(AbstractTable.this.m_editContext.getRow(), AbstractTable.this.m_editContext.getFormField());
                        }
                        catch (ProcessingException e) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                            AbstractTable.this.m_editContext = null;
                        }
                        catch (Throwable t) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                            AbstractTable.this.m_editContext = null;
                        }
                    }
                    finally {
                        AbstractTable.this.m_editContext = null;
                    }
                }
                finally {
                    this.popUIProcessor();
                }
            }
        }

        @Override
        public void cancelCellEditFromUI() {
            try {
                this.pushUIProcessor();
                AbstractTable.this.m_editContext = null;
            }
            finally {
                this.popUIProcessor();
            }
        }
    }
}

