/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columnfilter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class BooleanColumnFilter<T extends Comparable<Boolean>>
implements ITableColumnFilter<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    private IColumn<Boolean> m_column;
    private Set<Boolean> m_selectedValues;

    public BooleanColumnFilter(IColumn<Boolean> column) {
        this.m_column = column;
    }

    @Override
    public IColumn<Boolean> getColumn() {
        return this.m_column;
    }

    @Override
    public void setColumn(IColumn column) {
        this.m_column = column;
    }

    @Override
    public Set<Boolean> getSelectedValues() {
        return this.m_selectedValues;
    }

    @Override
    public void setSelectedValues(Set<Boolean> set) {
        this.m_selectedValues = set;
    }

    @Override
    public List<LookupRow> createHistogram() {
        TreeMap<Boolean, LookupRow> hist = new TreeMap<Boolean, LookupRow>();
        HashMap<Boolean, Integer> countMap = new HashMap<Boolean, Integer>();
        hist.put(true, new LookupRow((Object)true, "(" + ScoutTexts.get((String)"ColumnFilterCheckedText", (String[])new String[0]) + ")"));
        hist.put(false, new LookupRow((Object)false, "(" + ScoutTexts.get((String)"ColumnFilterUncheckedText", (String[])new String[0]) + ")"));
        ITableRow[] iTableRowArray = this.m_column.getTable().getRows();
        int n = iTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean key;
            ITableRow row = iTableRowArray[n2];
            Integer count = (Integer)countMap.get(key = Boolean.valueOf(BooleanUtility.nvl((Boolean)this.m_column.getValue(row), (boolean)false)));
            countMap.put(key, count != null ? count + 1 : 1);
            ++n2;
        }
        for (Map.Entry e : hist.entrySet()) {
            Integer count = (Integer)countMap.get(e.getKey());
            if (count == null || count <= 1) continue;
            LookupRow row = (LookupRow)e.getValue();
            row.setText(String.valueOf(row.getText()) + " (" + count + ")");
        }
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        list.addAll(hist.values());
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.m_selectedValues == null || this.m_selectedValues.isEmpty();
    }

    @Override
    public boolean accept(ITableRow row) {
        Boolean value = BooleanUtility.nvl((Boolean)this.m_column.getValue(row), (boolean)false);
        return this.m_selectedValues == null || this.m_selectedValues.contains(value);
    }
}

