/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDecimalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDoubleColumn;
import org.eclipse.scout.rt.client.ui.form.fields.doublefield.AbstractDoubleField;

public abstract class AbstractDoubleColumn
extends AbstractDecimalColumn<Double>
implements IDoubleColumn {
    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=200.0)
    @ConfigPropertyValue(value="null")
    protected Double getConfiguredMaxValue() {
        return null;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=210.0)
    @ConfigPropertyValue(value="null")
    protected Double getConfiguredMinValue() {
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMaxValue(this.getConfiguredMaxValue());
        this.setMinValue(this.getConfiguredMinValue());
    }

    @Override
    protected Double parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        Double validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof Double) {
            validValue = (Double)rawValue;
        } else if (rawValue instanceof Number) {
            validValue = ((Number)rawValue).doubleValue();
        } else {
            throw new ProcessingException("invalid Double value in column '" + this.getClass().getSimpleName() + "': " + rawValue + " class=" + rawValue.getClass());
        }
        return validValue;
    }

    protected AbstractDoubleField getEditorField() {
        return new AbstractDoubleField(){

            @Override
            protected void initConfig() {
                super.initConfig();
                this.propertySupport.putPropertiesMap(AbstractDoubleColumn.this.propertySupport.getPropertiesMap());
            }
        };
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        if (cell.getValue() != null) {
            cell.setText(this.getNumberFormat().format((Double)cell.getValue()));
        } else {
            cell.setText("");
        }
    }

    @Override
    public NumberFormat getNumberFormat() {
        if (super.getNumberFormat() == null) {
            NumberFormat fmt = this.isPercent() ? NumberFormat.getPercentInstance(LocaleThreadLocal.get()) : NumberFormat.getNumberInstance(LocaleThreadLocal.get());
            if (fmt instanceof DecimalFormat) {
                ((DecimalFormat)fmt).setMultiplier(this.getMultiplier());
                if (this.getFormat() != null) {
                    ((DecimalFormat)fmt).applyPattern(this.getFormat());
                } else {
                    fmt.setMinimumFractionDigits(this.getMinFractionDigits());
                    fmt.setMaximumFractionDigits(this.getMaxFractionDigits());
                    fmt.setGroupingUsed(this.isGroupingUsed());
                }
            } else {
                fmt.setMinimumFractionDigits(this.getMinFractionDigits());
                fmt.setMaximumFractionDigits(this.getMaxFractionDigits());
                fmt.setGroupingUsed(this.isGroupingUsed());
            }
            this.setNumberFormat(fmt);
        }
        return super.getNumberFormat();
    }
}

