/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractNumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.AbstractIntegerField;

public abstract class AbstractIntegerColumn
extends AbstractNumberColumn<Integer>
implements IIntegerColumn {
    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=160.0)
    @ConfigPropertyValue(value="null")
    protected Integer getConfiguredMaxValue() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=170.0)
    @ConfigPropertyValue(value="null")
    protected Integer getConfiguredMinValue() {
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMaxValue(this.getConfiguredMaxValue());
        this.setMinValue(this.getConfiguredMinValue());
    }

    @Override
    protected Integer parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        Integer validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof Integer) {
            validValue = (Integer)rawValue;
        } else if (rawValue instanceof Number) {
            validValue = ((Number)rawValue).intValue();
        } else {
            throw new ProcessingException("invalid Integer value in column '" + this.getClass().getSimpleName() + "': " + rawValue + " class=" + rawValue.getClass());
        }
        return validValue;
    }

    protected AbstractIntegerField getEditorField() {
        return new AbstractIntegerField(){

            @Override
            protected void initConfig() {
                super.initConfig();
                this.propertySupport.putPropertiesMap(AbstractIntegerColumn.this.propertySupport.getPropertiesMap());
            }
        };
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        if (cell.getValue() != null) {
            cell.setText(this.getNumberFormat().format(((Integer)cell.getValue()).intValue()));
        } else {
            cell.setText("");
        }
    }

    @Override
    public NumberFormat getNumberFormat() {
        if (super.getNumberFormat() == null) {
            if (this.getFormat() != null) {
                DecimalFormat x = (DecimalFormat)DecimalFormat.getNumberInstance(LocaleThreadLocal.get());
                x.applyPattern(this.getFormat());
                x.setMinimumFractionDigits(0);
                x.setMaximumFractionDigits(0);
                this.setNumberFormat(x);
            } else {
                NumberFormat y = NumberFormat.getNumberInstance(LocaleThreadLocal.get());
                y.setMinimumFractionDigits(0);
                y.setMaximumFractionDigits(0);
                y.setGroupingUsed(this.isGroupingUsed());
                this.setNumberFormat(y);
            }
        }
        return super.getNumberFormat();
    }
}

