/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.text.NumberFormat;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.INumberColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;

public abstract class AbstractNumberColumn<T extends Number>
extends AbstractColumn<T>
implements INumberColumn<T> {
    private String m_format;
    private boolean m_groupingUsed;
    private NumberFormat m_fmt;
    private T m_minValue;
    private T m_maxValue;

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @ConfigProperty(value="STRING")
    @Order(value=140.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=150.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredGroupingUsed() {
        return true;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setFormat(this.getConfiguredFormat());
        this.setGroupingUsed(this.getConfiguredGroupingUsed());
    }

    @Override
    public void setFormat(String s) {
        this.m_format = s;
        this.setNumberFormat(null);
    }

    protected final void setNumberFormat(NumberFormat fmt) {
        this.m_fmt = fmt;
        this.validateColumnValues();
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.m_fmt;
    }

    @Override
    public String getFormat() {
        return this.m_format;
    }

    @Override
    public void setGroupingUsed(boolean b) {
        this.m_groupingUsed = b;
        this.setNumberFormat(null);
    }

    @Override
    public boolean isGroupingUsed() {
        return this.m_groupingUsed;
    }

    @Override
    public void setMaxValue(T value) {
        this.m_maxValue = value;
        this.validateColumnValues();
    }

    @Override
    public T getMaxValue() {
        return this.m_maxValue;
    }

    @Override
    public void setMinValue(T value) {
        this.m_minValue = value;
        this.validateColumnValues();
    }

    @Override
    public T getMinValue() {
        return this.m_minValue;
    }

    protected abstract AbstractNumberField<T> getEditorField();

    @Override
    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        AbstractNumberField<T> f = this.getEditorField();
        f.setFormat(this.getFormat());
        f.setGroupingUsed(this.isGroupingUsed());
        f.setMinValue(this.getMinValue());
        f.setMaxValue(this.getMaxValue());
        return f;
    }
}

