/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;

public abstract class AbstractStringColumn
extends AbstractColumn<String>
implements IStringColumn {
    @ConfigProperty(value="INTEGER")
    @Order(value=130.0)
    @ConfigPropertyValue(value="4000")
    protected int getConfiguredMaxLength() {
        return 4000;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=140.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredInputMasked() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=150.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDisplayFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredTextWrap() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=170.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=180.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredSelectAllOnEdit() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=180.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredValidateOnAnyKey() {
        return false;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setInputMasked(this.getConfiguredInputMasked());
        this.setDisplayFormat(this.getConfiguredDisplayFormat());
        this.setMaxLength(this.getConfiguredMaxLength());
        this.setTextWrap(this.getConfiguredTextWrap());
        this.setSelectAllOnEdit(this.getConfiguredSelectAllOnEdit());
        this.setValidateOnAnyKey(this.getConfiguredValidateOnAnyKey());
    }

    @Override
    public void setInputMasked(boolean b) {
        this.propertySupport.setPropertyBool("inputMasked", b);
    }

    @Override
    public boolean isInputMasked() {
        return this.propertySupport.getPropertyBool("inputMasked");
    }

    @Override
    public void setDisplayFormat(String s) {
        this.propertySupport.setPropertyString("format", s);
    }

    @Override
    public String getDisplayFormat() {
        return this.propertySupport.getPropertyString("format");
    }

    @Override
    public void setTextWrap(boolean b) {
        this.propertySupport.setPropertyBool("wrapText", b);
        this.validateColumnValues();
    }

    @Override
    public boolean isTextWrap() {
        return this.propertySupport.getPropertyBool("wrapText");
    }

    @Override
    public boolean isSelectAllOnEdit() {
        return this.propertySupport.getPropertyBool("selectAllOnFocus");
    }

    @Override
    public void setSelectAllOnEdit(boolean b) {
        this.propertySupport.setPropertyBool("selectAllOnFocus", b);
    }

    @Override
    public void setValidateOnAnyKey(boolean b) {
        this.propertySupport.setPropertyBool("validateOnAnyKey", b);
    }

    @Override
    public boolean isValidateOnAnyKey() {
        return this.propertySupport.getPropertyBool("validateOnAnyKey");
    }

    @Override
    public void setMaxLength(int len) {
        if (len > 0) {
            this.propertySupport.setPropertyInt("maxLength", len);
        }
        this.validateColumnValues();
    }

    @Override
    public int getMaxLength() {
        int len = this.propertySupport.getPropertyInt("maxLength");
        if (len <= 0) {
            len = 200;
        }
        return len;
    }

    @Override
    public boolean isEmpty() {
        ITable table = this.getTable();
        if (table != null) {
            int i = 0;
            int ni = table.getRowCount();
            while (i < ni) {
                String value = (String)this.getValue(table.getRow(i));
                if (value != null && value.length() > 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    protected String parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        String validValue = null;
        validValue = rawValue == null ? null : (rawValue instanceof String ? (String)rawValue : rawValue.toString());
        return validValue;
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        AbstractStringField f = new AbstractStringField(){

            @Override
            protected void initConfig() {
                super.initConfig();
                this.propertySupport.putPropertiesMap(AbstractStringColumn.this.propertySupport.getPropertiesMap());
            }
        };
        boolean multi = this.getTable() != null ? this.getTable().isMultilineText() : this.isTextWrap();
        f.setMultilineText(multi);
        f.setWrapText(true);
        return f;
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        String format = this.getDisplayFormat();
        super.decorateCellInternal(cell, row);
        if (format != null && cell.getValue() != null) {
            if ("a".equals(format)) {
                cell.setText(((String)cell.getValue()).toLowerCase());
            } else if ("A".equals(format)) {
                cell.setText(((String)cell.getValue()).toUpperCase());
            }
        } else {
            cell.setText((String)cell.getValue());
        }
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        String s1 = (String)this.getValue(r1);
        String s2 = (String)this.getValue(r2);
        return StringUtility.compareIgnoreCase((String)s1, (String)s2);
    }
}

