/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionFinder;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellObserver;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.IVirtualTreeNode;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractTreeNode
implements ITreeNode,
ICellObserver {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTreeNode.class);
    private boolean m_initialized;
    private ITree m_tree;
    private ITreeNode m_parentNode;
    private final Object m_childNodeListLock;
    private List<ITreeNode> m_childNodeList;
    private final Object m_filteredChildNodesLock;
    private ITreeNode[] m_filteredChildNodes;
    private int m_status;
    private final Cell m_cell;
    private IMenu[] m_menus;
    private int m_childNodeIndex;
    private boolean m_childrenLoaded;
    private final OptimisticLock m_childrenLoadedLock = new OptimisticLock();
    private boolean m_leaf;
    private boolean m_checked;
    private boolean m_defaultExpanded;
    private boolean m_expanded;
    private boolean m_childrenVolatile;
    private boolean m_childrenDirty;
    private boolean m_filterAccepted;
    private Object m_primaryKey;
    private boolean m_enabledGranted;
    private boolean m_enabledProperty;
    private boolean m_visible;
    private boolean m_visibleGranted;
    private boolean m_visibleProperty;
    private Integer m_hashCode = null;

    public AbstractTreeNode() {
        this(true);
    }

    public AbstractTreeNode(boolean callInitializer) {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerTreeNode(this);
        }
        this.m_filterAccepted = true;
        this.m_visibleGranted = true;
        this.m_visibleProperty = true;
        this.calculateVisible();
        this.m_enabledGranted = true;
        this.m_childNodeListLock = new Object();
        this.m_childNodeList = new ArrayList<ITreeNode>(0);
        this.m_filteredChildNodesLock = new Object();
        this.m_cell = new Cell(this);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.initConfig();
            this.initTreeNode();
            this.m_initialized = true;
        }
    }

    protected void ensureInitialized() {
        if (!this.m_initialized) {
            this.callInitializer();
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredLeaf() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredExpanded() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execInitTreeNode() {
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execDecorateCell(Cell cell) {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected ITreeNode execResolveVirtualChildNode(IVirtualTreeNode node) throws ProcessingException {
        return node;
    }

    private Class<? extends IMenu>[] getConfiguredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((Class[])foca);
    }

    protected void initConfig() {
        this.setLeafInternal(this.getConfiguredLeaf());
        this.setEnabledInternal(this.getConfiguredEnabled());
        this.setExpandedInternal(this.getConfiguredExpanded());
        this.m_defaultExpanded = this.getConfiguredExpanded();
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        Class<? extends IMenu>[] ma = this.getConfiguredMenus();
        int i = 0;
        while (i < ma.length) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, ma[i]);
                menuList.add(menu);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contribute menus.", (Throwable)e);
        }
        this.m_menus = menuList.toArray(new IMenu[0]);
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    public int hashCode() {
        if (this.m_hashCode != null) {
            return this.m_hashCode;
        }
        return super.hashCode();
    }

    void setHashCode(int hashCode) {
        if (this.m_hashCode != null) {
            LOG.warn("Overriding the hash code of an object will lead to inconsistent behavior of hash maps etc. setHashCode() must not be called more than once.");
        }
        this.m_hashCode = hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IVirtualTreeNode && ((IVirtualTreeNode)obj).getResolvedNode() == this) {
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public void initTreeNode() {
        this.execInitTreeNode();
    }

    @Override
    public String getNodeId() {
        String s = this.getClass().getName();
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatusInternal(int status) {
        this.m_status = status;
    }

    @Override
    public void setStatus(int status) {
        if (this.getTree() != null) {
            this.getTree().setNodeStatus(this, status);
        } else {
            this.setStatusInternal(status);
        }
    }

    @Override
    public boolean isStatusInserted() {
        return this.m_status == 1;
    }

    @Override
    public boolean isStatusUpdated() {
        return this.m_status == 2;
    }

    @Override
    public boolean isStatusDeleted() {
        return this.m_status == 3;
    }

    @Override
    public boolean isStatusNonchanged() {
        return this.m_status == 0;
    }

    @Override
    public boolean isSelectedNode() {
        if (this.getTree() != null) {
            return this.getTree().isSelectedNode(this);
        }
        return false;
    }

    @Override
    public boolean isFilterAccepted() {
        return this.m_filterAccepted;
    }

    @Override
    public void setFilterAccepted(boolean b) {
        if (this.m_filterAccepted != b) {
            this.m_filterAccepted = b;
            if (this.getParentNode() != null) {
                this.getParentNode().resetFilterCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetFilterCache() {
        Object object = this.m_filteredChildNodesLock;
        synchronized (object) {
            this.m_filteredChildNodes = null;
        }
    }

    @Override
    public ITreeNode resolveVirtualChildNode(ITreeNode node) throws ProcessingException {
        if (this.m_tree != null && node instanceof IVirtualTreeNode && node.getTree() == this.m_tree && node.getParentNode() == this) {
            try {
                this.m_tree.setTreeChanging(true);
                ITreeNode resolvedNode = this.execResolveVirtualChildNode((IVirtualTreeNode)node);
                if (node != resolvedNode) {
                    if (resolvedNode == null) {
                        this.m_tree.removeChildNode(this, node);
                    } else {
                        this.replaceChildNodeInternal(node.getChildNodeIndex(), resolvedNode);
                        this.m_tree.updateNode(resolvedNode);
                    }
                    ITreeNode iTreeNode = resolvedNode;
                    return iTreeNode;
                }
            }
            finally {
                this.m_tree.setTreeChanging(false);
            }
        }
        return node;
    }

    @Override
    public final ICell getCell() {
        return this.m_cell;
    }

    @Override
    public final Cell getCellForUpdate() {
        return this.m_cell;
    }

    @Override
    public final void decorateCell() {
        try {
            this.execDecorateCell(this.m_cell);
        }
        catch (Throwable t) {
            LOG.warn("node " + this.getClass() + " " + this.getCell().getText(), t);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.m_leaf;
    }

    @Override
    public void setLeafInternal(boolean b) {
        this.m_leaf = b;
    }

    @Override
    public void setLeaf(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeLeaf(this, b);
        } else {
            this.setLeafInternal(b);
        }
    }

    @Override
    public boolean isChecked() {
        return this.m_checked;
    }

    @Override
    public void setCheckedInternal(boolean b) {
        this.m_checked = b;
    }

    @Override
    public void setChecked(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeChecked(this, b);
        } else {
            this.setCheckedInternal(b);
        }
    }

    @Override
    public boolean isExpanded() {
        return this.m_expanded;
    }

    @Override
    public void setExpandedInternal(boolean b) {
        this.m_expanded = b;
    }

    @Override
    public boolean isInitialExpanded() {
        return this.m_defaultExpanded;
    }

    @Override
    public void setInitialExpanded(boolean b) {
        this.m_defaultExpanded = b;
    }

    @Override
    public void setExpanded(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeExpanded(this, b);
        } else {
            this.setExpandedInternal(b);
        }
    }

    @Override
    public void setVisiblePermissionInternal(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGrantedInternal(b);
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleInternal(boolean b) {
        this.m_visibleProperty = b;
        this.calculateVisible();
    }

    @Override
    public void setVisibleGrantedInternal(boolean b) {
        this.m_visibleGranted = b;
        this.calculateVisible();
    }

    private void calculateVisible() {
        this.m_visible = this.m_visibleGranted && this.m_visibleProperty;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        if (this.getTree() != null) {
            this.getTree().setNodeVisiblePermission(this, p);
        } else {
            this.setVisiblePermissionInternal(p);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeVisible(this, b);
        } else {
            this.setVisibleInternal(b);
        }
    }

    @Override
    public void setVisibleGranted(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeVisibleGranted(this, b);
        } else {
            this.setVisibleGrantedInternal(b);
        }
    }

    @Override
    public void setEnabledPermissionInternal(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setEnabledGrantedInternal(b);
    }

    @Override
    public boolean isEnabled() {
        return this.m_cell.isEnabled();
    }

    @Override
    public boolean isEnabledGranted() {
        return this.m_enabledGranted;
    }

    @Override
    public void setEnabledInternal(boolean b) {
        this.m_enabledProperty = b;
        this.calculateEnabled();
    }

    @Override
    public void setEnabledGrantedInternal(boolean b) {
        this.m_enabledGranted = b;
        this.calculateEnabled();
    }

    private void calculateEnabled() {
        this.m_cell.setEnabled(this.m_enabledGranted && this.m_enabledProperty);
    }

    @Override
    public void setEnabledPermission(Permission p) {
        if (this.getTree() != null) {
            this.getTree().setNodeEnabledPermission(this, p);
        } else {
            this.setEnabledPermissionInternal(p);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeEnabled(this, b);
        } else {
            this.setEnabledInternal(b);
        }
    }

    @Override
    public void setEnabledGranted(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeEnabledGranted(this, b);
        } else {
            this.setEnabledGrantedInternal(b);
        }
    }

    @Override
    public boolean isChildrenVolatile() {
        return this.m_childrenVolatile;
    }

    @Override
    public void setChildrenVolatile(boolean childrenVolatile) {
        this.m_childrenVolatile = childrenVolatile;
    }

    @Override
    public boolean isChildrenDirty() {
        return this.m_childrenDirty;
    }

    @Override
    public void setChildrenDirty(boolean dirty) {
        this.m_childrenDirty = dirty;
    }

    @Override
    public Object getPrimaryKey() {
        return this.m_primaryKey;
    }

    @Override
    public void setPrimaryKey(Object key) {
        this.m_primaryKey = key;
    }

    @Override
    public IMenu[] getMenus() {
        return this.m_menus;
    }

    @Override
    public <T extends IMenu> T getMenu(Class<T> menuType) throws ProcessingException {
        return (T)((IMenu)new ActionFinder().findAction(this.getMenus(), menuType));
    }

    @Override
    public void setMenus(IMenu[] a) {
        this.m_menus = a;
    }

    @Override
    public ITreeNode getParentNode() {
        return this.m_parentNode;
    }

    @Override
    public <T extends ITreeNode> T getParentNode(Class<T> type) {
        ITreeNode node = this.getParentNode();
        if (node != null && type.isAssignableFrom(node.getClass())) {
            return (T)node;
        }
        return null;
    }

    @Override
    public <T extends ITreeNode> T getParentNode(Class<T> type, int backCount) {
        ITreeNode node = this;
        while (node != null && backCount > 0) {
            node = node.getParentNode();
            --backCount;
        }
        if (backCount == 0 && node != null && type.isAssignableFrom(node.getClass())) {
            return (T)node;
        }
        return null;
    }

    @Override
    public <T extends ITreeNode> T getAncestorNode(Class<T> type) {
        ITreeNode node = this.getParentNode();
        while (node != null && !type.isAssignableFrom(node.getClass())) {
            node = node.getParentNode();
        }
        return (T)node;
    }

    @Override
    public void setParentNodeInternal(ITreeNode parent) {
        this.m_parentNode = parent;
    }

    @Override
    public int getChildNodeCount() {
        return this.m_childNodeList.size();
    }

    @Override
    public int getChildNodeIndex() {
        return this.m_childNodeIndex;
    }

    @Override
    public void setChildNodeIndexInternal(int index) {
        this.m_childNodeIndex = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITreeNode[] getFilteredChildNodes() {
        Object object = this.m_filteredChildNodesLock;
        synchronized (object) {
            if (this.m_filteredChildNodes == null) {
                Object object2 = this.m_childNodeListLock;
                synchronized (object2) {
                    ArrayList<ITreeNode> list = new ArrayList<ITreeNode>(this.m_childNodeList.size());
                    for (ITreeNode node : this.m_childNodeList) {
                        if (!node.isFilterAccepted()) continue;
                        list.add(node);
                    }
                    this.m_filteredChildNodes = list.toArray(new ITreeNode[list.size()]);
                }
            }
        }
        return this.m_filteredChildNodes;
    }

    @Override
    public int getTreeLevel() {
        int level = 0;
        ITreeNode parent = this.getParentNode();
        while (parent != null) {
            ++level;
            parent = parent.getParentNode();
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITreeNode getChildNode(int childIndex) {
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            if (childIndex >= 0 && childIndex < this.m_childNodeList.size()) {
                return this.m_childNodeList.get(childIndex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITreeNode[] getChildNodes() {
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            return this.m_childNodeList.toArray(new ITreeNode[this.m_childNodeList.size()]);
        }
    }

    @Override
    public ITreeNode findParentNode(Class<?> interfaceType) {
        ITreeNode test = this.getParentNode();
        while (test != null) {
            if (interfaceType.isInstance(test)) break;
            test = test.getParentNode();
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setChildNodeOrderInternal(ITreeNode[] nodes) {
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            ArrayList<ITreeNode> newList = new ArrayList<ITreeNode>(this.m_childNodeList.size());
            int index = 0;
            ITreeNode[] iTreeNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode n3 = iTreeNodeArray[n2];
                n3.setChildNodeIndexInternal(index);
                newList.add(n3);
                ++index;
                ++n2;
            }
            this.m_childNodeList = newList;
        }
        this.resetFilterCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChildNodesInternal(int startIndex, ITreeNode[] nodes, boolean includeSubtree) {
        int i22 = 0;
        while (i22 < nodes.length) {
            nodes[i22].setTreeInternal(this.m_tree, true);
            nodes[i22].setParentNodeInternal(this);
            ++i22;
        }
        Object i22 = this.m_childNodeListLock;
        synchronized (i22) {
            this.m_childNodeList.addAll(startIndex, Arrays.asList(nodes));
            int endIndex = this.m_childNodeList.size() - 1;
            int i = startIndex;
            while (i <= endIndex) {
                this.m_childNodeList.get(i).setChildNodeIndexInternal(i);
                ++i;
            }
        }
        ITreeNode[] iTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node = iTreeNodeArray[n2];
            this.postProcessAddRec(node, includeSubtree);
            ++n2;
        }
        this.resetFilterCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChildNodesInternal(ITreeNode[] nodes, boolean includeSubtree) {
        boolean[] removed = new boolean[nodes.length];
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            int i = 0;
            while (i < nodes.length) {
                removed[i] = this.m_childNodeList.remove(nodes[i]);
                nodes[i].setTreeInternal(null, true);
                nodes[i].setParentNodeInternal(null);
                ++i;
            }
            int startIndex = 0;
            int endIndex = this.m_childNodeList.size() - 1;
            int i2 = startIndex;
            while (i2 <= endIndex) {
                this.m_childNodeList.get(i2).setChildNodeIndexInternal(i2);
                ++i2;
            }
        }
        int i = 0;
        while (i < nodes.length) {
            if (removed[i]) {
                this.postProcessRemoveRec(nodes[i], this.getTree(), includeSubtree);
            }
            ++i;
        }
        this.resetFilterCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void replaceChildNodeInternal(int index, ITreeNode newNode) {
        ITreeNode oldNode;
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            oldNode = this.m_childNodeList.get(index);
            oldNode.setTreeInternal(null, true);
            oldNode.setParentNodeInternal(null);
            this.m_childNodeList.set(index, newNode);
            newNode.setTreeInternal(this.m_tree, true);
            newNode.setParentNodeInternal(this);
            this.m_childNodeList.get(index).setChildNodeIndexInternal(index);
        }
        this.postProcessRemoveRec(oldNode, this.m_tree, true);
        this.postProcessAddRec(newNode, true);
        this.resetFilterCache();
    }

    private void postProcessAddRec(ITreeNode node, boolean includeSubtree) {
        if (node.getTree() != null) {
            try {
                node.nodeAddedNotify();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (!node.isVisible()) {
                if (node instanceof AbstractTreeNode) {
                    ((AbstractTreeNode)node.getParentNode()).removeChildNodesInternal(new ITreeNode[]{node}, false);
                }
                return;
            }
        }
        if (node.isChildrenLoaded()) {
            node.setLeafInternal(node.getChildNodeCount() == 0);
        }
        if (includeSubtree) {
            ITreeNode[] iTreeNodeArray = node.getChildNodes();
            int n = iTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode ch = iTreeNodeArray[n2];
                if (ch != node) {
                    this.postProcessAddRec(ch, includeSubtree);
                } else {
                    LOG.warn("The node " + node + " is child of itself!");
                }
                ++n2;
            }
        }
    }

    @Override
    public void nodeAddedNotify() {
    }

    @Override
    public void nodeRemovedNotify() {
    }

    private void postProcessRemoveRec(ITreeNode node, ITree formerTree, boolean includeSubtree) {
        if (includeSubtree) {
            ITreeNode[] iTreeNodeArray = node.getChildNodes();
            int n = iTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode ch = iTreeNodeArray[n2];
                this.postProcessRemoveRec(ch, formerTree, includeSubtree);
                ++n2;
            }
        }
        if (formerTree != null) {
            try {
                node.nodeRemovedNotify();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public boolean isChildrenLoaded() {
        return this.m_childrenLoaded;
    }

    @Override
    public void setChildrenLoaded(boolean b) {
        this.m_childrenLoaded = b;
    }

    @Override
    public final void ensureChildrenLoaded() throws ProcessingException {
        if (!this.isChildrenLoaded()) {
            try {
                if (this.m_childrenLoadedLock.acquire()) {
                    this.loadChildren();
                }
            }
            finally {
                this.m_childrenLoadedLock.release();
            }
        }
    }

    @Override
    public ITree getTree() {
        return this.m_tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTreeInternal(ITree tree, boolean includeSubtree) {
        this.m_tree = tree;
        if (includeSubtree) {
            Object object = this.m_childNodeListLock;
            synchronized (object) {
                Iterator<ITreeNode> it = this.m_childNodeList.iterator();
                while (it.hasNext()) {
                    it.next().setTreeInternal(tree, includeSubtree);
                }
            }
        }
    }

    @Override
    public void loadChildren() throws ProcessingException {
    }

    @Override
    public void update() {
        this.getTree().updateNode(this);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getCell() + "]";
    }

    @Override
    public void cellChanged(ICell cell, int changedBit) {
    }

    @Override
    public Object validateValue(ICell cell, Object value) throws ProcessingException {
        return value;
    }
}

