/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeUtility;

public class TreeEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_NODES_INSERTED = 10;
    public static final int TYPE_NODES_UPDATED = 20;
    public static final int TYPE_NODE_FILTER_CHANGED = 400;
    public static final int TYPE_NODES_DELETED = 30;
    public static final int TYPE_BEFORE_NODES_SELECTED = 35;
    public static final int TYPE_NODES_SELECTED = 40;
    public static final int TYPE_CHILD_NODE_ORDER_CHANGED = 50;
    public static final int TYPE_NODE_EXPANDED = 100;
    public static final int TYPE_NODE_COLLAPSED = 101;
    public static final int TYPE_NODE_POPUP = 700;
    public static final int TYPE_NODE_ACTION = 705;
    public static final int TYPE_NODES_DRAG_REQUEST = 730;
    public static final int TYPE_NODE_DROP_ACTION = 740;
    public static final int TYPE_NODE_REQUEST_FOCUS = 200;
    public static final int TYPE_NODE_ENSURE_VISIBLE = 300;
    public static final int TYPE_REQUEST_FOCUS = 800;
    public static final int TYPE_NODE_CLICK = 820;
    public static final int TYPE_SCROLL_TO_SELECTION = 830;
    private final int m_type;
    private ITreeNode m_commonParentNode;
    private ITreeNode[] m_nodes;
    private ITreeNode[] m_deselectedNodes;
    private ITreeNode[] m_newSelectedNodes;
    private List<IMenu> m_popupMenus;
    private boolean m_consumed;
    private TransferObject m_dragObject;
    private TransferObject m_dropObject;

    public TreeEvent(ITree source, int type) {
        super(source);
        this.m_type = type;
    }

    public TreeEvent(ITree source, int type, ITreeNode node) {
        super(source);
        this.m_type = type;
        if (node != null) {
            this.m_nodes = new ITreeNode[]{node};
        }
        this.m_commonParentNode = TreeUtility.calculateCommonParentNode(this.m_nodes);
    }

    public TreeEvent(ITree source, int type, ITreeNode[] nodes) {
        super(source);
        this.m_type = type;
        if (nodes != null) {
            this.m_nodes = nodes;
        }
        this.m_commonParentNode = TreeUtility.calculateCommonParentNode(this.m_nodes);
    }

    public TreeEvent(ITree source, int type, ITreeNode parentNode, ITreeNode[] childNodes) {
        super(source);
        this.m_type = type;
        if (childNodes != null) {
            this.m_nodes = childNodes;
        }
        this.m_commonParentNode = parentNode;
        if (this.m_commonParentNode == null) {
            this.m_commonParentNode = TreeUtility.calculateCommonParentNode(this.m_nodes);
        }
    }

    public ITree getTree() {
        return (ITree)this.getSource();
    }

    public int getType() {
        return this.m_type;
    }

    public ITreeNode getCommonParentNode() {
        return this.m_commonParentNode;
    }

    public ITreeNode getDeselectedNode() {
        if (this.m_deselectedNodes != null && this.m_deselectedNodes.length > 0) {
            return this.m_deselectedNodes[0];
        }
        return null;
    }

    public ITreeNode[] getDeselectedNodes() {
        if (this.m_deselectedNodes != null) {
            return this.m_deselectedNodes;
        }
        return new ITreeNode[0];
    }

    protected void setDeselectedNodes(ITreeNode[] deselectedNodes) {
        this.m_deselectedNodes = deselectedNodes;
    }

    public ITreeNode getNewSelectedNode() {
        if (this.m_newSelectedNodes != null && this.m_newSelectedNodes.length > 0) {
            return this.m_newSelectedNodes[0];
        }
        return null;
    }

    public ITreeNode[] getNewSelectedNodes() {
        if (this.m_newSelectedNodes != null) {
            return this.m_newSelectedNodes;
        }
        return new ITreeNode[0];
    }

    protected void setNewSelectedNodes(ITreeNode[] newSelectedNodes) {
        this.m_newSelectedNodes = newSelectedNodes;
    }

    public ITreeNode getNode() {
        if (this.m_nodes != null && this.m_nodes.length > 0) {
            return this.m_nodes[0];
        }
        return null;
    }

    public ITreeNode[] getNodes() {
        if (this.m_nodes != null) {
            return this.m_nodes;
        }
        return new ITreeNode[0];
    }

    public ITreeNode getChildNode() {
        return this.getNode();
    }

    public ITreeNode[] getChildNodes() {
        return this.getNodes();
    }

    public void addPopupMenu(IMenu menu) {
        if (menu != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.add(menu);
        }
    }

    public void addPopupMenus(IMenu[] menus) {
        if (menus != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.addAll(Arrays.asList(menus));
        }
    }

    public IMenu[] getPopupMenus() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.toArray(new IMenu[0]);
        }
        return new IMenu[0];
    }

    public int getPopupMenuCount() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.size();
        }
        return 0;
    }

    public TransferObject getDragObject() {
        return this.m_dragObject;
    }

    public void setDragObject(TransferObject t) {
        this.m_dragObject = t;
    }

    public TransferObject getDropObject() {
        return this.m_dropObject;
    }

    protected void setDropObject(TransferObject t) {
        this.m_dropObject = t;
    }

    @Deprecated
    public static ITreeNode calculateCommonParentNode(ITreeNode[] nodes) {
        return TreeUtility.calculateCommonParentNode(nodes);
    }

    public boolean isConsumed() {
        return this.m_consumed;
    }

    public void consume() {
        this.m_consumed = true;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TreeEvent[");
        if (this.m_nodes != null && this.m_nodes.length > 0 && this.getTree() != null) {
            if (this.m_nodes.length == 1) {
                buf.append("\"" + this.m_nodes[0] + "\"");
            } else {
                buf.append("{");
                int i = 0;
                while (i < this.m_nodes.length) {
                    if (i >= 0) {
                        buf.append(",");
                    }
                    buf.append("\"" + this.m_nodes[i] + "\"");
                    ++i;
                }
                buf.append("}");
            }
        } else {
            buf.append("{}");
        }
        buf.append(" ");
        try {
            Field[] f = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if (Modifier.isPublic(f[i].getModifiers()) && Modifier.isStatic(f[i].getModifiers()) && f[i].getName().startsWith("TYPE_") && ((Number)f[i].get(null)).intValue() == this.m_type) {
                    buf.append(f[i].getName());
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            buf.append("#" + this.m_type);
        }
        buf.append("]");
        return buf.toString();
    }
}

