/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark.menu;

import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceEvent;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceListener;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuSeparator;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.BookmarkForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.IBookmarkForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.internal.ManageBookmarksForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.menu.ActivateBookmarkMenu;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.security.CreateGlobalBookmarkPermission;
import org.eclipse.scout.rt.shared.security.CreateUserBookmarkPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.service.SERVICES;

@Order(value=1.0)
public abstract class AbstractBookmarkMenu
extends AbstractMenu {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractBookmarkMenu.class);
    private ArrayList<IKeyStroke> m_keyStrokes;

    public AbstractBookmarkMenu() {
    }

    public AbstractBookmarkMenu(IDesktop desktop) {
    }

    @Override
    @ConfigProperty(value="TEXT")
    @ConfigPropertyValue(value="ScoutTexts.get(\"BookmarksMainMenu\")")
    @Order(value=10.0)
    protected String getConfiguredText() {
        return ScoutTexts.get((String)"BookmarksMainMenu", (String[])new String[0]);
    }

    @Override
    @ConfigOperation
    @Order(value=10.0)
    protected void execInitAction() {
        ((IBookmarkService)SERVICES.getService(IBookmarkService.class)).addBookmarkServiceListener(new BookmarkServiceListener(){

            @Override
            public void bookmarksChanged(BookmarkServiceEvent e) {
                AbstractBookmarkMenu.this.handleBookmarksChanged();
            }
        });
        this.handleBookmarksChanged();
    }

    @ConfigProperty(value="FORM")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected Class<? extends IBookmarkForm> getConfiguredBookmarkForm() {
        return BookmarkForm.class;
    }

    private void createNewBookmark(int kind) throws ProcessingException {
        Bookmark b = ClientSyncJob.getCurrentSession().getDesktop().createBookmark();
        if (b != null) {
            IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
            b.setKind(kind);
            IBookmarkForm form = null;
            if (this.getConfiguredBookmarkForm() != null) {
                try {
                    form = this.getConfiguredBookmarkForm().newInstance();
                }
                catch (Exception e) {
                    LOG.warn(null, (Throwable)e);
                }
            }
            if (form == null) {
                form = new BookmarkForm();
            }
            if (kind == 2) {
                form.setBookmarkRootFolder(service.getBookmarkData().getGlobalBookmarks());
            } else if (kind == 1) {
                form.setBookmarkRootFolder(service.getBookmarkData().getUserBookmarks());
            }
            form.setBookmark(b);
            form.startNew();
            form.waitFor();
            if (form.isFormStored()) {
                b.setTitle(form.getBookmark().getTitle());
                b.setKeyStroke(form.getBookmark().getKeyStroke());
                BookmarkFolder folder = form.getFolder();
                if (folder == null) {
                    folder = form.getBookmarkRootFolder();
                }
                folder.getBookmarks().add(b);
                service.storeBookmarks();
            }
        }
    }

    private void handleBookmarksChanged() {
        IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
        List oldList = this.getChildActions();
        ArrayList<IMenu> newList = new ArrayList<IMenu>();
        for (IMenu m : oldList) {
            if (m.getClass() == AddUserBookmarkMenu.class) {
                newList.add(m);
                continue;
            }
            if (m.getClass() == AddGlobalBookmarkMenu.class) {
                newList.add(m);
                continue;
            }
            if (m.getClass() == ManageBookmarksMenu.class) {
                newList.add(m);
                continue;
            }
            if (m.getClass() == StartBookmarkMenu.class) {
                newList.add(m);
                continue;
            }
            if (m.getClass() != Separator1Menu.class) break;
            newList.add(m);
        }
        newList.add(new MenuSeparator());
        this.addBookmarkTreeInternal(service.getBookmarkData().getGlobalBookmarks(), newList);
        newList.add(new MenuSeparator());
        this.addBookmarkTreeInternal(service.getBookmarkData().getUserBookmarks(), newList);
        this.setChildActions(newList);
    }

    private void addBookmarkTreeInternal(BookmarkFolder folder, List<IMenu> actionList) {
        for (BookmarkFolder f : folder.getFolders()) {
            MenuSeparator group = new MenuSeparator();
            group.setSeparator(false);
            group.setText(f.getTitle());
            group.setIconId(f.getIconId());
            ArrayList<IMenu> childActionList = new ArrayList<IMenu>();
            this.addBookmarkTreeInternal(f, childActionList);
            group.setChildActions(childActionList);
            actionList.add(group);
        }
        for (Bookmark b : folder.getBookmarks()) {
            actionList.add(new ActivateBookmarkMenu(b));
        }
    }

    @Order(value=2.0)
    public class AddGlobalBookmarkMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"GlobalBookmarksAddMenu", (String[])new String[0]);
        }

        @Override
        protected void execPrepareAction() {
            this.setVisiblePermission((Permission)new CreateGlobalBookmarkPermission());
        }

        @Override
        protected void execAction() throws ProcessingException {
            ((IBookmarkService)SERVICES.getService(IBookmarkService.class)).loadBookmarks();
            AbstractBookmarkMenu.this.createNewBookmark(2);
        }
    }

    @Order(value=1.0)
    public class AddUserBookmarkMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"BookmarksAddMenu", (String[])new String[0]);
        }

        @Override
        protected void execPrepareAction() {
            this.setVisiblePermission((Permission)new CreateUserBookmarkPermission());
        }

        @Override
        protected void execAction() throws ProcessingException {
            AbstractBookmarkMenu.this.createNewBookmark(1);
        }
    }

    @Order(value=3.0)
    public class ManageBookmarksMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"BookmarksManageMenu", (String[])new String[0]);
        }

        @Override
        protected void execAction() throws ProcessingException {
            ManageBookmarksForm form = new ManageBookmarksForm();
            form.startModify();
        }
    }

    @Order(value=5.0)
    public class Separator1Menu
    extends MenuSeparator {
    }

    @Order(value=4.0)
    public class StartBookmarkMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"BookmarksStartPageMenu", (String[])new String[0]);
        }

        @Order(value=1.0)
        public class ActivateStartBookmarkMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"BookmarksStartPageMenuGoto", (String[])new String[0]);
            }

            @Override
            protected void execAction() throws ProcessingException {
                IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
                Bookmark b = service.getStartBookmark();
                if (b != null) {
                    try {
                        ClientSyncJob.getCurrentSession().getDesktop().activateBookmark(b, false);
                    }
                    catch (Throwable t) {
                        LOG.error(null, t);
                    }
                }
            }
        }

        @Order(value=4.0)
        public class DeleteStartBookmarkMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"BookmarksStartPageMenuClear", (String[])new String[0]);
            }

            @Override
            protected void execAction() throws ProcessingException {
                IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
                service.deleteStartBookmark();
                service.storeBookmarks();
            }
        }

        @Order(value=2.0)
        public class Separator1Menu
        extends AbstractMenu {
            @Override
            protected boolean getConfiguredSeparator() {
                return true;
            }
        }

        @Order(value=3.0)
        public class SetStartBookmarkMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"BookmarksStartPageMenuSet", (String[])new String[0]);
            }

            @Override
            protected void execAction() throws ProcessingException {
                IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
                service.setStartBookmark();
                service.storeBookmarks();
            }
        }
    }
}

