/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline.pages;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IMemoryPolicy;
import org.eclipse.scout.rt.client.ui.DataChangeListener;
import org.eclipse.scout.rt.client.ui.WeakDataChangeListener;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.shared.ContextMap;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractPage
extends AbstractTreeNode
implements IPage {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractPage.class);
    private IForm m_detailForm;
    private final ContextMap m_contextMap;
    private boolean m_tableVisible;
    private DataChangeListener m_internalDataChangeListener;
    private final String m_userPreferenceContext;
    private IProcessingStatus m_pagePopulateStatus;

    public static String createUserPreferenceContext(Object ... vargs) {
        StringBuffer buf = new StringBuffer();
        if (vargs != null) {
            Object[] objectArray = vargs;
            int n = vargs.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (buf.length() > 0) {
                    buf.append(",");
                }
                if (o == null) {
                    buf.append("null");
                } else if (o instanceof Object[]) {
                    buf.append(Arrays.toString((Object[])o));
                } else {
                    buf.append(o.toString());
                }
                ++n2;
            }
        }
        return buf.toString();
    }

    public AbstractPage() {
        this(true);
    }

    public AbstractPage(String userPreferenceContext) {
        this(true, null, userPreferenceContext);
    }

    public AbstractPage(boolean callInitializer) {
        this(callInitializer, null, null);
    }

    public AbstractPage(ContextMap contextMap) {
        this(true, contextMap, null);
    }

    public AbstractPage(boolean callInitializer, String userPreferenceContext) {
        this(callInitializer, null, userPreferenceContext);
    }

    public AbstractPage(boolean callInitializer, ContextMap contextMap) {
        this(callInitializer, contextMap, null);
    }

    public AbstractPage(boolean callInitializer, ContextMap contextMap, String userPreferenceContext) {
        super(false);
        this.m_contextMap = contextMap;
        this.m_userPreferenceContext = userPreferenceContext;
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=35.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredTableVisible() {
        return true;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=40.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=50.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="DOC")
    @Order(value=60.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDoc() {
        return null;
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execInitPage() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execDisposePage() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=55.0)
    protected void execDataChanged(Object ... dataTypes) throws ProcessingException {
        boolean isActiveOutline;
        if (this.getTree() == null) {
            return;
        }
        HashSet<ITreeNode> pathsToSelections = new HashSet<ITreeNode>();
        ITreeNode[] iTreeNodeArray = this.getTree().getSelectedNodes();
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node;
            ITreeNode tmp = node = iTreeNodeArray[n2];
            while (tmp != null) {
                pathsToSelections.add(tmp);
                tmp = tmp.getParentNode();
            }
            ++n2;
        }
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        boolean bl = desktop != null ? desktop.getOutline() == this.getOutline() : (isActiveOutline = false);
        if (isActiveOutline && pathsToSelections.contains(this)) {
            try {
                if (desktop != null) {
                    Bookmark bm = desktop.createBookmark();
                    this.setChildrenDirty(true);
                    desktop.activateBookmark(bm, false);
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        } else {
            this.setChildrenDirty(true);
            if (this.isExpanded()) {
                this.setExpanded(false);
            }
            try {
                if (this.isChildrenLoaded()) {
                    this.getTree().unloadNode(this);
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execPageDataLoaded() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execPageActivated() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execPageDeactivated() throws ProcessingException {
    }

    protected ContextMap getContextMap() {
        return this.m_contextMap;
    }

    @Override
    protected void initConfig() {
        this.setTableVisible(this.getConfiguredTableVisible());
        super.initConfig();
    }

    @Override
    public void initPage() throws ProcessingException {
        Cell cell = this.getCellForUpdate();
        if (cell.getText() == null && this.getConfiguredTitle() != null) {
            cell.setText(this.getConfiguredTitle());
        }
        if (cell.getIconId() == null && this.getConfiguredIconId() != null) {
            cell.setIconId(this.getConfiguredIconId());
        }
        this.execInitPage();
    }

    @Override
    public IProcessingStatus getPagePopulateStatus() {
        return this.m_pagePopulateStatus;
    }

    @Override
    public void setPagePopulateStatus(IProcessingStatus status) {
        this.m_pagePopulateStatus = status;
    }

    @Override
    @Deprecated
    @ConfigOperation
    @Order(value=95.0)
    public String getBookmarkIdentifier() {
        return this.getUserPreferenceContext();
    }

    @Override
    @ConfigOperation
    @Order(value=95.0)
    public final String getUserPreferenceContext() {
        return this.m_userPreferenceContext;
    }

    @Override
    public IOutline getOutline() {
        return (IOutline)this.getTree();
    }

    @Override
    public IPage getParentPage() {
        return (IPage)this.getParentNode();
    }

    @Override
    public IPage getChildPage(int childIndex) {
        if (ClientSyncJob.isSyncClientJob()) {
            try {
                return (IPage)this.getTree().resolveVirtualNode(this.getChildNode(childIndex));
            }
            catch (ProcessingException e) {
                LOG.error("failed to create the real page from the virtual page", (Throwable)e);
            }
        }
        return (IPage)this.getChildNode(childIndex);
    }

    @Override
    public IPage[] getChildPages() {
        if (ClientSyncJob.isSyncClientJob()) {
            try {
                this.getTree().resolveVirtualNodes(this.getChildNodes());
            }
            catch (ProcessingException e) {
                LOG.error("failed to create the real page from the virtual page", (Throwable)e);
            }
        }
        ITreeNode[] a = this.getChildNodes();
        IPage[] b = new IPage[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = (IPage)a[i];
            ++i;
        }
        return b;
    }

    @Override
    public void nodeAddedNotify() {
        try {
            this.initPage();
            try {
                IMemoryPolicy policy = ClientSyncJob.getCurrentSession().getMemoryPolicy();
                if (policy != null) {
                    policy.pageCreated(this);
                }
            }
            catch (Throwable t) {
                LOG.error("pageCreated " + this.getClass().getSimpleName(), t);
            }
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
    }

    @Override
    public void nodeRemovedNotify() {
        IDesktop desktop;
        try {
            this.execDisposePage();
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
        if (this.m_internalDataChangeListener != null && (desktop = ClientSyncJob.getCurrentSession().getDesktop()) != null) {
            desktop.removeDataChangeListener(this.m_internalDataChangeListener, new Object[0]);
        }
    }

    @Override
    public void pageActivatedNotify() {
        block2: {
            try {
                this.execPageActivated();
            }
            catch (Throwable t) {
                if (t instanceof ProcessingException && ((ProcessingException)t).isInterruption()) break block2;
                LOG.warn("Caught a failure, probably due to operation cancelation by the user", t);
            }
        }
    }

    @Override
    public void pageDeactivatedNotify() {
        block2: {
            try {
                this.execPageDeactivated();
            }
            catch (Throwable t) {
                if (t instanceof ProcessingException && ((ProcessingException)t).isInterruption()) break block2;
                LOG.warn("Caught a failure, probably due to operation cancelation by the user", t);
            }
        }
    }

    @Override
    public IForm getDetailForm() {
        return this.m_detailForm;
    }

    @Override
    public void setDetailForm(IForm form) {
        if (form != null) {
            if (form.getDisplayHint() != 20) {
                form.setDisplayHint(20);
            }
            if (form.getDisplayViewId() == null) {
                form.setDisplayViewId("PAGE_DETAIL");
            }
            form.setAutoAddRemoveOnDesktop(false);
        }
        this.m_detailForm = form;
        if (this.isSelectedNode()) {
            this.getOutline().setDetailForm(this.m_detailForm);
        }
    }

    public void registerDataChangeListener(Object ... dataTypes) {
        IDesktop desktop;
        if (this.m_internalDataChangeListener == null) {
            this.m_internalDataChangeListener = new WeakDataChangeListener(){

                @Override
                public void dataChanged(Object ... innerDataTypes) throws ProcessingException {
                    AbstractPage.this.execDataChanged(innerDataTypes);
                }
            };
        }
        if ((desktop = ClientSyncJob.getCurrentSession().getDesktop()) == null) {
            desktop = ClientSyncJob.getCurrentSession().getVirtualDesktop();
        }
        desktop.addDataChangeListener(this.m_internalDataChangeListener, dataTypes);
    }

    @Override
    public void dataChanged(Object ... dataTypes) {
        try {
            this.execDataChanged(dataTypes);
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
    }

    public void unregisterDataChangeListener(Object ... dataTypes) {
        if (this.m_internalDataChangeListener != null) {
            IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
            if (desktop == null) {
                desktop = ClientSyncJob.getCurrentSession().getVirtualDesktop();
            }
            desktop.removeDataChangeListener(this.m_internalDataChangeListener, dataTypes);
        }
    }

    @Override
    public final void reloadPage() throws ProcessingException {
        ITree tree = this.getTree();
        if (tree != null) {
            try {
                tree.setTreeChanging(true);
                this.loadChildren();
                this.execPageDataLoaded();
            }
            finally {
                tree.setTreeChanging(false);
            }
        }
    }

    @Override
    public boolean isTableVisible() {
        return this.m_tableVisible;
    }

    @Override
    public void setTableVisible(boolean b) {
        this.m_tableVisible = b;
    }
}

