/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IMemoryPolicy;
import org.eclipse.scout.rt.client.services.common.search.ISearchFilterService;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.IVirtualTreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.navigation.INavigationHistoryService;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMediator;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.VirtualPage;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.shared.ContextMap;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractPageWithTable<T extends ITable>
extends AbstractPage
implements IPageWithTable<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractPageWithTable.class);
    private T m_table;
    private ISearchForm m_searchForm;
    private FormListener m_searchFormListener;
    private boolean m_searchRequired;
    private boolean m_searchActive;
    private boolean m_showEmptySpaceMenus;
    private boolean m_showTableRowMenus;
    private final HashMap<ITableRow, IPage> m_tableRowToPageMap = new HashMap();
    private final HashMap<IPage, ITableRow> m_pageToTableRowMap = new HashMap();

    public AbstractPageWithTable() {
        this(true, null, null);
    }

    public AbstractPageWithTable(boolean callInitializer) {
        this(callInitializer, null, null);
    }

    public AbstractPageWithTable(ContextMap contextMap) {
        this(true, contextMap, null);
    }

    public AbstractPageWithTable(String userPreferenceContext) {
        this(true, null, userPreferenceContext);
    }

    public AbstractPageWithTable(boolean callInitializer, ContextMap contextMap) {
        this(callInitializer, contextMap, null);
    }

    public AbstractPageWithTable(boolean callInitializer, String userPreferenceContext) {
        this(callInitializer, null, userPreferenceContext);
    }

    public AbstractPageWithTable(boolean callInitializer, ContextMap contextMap, String userPreferenceContext) {
        super(callInitializer, contextMap, userPreferenceContext);
        if (!callInitializer) {
            this.callMinimalInitializer();
        }
    }

    protected void callMinimalInitializer() {
        this.setChildrenDirty(true);
        this.setLeafInternal(this.getConfiguredLeaf());
        this.setEnabledInternal(this.getConfiguredEnabled());
        this.setExpandedInternal(this.getConfiguredExpanded());
    }

    @ConfigProperty(value="SEARCH_FORM")
    @Order(value=90.0)
    @ConfigPropertyValue(value="null")
    protected Class<? extends ISearchForm> getConfiguredSearchForm() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredSearchRequired() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=110.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredShowEmptySpaceMenus() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=120.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredShowTableRowMenus() {
        return true;
    }

    @ConfigOperation
    @Order(value=85.0)
    protected void execLoadData(SearchFilter filter) throws ProcessingException {
        this.getTable().replaceRowsByMatrix(new AtomicReference<Object[][]>(this.execLoadTableData(filter)));
    }

    @ConfigOperation
    @Order(value=90.0)
    protected Object[][] execLoadTableData(SearchFilter filter) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=100.0)
    protected void execPopulateTable() throws ProcessingException {
        if (this.isSearchActive()) {
            SearchFilter filter = this.getSearchFilter();
            if (filter.isCompleted() || !this.isSearchRequired()) {
                filter = (SearchFilter)filter.clone();
                this.execLoadData(filter);
            }
        } else {
            this.execLoadData(new SearchFilter());
        }
        if (this.isSearchActive() && this.getSearchFilter() != null && !this.getSearchFilter().isCompleted() && this.isSearchRequired()) {
            this.setPagePopulateStatus((IProcessingStatus)new ProcessingStatus(ScoutTexts.get((String)"TooManyRows", (String[])new String[0]), 2));
        } else {
            this.setPagePopulateStatus(null);
        }
    }

    @ConfigOperation
    @Order(value=110.0)
    protected IPage execCreateChildPage(ITableRow row) throws ProcessingException {
        return null;
    }

    protected IPage createChildPageInternal(ITableRow row) throws ProcessingException {
        return this.execCreateChildPage(row);
    }

    @ConfigOperation
    @Order(value=111.0)
    protected IPage execCreateVirtualChildPage(ITableRow row) throws ProcessingException {
        if (ConfigurationUtility.isMethodOverwrite(AbstractPageWithTable.class, (String)"execCreateChildPage", (Class[])new Class[]{ITableRow.class}, this.getClass())) {
            return new VirtualPage();
        }
        return null;
    }

    @Override
    protected ITreeNode execResolveVirtualChildNode(IVirtualTreeNode node) throws ProcessingException {
        ITableRow row = this.getTableRowFor(node);
        if (row == null) {
            return null;
        }
        this.unlinkTableRowWithPage(row);
        IPage childPage = this.createChildPageInternal(row);
        if (childPage != null) {
            node.setResolvedNode(childPage);
            ICell tableCell = this.m_table.getSummaryCell(row);
            childPage.setFilterAccepted(row.isFilterAccepted());
            childPage.setEnabledInternal(row.isEnabled());
            childPage.getCellForUpdate().updateFrom(tableCell);
            this.linkTableRowWithPage(row, childPage);
        }
        return childPage;
    }

    private Class<? extends ITable> getConfiguredTable() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClass((Class[])dca, ITable.class);
    }

    @Override
    protected void initConfig() {
        Class[] dca;
        Class searchFormClass;
        super.initConfig();
        this.m_searchActive = true;
        this.setSearchRequired(this.getConfiguredSearchRequired());
        this.setShowEmptySpaceMenus(this.getConfiguredShowEmptySpaceMenus());
        this.setShowTableRowMenus(this.getConfiguredShowTableRowMenus());
        Class<ITable> tableClass = this.getConfiguredTable();
        if (tableClass != null) {
            try {
                this.m_table = (ITable)ConfigurationUtility.newInnerInstance((Object)this, tableClass);
                if (this.m_table instanceof AbstractTable) {
                    ((AbstractTable)this.m_table).setContainerInternal(this);
                }
                this.m_table.addTableListener(new P_TableListener());
                this.m_table.setEnabled(this.isEnabled());
                this.m_table.setAutoDiscardOnDelete(true);
                this.m_table.setUserPreferenceContext(this.getUserPreferenceContext());
                this.m_table.initTable();
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        if (this.getConfiguredSearchForm() == null && (searchFormClass = ConfigurationUtility.filterClass((Class[])(dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass())), ISearchForm.class)) != null) {
            LOG.warn("inner searchforms are deprecated...");
            try {
                this.setSearchForm((ISearchForm)ConfigurationUtility.newInnerInstance((Object)this, (Class)searchFormClass));
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
    }

    protected void ensureSearchFormCreated() {
        if (this.m_searchForm == null) {
            try {
                this.setSearchForm(this.execCreateSearchForm());
            }
            catch (Exception e) {
                LOG.warn("unable to setSearchForm", (Throwable)e);
            }
        }
    }

    protected ISearchForm execCreateSearchForm() throws ProcessingException {
        if (this.getConfiguredSearchForm() == null) {
            return null;
        }
        try {
            return this.getConfiguredSearchForm().newInstance();
        }
        catch (Exception e) {
            LOG.warn("creation of searchForm " + this.getConfiguredSearchForm() + " failed", (Throwable)e);
            return null;
        }
    }

    protected void ensureSearchFormStarted() {
        if (this.m_searchForm != null && !this.m_searchForm.isFormOpen()) {
            try {
                this.m_searchForm.startSearch();
                this.notifyMemoryPolicyOfSearchFormStart();
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
    }

    private void attachToSearchFormInternal() {
        if (this.m_searchForm == null) {
            return;
        }
        this.m_searchForm.setDisplayHint(20);
        if (this.m_searchForm.getDisplayViewId() == null) {
            this.m_searchForm.setDisplayViewId("PAGE_SEARCH");
        }
        this.m_searchForm.setAutoAddRemoveOnDesktop(false);
        this.m_searchFormListener = new FormListener(){

            @Override
            public void formChanged(FormEvent e) throws ProcessingException {
                switch (e.getType()) {
                    case 2020: {
                        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
                        AbstractPageWithTable page = AbstractPageWithTable.this;
                        if (desktop != null && desktop.getOutline() != null && desktop.getOutline().getActivePage() == page) {
                            ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addStep(0, page);
                        }
                        try {
                            AbstractPageWithTable.this.reloadPage();
                            break;
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                    }
                }
            }
        };
        this.m_searchForm.addFormListener(this.m_searchFormListener);
        try {
            this.execInitSearchForm();
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
        }
    }

    private void detachFromSearchFormInternal() {
        if (this.m_searchForm == null) {
            return;
        }
        if (this.m_searchFormListener != null) {
            this.m_searchForm.removeFormListener(this.m_searchFormListener);
            this.m_searchFormListener = null;
        }
    }

    private void notifyMemoryPolicyOfSearchFormStart() {
        try {
            IMemoryPolicy policy = ClientSyncJob.getCurrentSession().getMemoryPolicy();
            if (policy != null) {
                policy.pageSearchFormStarted(this);
            }
        }
        catch (Throwable t) {
            LOG.error("pageCreated " + this.getClass().getSimpleName(), t);
        }
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execInitSearchForm() throws ProcessingException {
    }

    @Override
    public final T getTable() {
        if (this.m_table == null) {
            this.ensureInitialized();
        }
        return this.m_table;
    }

    @Override
    public boolean isShowEmptySpaceMenus() {
        return this.m_showEmptySpaceMenus;
    }

    @Override
    public void setShowEmptySpaceMenus(boolean showEmptySpaceMenus) {
        this.m_showEmptySpaceMenus = showEmptySpaceMenus;
    }

    @Override
    public boolean isShowTableRowMenus() {
        return this.m_showTableRowMenus;
    }

    @Override
    public void setShowTableRowMenus(boolean showTableRowMenus) {
        this.m_showTableRowMenus = showTableRowMenus;
    }

    @Override
    public ISearchForm getSearchFormInternal() {
        this.ensureSearchFormCreated();
        return this.m_searchForm;
    }

    public void setSearchForm(ISearchForm searchForm) {
        if (this.m_searchForm == searchForm) {
            return;
        }
        this.detachFromSearchFormInternal();
        this.m_searchForm = searchForm;
        this.attachToSearchFormInternal();
    }

    @Override
    public SearchFilter getSearchFilter() {
        this.ensureSearchFormCreated();
        this.ensureSearchFormStarted();
        if (this.getSearchFormInternal() != null) {
            return this.getSearchFormInternal().getSearchFilter();
        }
        ISearchFilterService sfs = (ISearchFilterService)SERVICES.getService(ISearchFilterService.class);
        if (sfs != null) {
            return sfs.createNewSearchFilter();
        }
        return new SearchFilter();
    }

    @Override
    public boolean isSearchRequired() {
        return this.m_searchRequired;
    }

    @Override
    public void setSearchRequired(boolean b) {
        this.m_searchRequired = b;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.m_table != null) {
            this.m_table.setEnabled(this.isEnabled());
        }
    }

    @Override
    public boolean isSearchActive() {
        return this.m_searchActive;
    }

    @Override
    public void setSearchActive(boolean b) {
        this.m_searchActive = b;
        if (this.isSelectedNode()) {
            this.getOutline().setSearchForm(this.m_searchActive ? this.getSearchFormInternal() : null);
        }
    }

    @Override
    public void pageActivatedNotify() {
        this.ensureInitialized();
        this.ensureSearchFormCreated();
        this.ensureSearchFormStarted();
        super.pageActivatedNotify();
    }

    @Override
    public void setPagePopulateStatus(IProcessingStatus status) {
        super.setPagePopulateStatus(status);
        this.getTable().tablePopulated();
    }

    @Override
    @Deprecated
    public IProcessingStatus getTablePopulateStatus() {
        return this.getPagePopulateStatus();
    }

    @Override
    @Deprecated
    public void setTablePopulateStatus(IProcessingStatus status) {
        this.setPagePopulateStatus(status);
    }

    private void loadTableDataImpl() throws ProcessingException {
        if (this.m_table != null) {
            try {
                try {
                    this.m_table.setTableChanging(true);
                    this.ensureSearchFormCreated();
                    this.ensureSearchFormStarted();
                    this.execPopulateTable();
                }
                catch (Throwable t) {
                    this.m_table.discardAllRows();
                    ProcessingException pe = t instanceof ProcessingException ? (ProcessingException)t : new ProcessingException(t.getMessage(), t);
                    if (pe.isInterruption()) {
                        this.setPagePopulateStatus((IProcessingStatus)new ProcessingStatus(ScoutTexts.get((String)"SearchWasCanceled", (String[])new String[0]), 8));
                    } else {
                        this.setPagePopulateStatus((IProcessingStatus)new ProcessingStatus(ScoutTexts.get((String)"ErrorWhileLoadingData", (String[])new String[0]), 8));
                    }
                    throw pe;
                }
            }
            finally {
                this.m_table.setTableChanging(false);
            }
        }
    }

    @Override
    public final void loadChildren() throws ProcessingException {
        ITree tree = this.getTree();
        try {
            Object[] oldSelectedRowKeys;
            ITreeNode oldSelectedNode;
            int oldSelectionDirectChildIndex;
            boolean oldSelectionOwned;
            block18: {
                if (tree != null) {
                    tree.setTreeChanging(true);
                }
                oldSelectionOwned = false;
                oldSelectionDirectChildIndex = -1;
                oldSelectedNode = null;
                if (tree != null) {
                    oldSelectedNode = tree.getSelectedNode();
                }
                oldSelectedRowKeys = null;
                if (oldSelectedNode != null) {
                    ITreeNode t = oldSelectedNode;
                    while (t != null && t.getParentNode() != null) {
                        if (t.getParentNode() == this) {
                            oldSelectionOwned = true;
                            oldSelectedRowKeys = this.getTableRowFor(t).getKeyValues();
                            oldSelectionDirectChildIndex = t.getChildNodeIndex();
                            break;
                        }
                        t = t.getParentNode();
                    }
                }
                this.setChildrenLoaded(false);
                ClientSyncJob.getCurrentSession().getMemoryPolicy().beforeTablePageLoadData(this);
                try {
                    try {
                        this.loadTableDataImpl();
                    }
                    catch (ProcessingException pe) {
                        if (!pe.isInterruption()) {
                            throw pe;
                        }
                        ClientSyncJob.getCurrentSession().getMemoryPolicy().afterTablePageLoadData(this);
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    ClientSyncJob.getCurrentSession().getMemoryPolicy().afterTablePageLoadData(this);
                    throw throwable;
                }
                ClientSyncJob.getCurrentSession().getMemoryPolicy().afterTablePageLoadData(this);
            }
            this.setChildrenLoaded(true);
            this.setChildrenDirty(false);
            if (tree != null && oldSelectionOwned && tree.getSelectedNode() == null) {
                int index;
                ITreeNode newSelectedNode = null;
                ITableRow row = this.getTable().getSelectedRow();
                newSelectedNode = row != null ? this.getTreeNodeFor(row) : ((row = this.getTable().findRowByKey(oldSelectedRowKeys)) != null ? this.getTreeNodeFor(row) : (oldSelectedNode != null && oldSelectedNode.getTree() == tree ? oldSelectedNode : ((index = Math.max(-1, Math.min(oldSelectionDirectChildIndex, this.getChildNodeCount() - 1))) >= 0 && index < this.getChildNodeCount() ? this.getChildNode(index) : this)));
                if (newSelectedNode != null) {
                    newSelectedNode = tree.resolveVirtualNode(newSelectedNode);
                    tree.selectNode(newSelectedNode);
                }
            }
        }
        finally {
            if (tree != null) {
                tree.setTreeChanging(false);
            }
        }
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        if (desktop != null) {
            desktop.afterTablePageLoaded(this);
        }
    }

    private void linkTableRowWithPage(ITableRow tableRow, IPage page) {
        this.m_tableRowToPageMap.put(tableRow, page);
        this.m_pageToTableRowMap.put(page, tableRow);
    }

    private void unlinkTableRowWithPage(ITableRow tableRow) {
        IPage page = this.m_tableRowToPageMap.remove(tableRow);
        if (page != null) {
            this.m_pageToTableRowMap.remove(page);
        }
    }

    @Override
    public IPage[] getUpdatedChildPagesFor(ITableRow[] tableRows) {
        return this.getChildPagesFor(tableRows, true);
    }

    private IPage[] getChildPagesFor(ITableRow[] tableRows, boolean updateChildPageCells) {
        IPage[] pages = new IPage[tableRows.length];
        int missingCount = 0;
        try {
            int i = 0;
            while (i < tableRows.length) {
                pages[i] = this.m_tableRowToPageMap.get(tableRows[i]);
                if (pages[i] != null) {
                    if (updateChildPageCells) {
                        ICell tableCell = this.getTable().getSummaryCell(tableRows[i]);
                        pages[i].setEnabledInternal(tableRows[i].isEnabled());
                        pages[i].getCellForUpdate().updateFrom(tableCell);
                    }
                } else {
                    ++missingCount;
                }
                ++i;
            }
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        if (missingCount > 0) {
            IPage[] tmp = new IPage[pages.length - missingCount];
            int index = 0;
            IPage[] iPageArray = pages;
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IPage element = iPageArray[n2];
                if (element != null) {
                    tmp[index] = element;
                    ++index;
                }
                ++n2;
            }
            pages = tmp;
        }
        return pages;
    }

    @Override
    public ITreeNode getTreeNodeFor(ITableRow tableRow) {
        if (tableRow == null) {
            return null;
        }
        return this.m_tableRowToPageMap.get(tableRow);
    }

    @Override
    public ITableRow getTableRowFor(ITreeNode childPageNode) {
        return this.m_pageToTableRowMap.get(childPageNode);
    }

    @Override
    public ITableRow[] getTableRowsFor(ITreeNode[] childPageNodes) {
        ITableRow[] rows = new ITableRow[childPageNodes.length];
        int missingCount = 0;
        int i = 0;
        while (i < childPageNodes.length) {
            rows[i] = this.m_pageToTableRowMap.get(childPageNodes[i]);
            if (rows[i] == null) {
                ++missingCount;
            }
            ++i;
        }
        if (missingCount > 0) {
            ITableRow[] tmp = new ITableRow[rows.length - missingCount];
            int index = 0;
            ITableRow[] iTableRowArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                ITableRow element = iTableRowArray[n2];
                if (element != null) {
                    tmp[index] = element;
                    ++index;
                }
                ++n2;
            }
            rows = tmp;
        }
        return rows;
    }

    private OutlineMediator getOutlineMediator() {
        if (this.getOutline() == null) {
            return null;
        }
        return this.getOutline().getOutlineMediator();
    }

    private class P_TableListener
    extends TableAdapter {
        private P_TableListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            OutlineMediator outlineMediator = AbstractPageWithTable.this.getOutlineMediator();
            switch (e.getType()) {
                case 104: {
                    if (outlineMediator == null) break;
                    outlineMediator.mediateTableRowAction(e, AbstractPageWithTable.this);
                    break;
                }
                case 102: 
                case 105: {
                    if (AbstractPageWithTable.this.isLeaf()) break;
                    ITableRow[] tableRows = e.getRows();
                    IPage[] childNodes = AbstractPageWithTable.this.getChildPagesFor(tableRows, false);
                    int i = 0;
                    while (i < childNodes.length) {
                        AbstractPageWithTable.this.unlinkTableRowWithPage(tableRows[i]);
                        ++i;
                    }
                    if (outlineMediator == null) break;
                    outlineMediator.mediateTableRowsDeleted(childNodes, AbstractPageWithTable.this);
                    break;
                }
                case 100: {
                    ITableRow element;
                    ITableRow[] tableRows;
                    if (AbstractPageWithTable.this.isLeaf()) break;
                    ArrayList<IPage> childPageList = new ArrayList<IPage>();
                    ITableRow[] iTableRowArray = tableRows = e.getRows();
                    int n = tableRows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        element = iTableRowArray[n2];
                        try {
                            IPage childPage = AbstractPageWithTable.this.execCreateVirtualChildPage(element);
                            if (childPage != null) {
                                ICell tableCell = AbstractPageWithTable.this.m_table.getSummaryCell(element);
                                childPage.getCellForUpdate().updateFrom(tableCell);
                                AbstractPageWithTable.this.linkTableRowWithPage(element, childPage);
                                childPageList.add(childPage);
                            }
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                        catch (Throwable t) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Page " + element, t));
                        }
                        ++n2;
                    }
                    if (outlineMediator != null) {
                        IPage[] childPages = childPageList.toArray(new IPage[childPageList.size()]);
                        outlineMediator.mediateTableRowsInserted(tableRows, childPages, AbstractPageWithTable.this);
                    }
                    iTableRowArray = tableRows;
                    n = tableRows.length;
                    n2 = 0;
                    while (n2 < n) {
                        element = iTableRowArray[n2];
                        IPage page = (IPage)AbstractPageWithTable.this.m_tableRowToPageMap.get(element);
                        if (page != null && page.getParentNode() == null) {
                            AbstractPageWithTable.this.unlinkTableRowWithPage(element);
                        }
                        ++n2;
                    }
                    break;
                }
                case 101: {
                    if (outlineMediator == null) break;
                    outlineMediator.mediateTableRowsUpdated(e, AbstractPageWithTable.this);
                    break;
                }
                case 200: {
                    if (outlineMediator == null) break;
                    outlineMediator.mediateTableRowOrderChanged(e, AbstractPageWithTable.this);
                    break;
                }
                case 103: {
                    break;
                }
                case 210: {
                    if (outlineMediator == null) break;
                    outlineMediator.mediateTableRowFilterChanged(AbstractPageWithTable.this);
                }
            }
        }
    }
}

