/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.IBigDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.AbstractDecimalField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;

public abstract class AbstractBigDecimalField
extends AbstractDecimalField<BigDecimal>
implements IBigDecimalField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractBigDecimalField.class);

    public AbstractBigDecimalField() {
        this(true);
    }

    public AbstractBigDecimalField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=300.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="minValue")
    protected Double getConfiguredMinValue() {
        return null;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=310.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="maxValue")
    protected Double getConfiguredMaxValue() {
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMinValue(this.getConfiguredMinValue() != null ? BigDecimal.valueOf(this.getConfiguredMinValue()) : null);
        this.setMaxValue(this.getConfiguredMaxValue() != null ? BigDecimal.valueOf(this.getConfiguredMaxValue()) : null);
    }

    @Override
    protected BigDecimal parseValueInternal(String text) throws ProcessingException {
        BigDecimal retVal = null;
        if ((text = text == null ? "" : text.trim()).length() > 0) {
            NumberFormat numberFormat = this.createNumberFormat();
            if (this.isPercent()) {
                if (text.endsWith("%")) {
                    text = StringUtility.trim((String)text.substring(0, text.length() - 1));
                }
                String suffix = "%";
                if (numberFormat instanceof DecimalFormat) {
                    suffix = ((DecimalFormat)numberFormat).getPositiveSuffix();
                }
                text = StringUtility.concatenateTokens((String[])new String[]{text, suffix});
            }
            ParsePosition p = new ParsePosition(0);
            Number n = numberFormat.parse(text, p);
            if (p.getErrorIndex() >= 0 || p.getIndex() != text.length()) {
                throw new ProcessingException(ScoutTexts.get((String)"InvalidNumberMessageX", (String[])new String[]{text}));
            }
            NumberFormat fmt = NumberFormat.getNumberInstance(LocaleThreadLocal.get());
            int npc = ("" + Math.abs(this.getMultiplier())).length() - 1;
            fmt.setMaximumFractionDigits(this.getFractionDigits() + npc);
            p = new ParsePosition(0);
            String fmtText = fmt.format(n.doubleValue());
            retVal = BigDecimal.valueOf(fmt.parse(fmtText, p).doubleValue());
            if (p.getErrorIndex() >= 0 || p.getIndex() != fmtText.length()) {
                throw new ProcessingException(ScoutTexts.get((String)"InvalidNumberMessageX", (String[])new String[]{fmtText}));
            }
        }
        return retVal;
    }
}

