/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.button;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonEvent;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButtonUIFacade;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractButton
extends AbstractFormField
implements IButton {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractButton.class);
    private final EventListenerList m_listenerList = new EventListenerList();
    private int m_systemType;
    private int m_displayStyle;
    private boolean m_processButton;
    private Object m_radioValue;
    private IMenu[] m_menus;
    private final IButtonUIFacade m_uiFacade = new P_UIFacade();
    private final OptimisticLock m_uiFacadeSetSelectedLock = new OptimisticLock();

    public AbstractButton() {
        this(true);
    }

    public AbstractButton(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @ConfigProperty(value="BUTTON_SYSTEM_TYPE")
    @Order(value=200.0)
    @ConfigPropertyValue(value="SYSTEM_TYPE_NONE")
    protected int getConfiguredSystemType() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=220.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredProcessButton() {
        return true;
    }

    @ConfigProperty(value="BUTTON_DISPLAY_STYLE")
    @Order(value=210.0)
    @ConfigPropertyValue(value="DISPLAY_STYLE_DEFAULT")
    protected int getConfiguredDisplayStyle() {
        return 0;
    }

    @Override
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredFillHorizontal() {
        return false;
    }

    @Override
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredFillVertical() {
        return false;
    }

    @Override
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredGridUseUiWidth() {
        return true;
    }

    @Override
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredGridUseUiHeight() {
        return false;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=230.0)
    @ConfigPropertyValue(value="null")
    protected Object getConfiguredRadioValue() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=190.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigOperation
    @Order(value=190.0)
    protected void execClickAction() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=200.0)
    protected void execToggleAction(boolean selected) throws ProcessingException {
    }

    private Class<? extends IMenu>[] getConfiguredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((Class[])foca);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setSystemType(this.getConfiguredSystemType());
        this.setDisplayStyleInternal(this.getConfiguredDisplayStyle());
        this.setProcessButton(this.getConfiguredProcessButton());
        this.setIconId(this.getConfiguredIconId());
        this.setRadioValue(this.getConfiguredRadioValue());
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        Class<? extends IMenu>[] menuArray = this.getConfiguredMenus();
        int i = 0;
        while (i < menuArray.length) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuArray[i]);
                menuList.add(menu);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("menu: " + menuArray[i].getName(), t));
            }
            ++i;
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e);
        }
        this.m_menus = menuList.toArray(new IMenu[0]);
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public Object getImage() {
        return this.propertySupport.getProperty("image");
    }

    @Override
    public void setImage(Object nativeImg) {
        this.propertySupport.setProperty("image", nativeImg);
    }

    @Override
    public int getSystemType() {
        return this.m_systemType;
    }

    @Override
    public void setSystemType(int systemType) {
        this.m_systemType = systemType;
    }

    @Override
    public boolean isProcessButton() {
        return this.m_processButton;
    }

    @Override
    public void setProcessButton(boolean on) {
        this.m_processButton = on;
    }

    @Override
    public boolean hasMenus() {
        return this.m_menus.length > 0;
    }

    @Override
    public IMenu[] getMenus() {
        return this.m_menus;
    }

    @Override
    public void doClick() throws ProcessingException {
        if (this.isEnabled() && this.isVisible() && this.isEnabledProcessingButton()) {
            try {
                this.setEnabledProcessingButton(false);
                this.fireButtonClicked();
                this.execClickAction();
            }
            finally {
                this.setEnabledProcessingButton(true);
            }
        }
    }

    @Override
    public Object getRadioValue() {
        return this.m_radioValue;
    }

    @Override
    public void setRadioValue(Object o) {
        this.m_radioValue = o;
    }

    @Override
    public boolean isSelected() {
        return this.propertySupport.getPropertyBool("selected");
    }

    @Override
    public void setSelected(boolean b) {
        boolean changed = this.propertySupport.setPropertyBool("selected", b);
        if (changed) {
            try {
                this.execToggleAction(b);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    @Override
    public void disarm() {
        this.fireDisarmButton();
    }

    @Override
    public void requestPopup() {
        this.fireRequestPopup();
    }

    @Override
    public int getDisplayStyle() {
        return this.m_displayStyle;
    }

    @Override
    public void setDisplayStyleInternal(int i) {
        this.m_displayStyle = i;
    }

    @Override
    public IButtonUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void addButtonListener(ButtonListener listener) {
        this.m_listenerList.add(ButtonListener.class, (EventListener)listener);
    }

    @Override
    public void removeButtonListener(ButtonListener listener) {
        this.m_listenerList.remove(ButtonListener.class, (EventListener)listener);
    }

    private void fireButtonClicked() {
        this.fireButtonEvent(new ButtonEvent(this, 1));
    }

    private void fireDisarmButton() {
        this.fireButtonEvent(new ButtonEvent(this, 3));
    }

    private void fireRequestPopup() {
        this.fireButtonEvent(new ButtonEvent(this, 4));
    }

    private IMenu[] fireButtonPopup() {
        ButtonEvent e = new ButtonEvent(this, 2);
        IMenu[] a = this.getMenus();
        int i = 0;
        while (i < a.length) {
            IMenu m = a[i];
            m.prepareAction();
            if (m.isVisible()) {
                e.addPopupMenu(m);
            }
            ++i;
        }
        this.fireButtonEvent(e);
        return e.getPopupMenus();
    }

    private void fireButtonEvent(ButtonEvent e) {
        EventListener[] listeners = this.m_listenerList.getListeners(ButtonListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ((ButtonListener)listeners[i]).buttonChanged(e);
                ++i;
            }
        }
    }

    private class P_UIFacade
    implements IButtonUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void fireButtonClickedFromUI() {
            try {
                if (AbstractButton.this.isEnabled() && AbstractButton.this.isVisible()) {
                    AbstractButton.this.doClick();
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }

        @Override
        public IMenu[] fireButtonPopupFromUI() {
            return AbstractButton.this.fireButtonPopup();
        }

        @Override
        public void setSelectedFromUI(boolean b) {
            try {
                if (AbstractButton.this.m_uiFacadeSetSelectedLock.acquire()) {
                    AbstractButton.this.setSelected(b);
                }
            }
            finally {
                AbstractButton.this.m_uiFacadeSetSelectedLock.release();
            }
        }
    }
}

