/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.calendarfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.calendar.AbstractCalendar;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.calendarfield.ICalendarField;

public abstract class AbstractCalendarField<T extends ICalendar>
extends AbstractValueField<Date>
implements ICalendarField<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCalendarField.class);
    private T m_calendar;
    private OptimisticLock m_valueSelectionMediator;

    public AbstractCalendarField() {
        this(true);
    }

    public AbstractCalendarField(boolean callInitializer) {
        super(callInitializer);
    }

    private Class<? extends ICalendar> getConfiguredCalendar() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClass((Class[])dca, ICalendar.class);
    }

    @Override
    protected void initConfig() {
        this.m_valueSelectionMediator = new OptimisticLock();
        super.initConfig();
        ClientUIPreferences env = ClientUIPreferences.getInstance();
        if (this.getConfiguredCalendar() != null) {
            try {
                this.m_calendar = (ICalendar)ConfigurationUtility.newInnerInstance((Object)this, this.getConfiguredCalendar());
                if (this.m_calendar instanceof AbstractCalendar) {
                    ((AbstractCalendar)this.m_calendar).setContainerInternal(this);
                }
                this.m_calendar.setDisplayMode(env.getCalendarDisplayMode(3));
                this.m_calendar.setDisplayCondensed(env.getCalendarDisplayCondensed(true));
                this.m_calendar.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        if (e.getPropertyName().equals("selectedDate")) {
                            AbstractCalendarField.this.syncCalendarToCalendarField();
                        }
                    }
                });
                this.syncCalendarToCalendarField();
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        } else {
            LOG.warn("there is no inner class of type ICalendar in " + this.getClass());
        }
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        this.getCalendar().initCalendar();
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        ClientUIPreferences.getInstance().setCalendarPreferences(this.getCalendar().getDisplayMode(), this.getCalendar().isDisplayCondensed());
        super.disposeFieldInternal();
        this.getCalendar().disposeCalendar();
    }

    @Override
    public final T getCalendar() {
        return this.m_calendar;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) throws ProcessingException {
        this.setValue(null);
        this.getCalendar().reloadCalendarItems();
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncCalendarFieldToCalendar();
    }

    private void syncCalendarFieldToCalendar() {
        try {
            if (this.m_valueSelectionMediator.acquire()) {
                Date value = (Date)this.getValue();
                T cal = this.getCalendar();
                cal.setSelectedDate(value);
            }
        }
        finally {
            this.m_valueSelectionMediator.release();
        }
    }

    private void syncCalendarToCalendarField() {
        try {
            if (this.m_valueSelectionMediator.acquire()) {
                T cal = this.getCalendar();
                Date value = cal.getSelectedDate();
                this.setValue(value);
            }
        }
        finally {
            this.m_valueSelectionMediator.release();
        }
    }

    @Override
    public void reloadCalendarItems() {
        this.getCalendar().reloadCalendarItems();
    }
}

