/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.chartbox;

import java.util.EventListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.chartbox.ChartBoxEvent;
import org.eclipse.scout.rt.client.ui.form.fields.chartbox.ChartBoxListener;
import org.eclipse.scout.rt.client.ui.form.fields.chartbox.IChartBox;
import org.eclipse.scout.rt.client.ui.form.fields.chartbox.IChartBoxUIFacade;

public abstract class AbstractChartBox
extends AbstractFormField
implements IChartBox {
    private IChartBoxUIFacade m_uiFacade;
    private EventListenerList m_listenerList = new EventListenerList();

    public AbstractChartBox() {
        this(true);
    }

    public AbstractChartBox(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="CHART_QNAME")
    @Order(value=190.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredChartQName() {
        return null;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.setChartQName(this.getConfiguredChartQName());
    }

    @Override
    public String getChartQName() {
        return this.propertySupport.getPropertyString("chartQName");
    }

    @Override
    public void setChartQName(String className) {
        this.propertySupport.setPropertyString("chartQName", className);
    }

    @Override
    public IChartBoxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void addChartBoxListener(ChartBoxListener listener) {
        this.m_listenerList.add(ChartBoxListener.class, (EventListener)listener);
    }

    @Override
    public void removeChartBoxListener(ChartBoxListener listener) {
        this.m_listenerList.remove(ChartBoxListener.class, (EventListener)listener);
    }

    @Override
    public void refreshChart() {
        this.fireDataChanged();
    }

    private void fireDataChanged() {
        this.fireChartBoxEvent(new ChartBoxEvent(this, 100));
    }

    private void fireChartBoxEvent(ChartBoxEvent e) {
        EventListener[] listeners = this.m_listenerList.getListeners(ChartBoxListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ((ChartBoxListener)listeners[i]).chartBoxChanged(e);
                ++i;
            }
        }
    }

    private class P_UIFacade
    implements IChartBoxUIFacade {
        private P_UIFacade() {
        }
    }
}

