/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.filechooserfield;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.filechooser.FileChooser;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserFieldUIFacade;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;

public abstract class AbstractFileChooserField
extends AbstractValueField<String>
implements IFileChooserField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractFileChooserField.class);
    private File m_directory;
    private String[] m_fileExtensions;
    private boolean m_typeLoad;
    private boolean m_folderMode;
    private boolean m_showDirectory;
    private boolean m_showFileName;
    private boolean m_showFileExtension;
    private IMenu[] m_menus;
    private IFileChooserFieldUIFacade m_uiFacade;

    public AbstractFileChooserField() {
        this(true);
    }

    public AbstractFileChooserField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredFolderMode() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredShowDirectory() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredShowFileName() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredShowFileExtension() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredTypeLoad() {
        return false;
    }

    @ConfigProperty(value="FILE_EXTENSIONS")
    @Order(value=230.0)
    @ConfigPropertyValue(value="null")
    protected String[] getConfiguredFileExtensions() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=290.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDirectory() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=300.0)
    @ConfigPropertyValue(value="AbstractIcons.FileChooserFieldFile")
    protected String getConfiguredFileIconId() {
        return "filechooserfield_file";
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=310.0)
    @ConfigPropertyValue(value="4000")
    @ValidationRule(value="maxLength")
    protected int getConfiguredMaxLength() {
        return 4000;
    }

    private Class<? extends IMenu>[] getConfiguredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((Class[])foca);
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.setFolderMode(this.getConfiguredFolderMode());
        this.setShowDirectory(this.getConfiguredShowDirectory());
        this.setShowFileName(this.getConfiguredShowFileName());
        this.setShowFileExtension(this.getConfiguredShowFileExtension());
        this.setTypeLoad(this.getConfiguredTypeLoad());
        this.setFileExtensions(this.getConfiguredFileExtensions());
        if (this.getConfiguredDirectory() != null) {
            this.setDirectory(new File(this.getConfiguredDirectory()));
        }
        this.setFileIconId(this.getConfiguredFileIconId());
        this.setMaxLength(this.getConfiguredMaxLength());
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        Class<? extends IMenu>[] a = this.getConfiguredMenus();
        int i = 0;
        while (i < a.length) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, a[i]);
                menuList.add(menu);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e);
        }
        this.m_menus = menuList.toArray(new IMenu[0]);
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    @Override
    public IFileChooserFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void setFolderMode(boolean b) {
        this.m_folderMode = b;
        if (this.isInitialized() && this.isAutoDisplayText()) {
            this.setDisplayText(this.execFormatValue((String)this.getValue()));
        }
    }

    @Override
    public boolean isFolderMode() {
        return this.m_folderMode;
    }

    @Override
    public void setShowDirectory(boolean b) {
        this.m_showDirectory = b;
        if (UserAgentUtility.isWebClient()) {
            this.m_showDirectory = false;
        }
        if (this.isInitialized() && this.isAutoDisplayText()) {
            this.setDisplayText(this.execFormatValue((String)this.getValue()));
        }
    }

    @Override
    public boolean isShowDirectory() {
        return this.m_showDirectory;
    }

    @Override
    public void setShowFileName(boolean b) {
        this.m_showFileName = b;
        if (this.isInitialized() && this.isAutoDisplayText()) {
            this.setDisplayText(this.execFormatValue((String)this.getValue()));
        }
    }

    @Override
    public boolean isShowFileName() {
        return this.m_showFileName;
    }

    @Override
    public void setShowFileExtension(boolean b) {
        this.m_showFileExtension = b;
        if (this.isInitialized() && this.isAutoDisplayText()) {
            this.setDisplayText(this.execFormatValue((String)this.getValue()));
        }
    }

    @Override
    public boolean isShowFileExtension() {
        return this.m_showFileExtension;
    }

    @Override
    public void setTypeLoad(boolean b) {
        this.m_typeLoad = b;
    }

    @Override
    public boolean isTypeLoad() {
        return this.m_typeLoad;
    }

    @Override
    public void setFileExtensions(String[] a) {
        this.m_fileExtensions = a;
    }

    @Override
    public String[] getFileExtensions() {
        return this.m_fileExtensions;
    }

    @Override
    public void setDirectory(File d) {
        this.m_directory = d;
    }

    @Override
    public File getDirectory() {
        return this.m_directory;
    }

    @Override
    public void setFileIconId(String s) {
        this.propertySupport.setPropertyString("fileIconId", s);
    }

    @Override
    public String getFileIconId() {
        return this.propertySupport.getPropertyString("fileIconId");
    }

    @Override
    public void setMaxLength(int len) {
        if (len > 0) {
            this.propertySupport.setPropertyInt("maxLength", len);
        }
        if (this.isInitialized()) {
            this.setValue((String)this.getValue());
        }
    }

    @Override
    public int getMaxLength() {
        int len = this.propertySupport.getPropertyInt("maxLength");
        if (len <= 0) {
            len = 200;
        }
        return len;
    }

    @Override
    public IMenu[] getMenus() {
        return this.m_menus;
    }

    @Override
    public boolean hasMenus() {
        return this.m_menus.length > 0;
    }

    @Override
    public IFileChooser getFileChooser() {
        FileChooser fc = new FileChooser();
        fc.setTypeLoad(this.isTypeLoad());
        fc.setFolderMode(this.isFolderMode());
        fc.setDirectory(this.getDirectory());
        fc.setFileName(this.getFileName());
        fc.setFileExtensions(this.getFileExtensions());
        fc.setMultiSelect(false);
        return fc;
    }

    @Override
    public File getValueAsFile() {
        String value = (String)this.getValue();
        if (value == null) {
            return null;
        }
        return new File(value);
    }

    @Override
    public String getFileName() {
        File f = this.getValueAsFile();
        if (f != null) {
            return f.getName();
        }
        return null;
    }

    @Override
    public long getFileSize() {
        File f = this.getValueAsFile();
        if (f != null) {
            return f.length();
        }
        return 0L;
    }

    @Override
    public boolean fileExists() {
        if (this.getValue() == null) {
            return false;
        }
        return this.getValueAsFile().exists();
    }

    @Override
    protected String formatValueInternal(String validValue) {
        String s = validValue;
        if (s != null && s.length() > 0) {
            File f = new File(s);
            if (this.isFolderMode()) {
                s = this.isShowDirectory() ? f.getAbsolutePath() : f.getName();
            } else if (this.isShowDirectory() && this.isShowFileName() && this.isShowFileExtension()) {
                s = f.getAbsolutePath();
            } else {
                String p = StringUtility.valueOf((Object)f.getParent());
                String n = f.getName();
                String e = "";
                if (n.indexOf(46) >= 0) {
                    int i = n.lastIndexOf(46);
                    e = n.substring(i);
                    n = n.substring(0, i);
                }
                s = "";
                if (this.isShowDirectory()) {
                    s = p;
                }
                if (this.isShowFileName()) {
                    if (s.length() > 0) {
                        s = String.valueOf(s) + File.separator;
                    }
                    s = String.valueOf(s) + n;
                }
                if (this.isShowFileExtension()) {
                    s = String.valueOf(s) + e;
                }
            }
        }
        return s;
    }

    @Override
    protected String parseValueInternal(String text) throws ProcessingException {
        String retVal = null;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if (text != null) {
            text = text.trim();
            text = StringUtility.unquoteText((String)text);
            File f = new File(text);
            String p = "";
            if (f.isAbsolute()) {
                p = f.getParent();
            } else {
                File existingFile = this.getValueAsFile();
                if (existingFile != null && existingFile.isAbsolute()) {
                    p = existingFile.getParent();
                }
            }
            String n = f.getName();
            String e = "";
            if (n.indexOf(46) >= 0) {
                int i = n.lastIndexOf(46);
                e = n.substring(i);
                n = n.substring(0, i);
            }
            text = n;
            if (p.length() == 0 && this.getDirectory() != null) {
                p = this.getDirectory().getAbsolutePath();
            }
            if (e.length() == 0 && this.m_fileExtensions != null && this.m_fileExtensions.length > 0) {
                e = "." + this.m_fileExtensions[0];
            }
            text = p;
            if (p.length() > 0) {
                text = String.valueOf(text) + File.separator;
            }
            text = String.valueOf(text) + n;
            retVal = text = String.valueOf(text) + e;
        }
        return retVal;
    }

    @Override
    protected String validateValueInternal(String text) throws ProcessingException {
        if (text != null && text.length() == 0) {
            text = null;
        }
        if (text != null && text.length() > this.getMaxLength()) {
            text = text.substring(0, this.getMaxLength());
        }
        return text;
    }

    private class P_UIFacade
    implements IFileChooserFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public IMenu[] firePopupFromUI() {
            ArrayList<IMenu> menus = new ArrayList<IMenu>();
            IMenu[] iMenuArray = AbstractFileChooserField.this.getMenus();
            int n = iMenuArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMenu menu = iMenuArray[n2];
                menu.prepareAction();
                if (menu.isVisible()) {
                    menus.add(menu);
                }
                ++n2;
            }
            return menus.toArray(new IMenu[0]);
        }

        @Override
        public boolean setTextFromUI(String newText) {
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            return AbstractFileChooserField.this.parseValue(newText);
        }
    }
}

