/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.imagebox;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageField;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.ImageFieldEvent;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.ImageFieldListener;
import org.eclipse.scout.rt.shared.data.basic.AffineTransformSpec;
import org.eclipse.scout.rt.shared.data.basic.BoundsSpec;

public abstract class AbstractImageField
extends AbstractFormField
implements IImageField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractImageField.class);
    private IImageFieldUIFacade m_uiFacade;
    private final EventListenerList m_listenerList = new EventListenerList();
    private IMenu[] m_menus;
    private double m_zoomDelta;
    private double m_panDelta;
    private double m_rotateDelta;

    public AbstractImageField() {
        this(true);
    }

    public AbstractImageField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    @ConfigPropertyValue(value="0")
    protected int getConfiguredVerticalAlignment() {
        return 0;
    }

    @Override
    @ConfigPropertyValue(value="0")
    protected int getConfiguredHorizontalAlignment() {
        return 0;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=300.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredImageId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=310.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredFocusVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=320.0)
    @ConfigPropertyValue(value="null")
    protected boolean getConfiguredAutoFit() {
        return false;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=330.0)
    @ConfigPropertyValue(value="1.25")
    protected double getConfiguredZoomDelta() {
        return 1.25;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=340.0)
    @ConfigPropertyValue(value="10")
    protected double getConfiguredPanDelta() {
        return 10.0;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=350.0)
    @ConfigPropertyValue(value="10")
    protected double getConfiguredRotateDelta() {
        return 10.0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=360.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredScrollBarEnabled() {
        return false;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=400.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=410.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredDragType() {
        return 0;
    }

    @ConfigOperation
    @Order(value=500.0)
    protected TransferObject execDragRequest() throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=510.0)
    protected void execDropRequest(TransferObject transferObject) throws ProcessingException {
    }

    private Class<? extends IMenu>[] getConfiguredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((Class[])foca);
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.setImageTransform(new AffineTransformSpec());
        this.setAutoFit(this.getConfiguredAutoFit());
        this.setFocusVisible(this.getConfiguredFocusVisible());
        this.setImageId(this.getConfiguredImageId());
        this.setPanDelta(this.getConfiguredPanDelta());
        this.setRotateDelta(this.getConfiguredRotateDelta());
        this.setZoomDelta(this.getConfiguredZoomDelta());
        this.setDragType(this.getConfiguredDragType());
        this.setDropType(this.getConfiguredDropType());
        this.setScrollBarEnabled(this.getConfiguredScrollBarEnabled());
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        Class<? extends IMenu>[] a = this.getConfiguredMenus();
        int i = 0;
        while (i < a.length) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, a[i]);
                menuList.add(menu);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e);
        }
        this.m_menus = menuList.toArray(new IMenu[0]);
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    @Override
    public void addImageFieldListener(ImageFieldListener listener) {
        this.m_listenerList.add(ImageFieldListener.class, (EventListener)listener);
    }

    @Override
    public void removeImageFieldListener(ImageFieldListener listener) {
        this.m_listenerList.remove(ImageFieldListener.class, (EventListener)listener);
    }

    private void fireZoomRectangle(BoundsSpec r) {
        this.fireImageBoxEventInternal(new ImageFieldEvent(this, 10, r));
    }

    private void fireAutoFit() {
        this.fireImageBoxEventInternal(new ImageFieldEvent(this, 20));
    }

    private IMenu[] firePopup() {
        ImageFieldEvent e = new ImageFieldEvent(this, 30);
        IMenu[] a = this.getMenus();
        int i = 0;
        while (i < a.length) {
            IMenu m = a[i];
            m.prepareAction();
            if (m.isVisible()) {
                e.addPopupMenu(m);
            }
            ++i;
        }
        this.fireImageBoxEventInternal(e);
        return e.getPopupMenus();
    }

    private void fireImageBoxEventInternal(ImageFieldEvent e) {
        EventListener[] a = this.m_listenerList.getListeners(ImageFieldListener.class);
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                ((ImageFieldListener)a[i]).imageFieldChanged(e);
                ++i;
            }
        }
    }

    @Override
    public Object getImage() {
        return this.propertySupport.getProperty("image");
    }

    @Override
    public void setImage(Object imgObj) {
        this.propertySupport.setProperty("image", imgObj);
    }

    @Override
    public String getImageId() {
        return this.propertySupport.getPropertyString("imageId");
    }

    @Override
    public void setImageId(String imageId) {
        this.propertySupport.setPropertyString("imageId", imageId);
    }

    @Override
    public IMenu[] getMenus() {
        return this.m_menus;
    }

    @Override
    public double getZoomDeltaValue() {
        return this.m_zoomDelta;
    }

    @Override
    public void setZoomDelta(double d) {
        this.m_zoomDelta = d;
    }

    @Override
    public double getPanDelta() {
        return this.m_panDelta;
    }

    @Override
    public void setPanDelta(double d) {
        this.m_panDelta = d;
    }

    @Override
    public double getRotateDelta() {
        return this.m_rotateDelta;
    }

    @Override
    public void setRotateDelta(double deg) {
        this.m_rotateDelta = deg;
    }

    @Override
    public void setRotateDeltaInRadians(double rad) {
        this.setRotateDelta(Math.toDegrees(rad));
    }

    @Override
    public AffineTransformSpec getImageTransform() {
        return new AffineTransformSpec((AffineTransformSpec)this.propertySupport.getProperty("imageTransform"));
    }

    @Override
    public void setImageTransform(AffineTransformSpec t) {
        this.propertySupport.setProperty("imageTransform", (Object)new AffineTransformSpec(t));
    }

    @Override
    public boolean isFocusVisible() {
        return this.propertySupport.getPropertyBool("focusVisible");
    }

    @Override
    public void setFocusVisible(boolean b) {
        this.propertySupport.setPropertyBool("focusVisible", b);
    }

    @Override
    public BoundsSpec getAnalysisRectangle() {
        return (BoundsSpec)this.propertySupport.getProperty("analysisRectangle");
    }

    @Override
    public void setAnalysisRectangle(BoundsSpec rect) {
        this.propertySupport.setProperty("analysisRectangle", (Object)rect);
    }

    @Override
    public void setAnalysisRectangle(int x, int y, int w, int h) {
        this.setAnalysisRectangle(new BoundsSpec(x, y, w, h));
    }

    @Override
    public boolean isAutoFit() {
        return this.propertySupport.getPropertyBool("autoFit");
    }

    @Override
    public void setAutoFit(boolean b) {
        this.propertySupport.setPropertyBool("autoFit", b);
    }

    @Override
    public boolean isScrollBarEnabled() {
        return this.propertySupport.getPropertyBool("scrollBarEnabled");
    }

    @Override
    public void setScrollBarEnabled(boolean b) {
        this.propertySupport.setPropertyBool("scrollBarEnabled", b);
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public byte[] getByteArrayValue() {
        Object value = this.getImage();
        byte[] b = null;
        if (value instanceof byte[]) {
            b = (byte[])value;
        }
        return b;
    }

    @Override
    public void doAutoFit() {
        this.fireAutoFit();
    }

    @Override
    public void doZoomRectangle(int x, int y, int w, int h) {
        this.fireZoomRectangle(new BoundsSpec(x, y, w, h));
    }

    @Override
    public void doPan(double dx, double dy) {
        AffineTransformSpec t = this.getImageTransform();
        t.dx = dx;
        t.dy = dy;
        this.setImageTransform(t);
    }

    @Override
    public void doRelativePan(double dx, double dy) {
        AffineTransformSpec t = this.getImageTransform();
        t.dx += dx;
        t.dy += dy;
        this.setImageTransform(t);
    }

    @Override
    public void doZoom(double fx, double fy) {
        AffineTransformSpec t = this.getImageTransform();
        t.sx = fx;
        t.sy = fy;
        this.setImageTransform(t);
    }

    @Override
    public void doRelativeZoom(double fx, double fy) {
        AffineTransformSpec t = this.getImageTransform();
        t.sx *= fx;
        t.sy *= fy;
        this.setImageTransform(t);
    }

    @Override
    public void doRotate(double angle) {
        AffineTransformSpec t = this.getImageTransform();
        t.angle = angle;
        this.setImageTransform(t);
    }

    @Override
    public void doRelativeRotate(double angleInDegrees) {
        AffineTransformSpec t = this.getImageTransform();
        t.angle += Math.toRadians(angleInDegrees);
        this.setImageTransform(t);
    }

    @Override
    public IImageFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private class P_UIFacade
    implements IImageFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void setImageTransformFromUI(AffineTransformSpec t) {
            AbstractImageField.this.setImageTransform(t);
        }

        @Override
        public IMenu[] firePopupFromUI() {
            return AbstractImageField.this.firePopup();
        }

        @Override
        public TransferObject fireDragRequestFromUI() {
            TransferObject t = null;
            try {
                t = AbstractImageField.this.execDragRequest();
            }
            catch (ProcessingException e) {
                LOG.warn(null, (Throwable)e);
            }
            return t;
        }

        @Override
        public void fireDropActionFromUi(TransferObject scoutTransferable) {
            try {
                AbstractImageField.this.execDropRequest(scoutTransferable);
            }
            catch (ProcessingException e) {
                LOG.warn(null, (Throwable)e);
            }
        }
    }
}

