/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.useradmin;

import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.pwd.IPasswordManagementService;
import org.eclipse.scout.service.SERVICES;

public class DefaultPasswordForm
extends AbstractForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultPasswordForm.class);
    private String m_userId;

    public String getUserId() {
        return this.m_userId;
    }

    public void setUserId(String userId) {
        this.m_userId = userId;
    }

    @Override
    protected String getConfiguredTitle() {
        return ScoutTexts.get((String)"ChangePassword", (String[])new String[0]);
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.GroupBox.OldPasswordField getOldPasswordField() {
        return this.getFieldByClass(MainBox.GroupBox.OldPasswordField.class);
    }

    public MainBox.GroupBox.NewPasswordField getNewPasswordField() {
        return this.getFieldByClass(MainBox.GroupBox.NewPasswordField.class);
    }

    public MainBox.GroupBox.RepeatPasswordField getRepeatPasswordField() {
        return this.getFieldByClass(MainBox.GroupBox.RepeatPasswordField.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.CancelButton getCancelButton() {
        return this.getFieldByClass(MainBox.CancelButton.class);
    }

    public void startChange() throws ProcessingException {
        this.startInternal(new ChangeHandler());
    }

    public void startReset() throws ProcessingException {
        this.startInternal(new ResetHandler());
    }

    @Order(value=20.0)
    public class ChangeHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() throws ProcessingException {
        }

        @Override
        protected void execStore() throws ProcessingException {
            if (DefaultPasswordForm.this.getNewPasswordField().getValue() != null && !((String)DefaultPasswordForm.this.getNewPasswordField().getValue()).equals(DefaultPasswordForm.this.getRepeatPasswordField().getValue())) {
                throw new VetoException(ScoutTexts.get((String)"PasswordsDoNotMatch", (String[])new String[0]));
            }
            IPasswordManagementService svc = (IPasswordManagementService)SERVICES.getService(IPasswordManagementService.class);
            svc.changePassword(DefaultPasswordForm.this.getUserId(), (String)DefaultPasswordForm.this.getOldPasswordField().getValue(), (String)DefaultPasswordForm.this.getNewPasswordField().getValue());
        }
    }

    @Order(value=20.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 1;
        }

        @Order(value=50.0)
        public class CancelButton
        extends AbstractCancelButton {
        }

        @Order(value=10.0)
        public class GroupBox
        extends AbstractGroupBox {

            @Order(value=20.0)
            public class NewPasswordField
            extends AbstractStringField {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"NewPassword", (String[])new String[0]);
                }

                @Override
                protected boolean getConfiguredMandatory() {
                    return true;
                }

                @Override
                protected boolean getConfiguredInputMasked() {
                    return true;
                }
            }

            @Order(value=10.0)
            public class OldPasswordField
            extends AbstractStringField {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"OldPassword", (String[])new String[0]);
                }

                @Override
                protected boolean getConfiguredMandatory() {
                    return true;
                }

                @Override
                protected boolean getConfiguredInputMasked() {
                    return true;
                }
            }

            @Order(value=30.0)
            public class RepeatPasswordField
            extends AbstractStringField {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"RepeatPassword", (String[])new String[0]);
                }

                @Override
                protected boolean getConfiguredMandatory() {
                    return true;
                }

                @Override
                protected boolean getConfiguredInputMasked() {
                    return true;
                }
            }
        }

        @Order(value=40.0)
        public class OkButton
        extends AbstractOkButton {
        }
    }

    @Order(value=10.0)
    public class ResetHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() throws ProcessingException {
            DefaultPasswordForm.this.getOldPasswordField().setMandatory(false);
            DefaultPasswordForm.this.getOldPasswordField().setVisible(false);
        }

        @Override
        protected void execStore() throws ProcessingException {
            if (DefaultPasswordForm.this.getNewPasswordField().getValue() != null && !((String)DefaultPasswordForm.this.getNewPasswordField().getValue()).equals(DefaultPasswordForm.this.getRepeatPasswordField().getValue())) {
                throw new VetoException(ScoutTexts.get((String)"PasswordsDoNotMatch", (String[])new String[0]));
            }
            IPasswordManagementService svc = (IPasswordManagementService)SERVICES.getService(IPasswordManagementService.class);
            svc.resetPassword(DefaultPasswordForm.this.getUserId(), (String)DefaultPasswordForm.this.getNewPasswordField().getValue());
        }
    }
}

