/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.Activator;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.client.ui.IIconLocator;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.wizard.AbstractWizardStatusField;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStatusHtmlProvider;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;

public class DefaultWizardStatusHtmlProvider
implements IWizardStatusHtmlProvider {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultWizardStatusHtmlProvider.class);
    private String m_htmlTemplate;

    @Override
    public void initialize(AbstractWizardStatusField htmlField) throws ProcessingException {
        this.m_htmlTemplate = this.initHtmlTemplate();
        List<RemoteFile> attachments = this.collectAttachments();
        if (attachments != null && attachments.size() > 0) {
            htmlField.setAttachments(attachments.toArray(new RemoteFile[attachments.size()]));
        }
    }

    @Override
    public String initHtmlTemplate() throws ProcessingException {
        try {
            return new String(IOUtility.getContent((InputStream)Activator.getDefault().getBundle().getResource("resources/html/defaultWizardStatus.html").openStream()), "iso-8859-1");
        }
        catch (Throwable t) {
            throw new ProcessingException("Unexpected", t);
        }
    }

    protected String getHtmlTemplate() {
        return this.m_htmlTemplate;
    }

    @Override
    public String createHtml(IWizard w) throws ProcessingException {
        String html = this.m_htmlTemplate;
        String topPart = "";
        String bottomPart = "";
        StringBuilder listPart = new StringBuilder();
        if (w != null) {
            if (w.getTooltipText() != null) {
                topPart = "<div class=\"infoBox\">" + StringUtility.nvl((Object)w.getTitleHtml(), (String)w.getTooltipText()) + "</div>";
            }
            if (w.getActiveStep() != null && (w.getActiveStep().getTooltipText() != null || w.getActiveStep().getDescriptionHtml() != null)) {
                bottomPart = "<div class=\"infoBox\">" + StringUtility.nvl((Object)w.getActiveStep().getDescriptionHtml(), (String)w.getActiveStep().getTooltipText()) + "</div>";
            }
            int index = 1;
            Iterator<IWizardStep<? extends IForm>> iterator = w.getSteps().iterator();
            while (iterator.hasNext()) {
                IWizardStep<? extends IForm> step;
                String s = this.createHtmlForStep(step, index, (step = iterator.next()) == w.getActiveStep());
                if (!StringUtility.hasText((String)s)) continue;
                listPart.append(s);
                ++index;
            }
        }
        html = html.replace("#FONT_SIZE_UNIT#", UserAgentUtility.getFontSizeUnit());
        html = html.replace("#TOP#", topPart);
        html = html.replace("#LIST#", listPart.toString());
        html = html.replace("#BOTTOM#", bottomPart);
        return html;
    }

    protected String createHtmlForStep(IWizardStep<?> step, int index, boolean selected) {
        String cssClass = selected ? "selected" : (step.isEnabled() ? "default" : "disabled");
        StringBuilder buf = new StringBuilder();
        String spacerCssClass = "selected".equals(cssClass) ? "spacerselected" : "spacer";
        this.appendHtmlForSpacerLine(buf, spacerCssClass, 7, "STEP_" + index);
        buf.append("<tr class=\"" + cssClass + "\">\n");
        buf.append(" <td width=\"15\"><img src=\"empty.png\" width=\"1\" height=\"30\"></td>\n");
        buf.append(" <td width=\"24\" valign=\"top\" class=\"bullet\" style=\"padding:0px;padding-top:" + (UserAgentUtility.isRichClient() ? "4" : "5") + "px;\">" + index + "</td>\n");
        buf.append(" <td width=\"17\"></td>\n");
        buf.append(" <td style=\"padding-top:2px;\">" + StringUtility.nvl((Object)step.getTitleHtml(), (String)step.getTitle()) + "</td>\n");
        buf.append(" <td width=\"15\"></td>\n");
        buf.append("</tr>\n");
        this.appendHtmlForSpacerLine(buf, spacerCssClass, 11, null);
        this.appendHtmlForSpacerLine(buf, "line", 1, null);
        return buf.toString();
    }

    protected void appendHtmlForSpacerLine(StringBuilder buf, String cssClass, int height, String anchor) {
        buf.append("<tr class=\"" + cssClass + "\"><td colspan=\"5\">");
        if (!StringUtility.isNullOrEmpty((String)anchor)) {
            buf.append("<a name=\"" + anchor + "\"/>");
        }
        buf.append("<img src=\"empty.png\" width=\"1\" height=\"" + height + "\"></td></tr>\n");
    }

    protected List<RemoteFile> collectAttachments() {
        LinkedList<RemoteFile> attachments = new LinkedList<RemoteFile>();
        this.loadIcon(attachments, "empty.png");
        this.loadIcon(attachments, "wizard_bullet.png");
        this.loadIcon(attachments, "wizard_bullet_disabled.png");
        this.loadIcon(attachments, "wizard_bullet_selected.png");
        return attachments;
    }

    protected void loadIcon(List<RemoteFile> attachments, String iconName) {
        block17: {
            if (attachments == null || iconName == null) {
                return;
            }
            String tempIconName = iconName;
            ByteArrayInputStream is = null;
            try {
                try {
                    IIconLocator iconLocator;
                    IconSpec iconSpec;
                    String format = null;
                    int index = tempIconName.lastIndexOf(46);
                    if (index > 0) {
                        format = tempIconName.substring(index);
                        tempIconName = tempIconName.substring(0, index);
                    }
                    String baseIconName = tempIconName;
                    index = tempIconName.lastIndexOf(95);
                    if (index > 0) {
                        baseIconName = tempIconName.substring(0, index);
                    }
                    if ((iconSpec = (iconLocator = ClientSyncJob.getCurrentSession().getIconLocator()).getIconSpec(tempIconName)) == null && !tempIconName.equals(baseIconName)) {
                        iconSpec = iconLocator.getIconSpec(baseIconName);
                    }
                    if (iconSpec != null) {
                        RemoteFile iconFile = new RemoteFile(StringUtility.join((String)"", (Object[])new Object[]{tempIconName, format}), 0L);
                        is = new ByteArrayInputStream(iconSpec.getContent());
                        iconFile.readData((InputStream)is);
                        is.close();
                        attachments.add(iconFile);
                    }
                }
                catch (Throwable t) {
                    LOG.warn("Failed to load icon '" + tempIconName + "'", t);
                    if (is == null) break block17;
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

