/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.extension.client.Activator;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.IPageModifier;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal.PageContributionExtension;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal.PageExtensionManager;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal.PageModificationExtension;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal.PageRemoveExtension;

public final class PageExtensionUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PageExtensionUtility.class);

    private PageExtensionUtility() {
    }

    public static void adaptPageWithNodes(IPageWithNodes nodePage, Collection<IPage> pageList) throws ProcessingException {
        if (nodePage == null) {
            throw new ProcessingException("nodePage must not be null");
        }
        if (pageList == null) {
            throw new ProcessingException("pageList must not be null");
        }
        IOutline outline = nodePage.getOutline();
        PageExtensionManager extensionManager = Activator.getDefault().getPagesExtensionManager();
        PageExtensionUtility.contributePages(outline, nodePage, extensionManager.getPageContributionExtensions(), pageList);
        PageExtensionUtility.removePages(outline, (IPage)nodePage, extensionManager.getPageRemovalExtensions(), pageList);
        PageExtensionUtility.modifyPages(outline, (IPage)nodePage, extensionManager.getPageModificationExtensions(), pageList);
    }

    public static void adaptOutline(IOutline outline, Collection<IPage> pageList) throws ProcessingException {
        if (outline == null) {
            throw new ProcessingException("outline must not be null");
        }
        if (pageList == null) {
            throw new ProcessingException("pageList must not be null");
        }
        PageExtensionManager extensionManager = Activator.getDefault().getPagesExtensionManager();
        PageExtensionUtility.contributePages(outline, null, extensionManager.getPageContributionExtensions(), pageList);
        PageExtensionUtility.removePages(outline, null, extensionManager.getPageRemovalExtensions(), pageList);
        PageExtensionUtility.modifyPages(outline, null, extensionManager.getPageModificationExtensions(), pageList);
    }

    public static void adaptPage(IOutline outline, IPageWithTable<? extends ITable> parentPage, IPage page) throws ProcessingException {
        if (outline == null) {
            throw new ProcessingException("outline must not be null");
        }
        if (parentPage == null) {
            throw new ProcessingException("parentPage must not be null");
        }
        if (page == null) {
            throw new ProcessingException("page must not be null");
        }
        PageExtensionManager extensionManager = Activator.getDefault().getPagesExtensionManager();
        PageExtensionUtility.modifyPages(outline, parentPage, extensionManager.getPageModificationExtensions(), Collections.singletonList(page));
    }

    static void contributePages(IOutline outline, IPageWithNodes parentPage, List<PageContributionExtension> extensions, Collection<IPage> pageList) throws ProcessingException {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        LinkedList<PageContributionExtension> matchingExtensions = new LinkedList<PageContributionExtension>();
        for (PageContributionExtension e : extensions) {
            if (!e.accept(outline, (IPage)parentPage, null)) continue;
            matchingExtensions.add(e);
        }
        if (matchingExtensions.isEmpty()) {
            return;
        }
        TreeMap<CompositeObject, IPage> orderedPages = new TreeMap<CompositeObject, IPage>();
        int counter = 0;
        for (IPage p : pageList) {
            orderedPages.put(new CompositeObject(new Object[]{(double)((counter + 1) * 10), counter}), p);
            ++counter;
        }
        for (PageContributionExtension e : matchingExtensions) {
            try {
                IPage p = e.createContribution(outline, parentPage);
                orderedPages.put(new CompositeObject(new Object[]{e.getOrder(), counter}), p);
                ++counter;
            }
            catch (Throwable t) {
                LOG.error("Exception while creating an instance of a contributed page", t);
            }
        }
        pageList.clear();
        pageList.addAll(orderedPages.values());
    }

    static void removePages(IOutline outline, IPage parentPage, List<PageRemoveExtension> extensions, Collection<IPage> pageList) {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        Iterator<IPage> it = pageList.iterator();
        block0: while (it.hasNext()) {
            IPage page = it.next();
            for (PageRemoveExtension removeExtension : extensions) {
                if (!removeExtension.accept(outline, parentPage, page)) continue;
                it.remove();
                continue block0;
            }
        }
    }

    static void modifyPages(IOutline outline, IPage parentPage, List<PageModificationExtension> extensions, Collection<IPage> pageList) {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        for (PageModificationExtension ext : extensions) {
            for (IPage page : pageList) {
                try {
                    if (!ext.accept(outline, parentPage, page)) continue;
                    IPageModifier<IPage> pageModifier = ext.createPageModifier();
                    pageModifier.modify(outline, parentPage, page);
                }
                catch (ProcessingException e) {
                    LOG.error("Exception while modifying page", (Throwable)e);
                }
            }
        }
    }
}

