/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.server.services.common.clientnotification.SessionFilter;
import org.eclipse.scout.rt.shared.OfflineState;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.TextsThreadLocal;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.rt.shared.services.common.context.SharedContextChangedNotification;
import org.eclipse.scout.rt.shared.services.common.context.SharedVariableMap;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;

public abstract class AbstractServerSession
implements IServerSession {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractServerSession.class);
    private Bundle m_bundle;
    private boolean m_initialized;
    private boolean m_active;
    private Locale m_locale = LocaleThreadLocal.get();
    private final HashMap<String, Object> m_attributes;
    private final Object m_attributesLock = new Object();
    private final SharedVariableMap m_sharedVariableMap;
    private boolean m_singleThreadSession;
    private ScoutTexts m_scoutTexts;
    private UserAgent m_userAgent;

    public AbstractServerSession(boolean autoInitConfig) {
        this.m_attributes = new HashMap();
        this.m_sharedVariableMap = new SharedVariableMap();
        if (autoInitConfig) {
            this.initConfig();
        }
    }

    @Deprecated
    protected boolean getConfiguredWebSession() {
        return this.getConfiguredSingleThreadSession();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredSingleThreadSession() {
        return false;
    }

    public Map<String, Object> getSharedVariableMap() {
        return Collections.unmodifiableMap(this.m_sharedVariableMap);
    }

    protected <T> T getSharedContextVariable(String name, Class<T> type) {
        Object o = this.m_sharedVariableMap.get((Object)name);
        return (T)TypeCastUtility.castValue((Object)o, type);
    }

    protected <T> void setSharedContextVariable(String name, Class<T> type, T value) {
        Object typedValue = TypeCastUtility.castValue(value, type);
        this.m_sharedVariableMap.put(name, typedValue);
    }

    private void assignUserId() {
        String userId = ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).getUserIdOfCurrentSubject();
        this.setUserIdInternal(userId);
    }

    public boolean isActive() {
        return this.m_active;
    }

    public final String getUserId() {
        return this.getSharedContextVariable("userId", String.class);
    }

    private void setUserIdInternal(String newValue) {
        this.setSharedContextVariable("userId", String.class, newValue);
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale l) {
        if (l != null) {
            this.m_locale = l;
        }
    }

    public ScoutTexts getTexts() {
        return this.m_scoutTexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(String key) {
        Object object = this.m_attributesLock;
        synchronized (object) {
            return this.m_attributes.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String key, Object value) {
        Object object = this.m_attributesLock;
        synchronized (object) {
            this.m_attributes.put(key, value);
        }
    }

    protected void initConfig() {
        this.m_singleThreadSession = this.getConfiguredSingleThreadSession();
        if (!this.isWebSession()) {
            this.m_sharedVariableMap.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (OfflineState.isOfflineDefault() == OfflineState.isOfflineInCurrentThread()) {
                        ((IClientNotificationService)SERVICES.getService(IClientNotificationService.class)).putNotification((IClientNotification)new SharedContextChangedNotification(new SharedVariableMap(AbstractServerSession.this.m_sharedVariableMap)), new SessionFilter(AbstractServerSession.this, 60000L));
                    }
                }
            });
        }
        if (this.m_initialized) {
            return;
        }
        this.m_initialized = true;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    @Override
    public final void loadSession(Bundle bundle) throws ProcessingException {
        if (this.isActive()) {
            throw new IllegalStateException("session is active");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        this.m_bundle = bundle;
        this.m_active = true;
        this.m_scoutTexts = new ScoutTexts();
        TextsThreadLocal.set((ScoutTexts)this.m_scoutTexts);
        this.assignUserId();
        this.execLoadSession();
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execLoadSession() throws ProcessingException {
    }

    @Deprecated
    protected void execLocaleChanged() throws ProcessingException {
    }

    @Deprecated
    public boolean isWebSession() {
        return this.isSingleThreadSession();
    }

    public boolean isSingleThreadSession() {
        return this.m_singleThreadSession;
    }

    public UserAgent getUserAgent() {
        return this.m_userAgent;
    }

    public void setUserAgent(UserAgent userAgent) {
        this.m_userAgent = userAgent;
    }
}

