/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.scheduler;

import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.scheduler.IScheduler;
import org.eclipse.scout.rt.server.scheduler.ISchedulerJob;
import org.eclipse.scout.rt.server.scheduler.TickSignal;

public abstract class AbstractSchedulerJob
implements ISchedulerJob {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSchedulerJob.class);
    private final String m_groupId;
    private final String m_jobId;
    private volatile boolean m_disposed;
    private volatile boolean m_interrupted;

    public AbstractSchedulerJob(String groupId, String jobId) {
        this.m_groupId = groupId;
        this.m_jobId = jobId;
    }

    @Override
    public String getGroupId() {
        return this.m_groupId;
    }

    @Override
    public String getJobId() {
        return this.m_jobId;
    }

    @Override
    public boolean acceptTick(TickSignal signal) {
        int secondOfDay;
        int dayOfYear;
        int dayOfMonthReverse;
        int dayOfWeek;
        int year;
        int month;
        int week;
        int day;
        int hour;
        int minute;
        int second;
        boolean accepted;
        if (LOG.isDebugEnabled()) {
            LOG.debug("task " + this.getJobId() + " at " + signal);
        }
        if ((accepted = this.execAcceptTick(signal, second = signal.getSecond(), minute = signal.getMinute(), hour = signal.getHour(), day = signal.getDay(), week = signal.getWeek(), month = signal.getMonth(), year = signal.getYear(), dayOfWeek = signal.getDayOfWeek(), dayOfMonthReverse = signal.getDayOfMonthReverse(), dayOfYear = signal.getDayOfYear(), secondOfDay = signal.getSecondOfDay())) && LOG.isInfoEnabled()) {
            LOG.info("accepted task " + this.getJobId() + " triggered at " + signal);
        }
        return accepted;
    }

    @Override
    @ConfigOperation
    @Order(value=20.0)
    public void run(IScheduler scheduler, TickSignal signal) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=10.0)
    protected boolean execAcceptTick(TickSignal signal, int second, int minute, int hour, int day, int week, int month, int year, int dayOfWeek, int dayOfMonthReverse, int dayOfYear, int secondOfDay) {
        return false;
    }

    @Override
    public boolean isInterrupted() {
        return this.m_interrupted;
    }

    @Override
    public void setInterrupted(boolean b) {
        this.m_interrupted = b;
    }

    @Override
    public boolean isDisposed() {
        return this.m_disposed;
    }

    @Override
    public void setDisposed(boolean b) {
        this.m_disposed = b;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.m_groupId + "." + this.m_jobId + "]";
    }
}

