/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clientnotification;

import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationFilter;

public class SessionFilter
implements IClientNotificationFilter {
    private static final long serialVersionUID = 1L;
    private transient WeakReference<IServerSession> m_sessionRef;
    private long m_validUntil;

    public SessionFilter(IServerSession session, long timeout) {
        this.m_sessionRef = new WeakReference<IServerSession>(session);
        this.m_validUntil = System.currentTimeMillis() + timeout;
    }

    @Override
    public boolean isActive() {
        return this.m_sessionRef != null && this.m_sessionRef.get() != null && System.currentTimeMillis() <= this.m_validUntil;
    }

    @Override
    public boolean isMulticast() {
        return false;
    }

    @Override
    public boolean accept() {
        return this.m_sessionRef != null && ThreadContext.getServerSession() == this.m_sessionRef.get();
    }

    public int hashCode() {
        IServerSession session = (IServerSession)this.m_sessionRef.get();
        return session != null ? session.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            SessionFilter o = (SessionFilter)obj;
            return o.m_sessionRef.get() == this.m_sessionRef.get();
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.getClass().getSimpleName());
        b.append("[");
        if (this.m_sessionRef != null) {
            b.append(this.m_sessionRef.get());
        }
        b.append(", validUntil=" + new SimpleDateFormat("HH:mm:ss.SSS").format(new Date(this.m_validUntil)));
        b.append("]");
        return b.toString();
    }
}

