/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.code;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleClassDescriptor;
import org.eclipse.scout.commons.runtime.BundleBrowser;
import org.eclipse.scout.rt.server.internal.Activator;
import org.eclipse.scout.rt.server.services.common.code.CodeTypeCache;
import org.eclipse.scout.rt.server.services.common.code.CodeTypeStore;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeService;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.servicetunnel.RemoteServiceAccessDenied;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.Bundle;

@Priority(value=-1.0f)
public class CodeService
extends AbstractService
implements ICodeService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CodeService.class);
    private CodeTypeStore m_codeTypeStore = new CodeTypeStore();
    private Object m_codeTypeClassDescriptorMapLock = new Object();
    private HashMap<String, BundleClassDescriptor[]> m_codeTypeClassDescriptorMap = new HashMap();

    public <T extends ICodeType> T getCodeType(Class<T> type) {
        return this.getCodeTypeCache().getCodeType(type);
    }

    public <T extends ICodeType> T getCodeType(Long partitionId, Class<T> type) {
        return this.getCodeTypeCache(partitionId).getCodeType(type);
    }

    public ICodeType findCodeTypeById(Object id) {
        if (id == null) {
            return null;
        }
        ICodeType ct = this.getCodeTypeCache().findCodeTypeById(id);
        if (ct != null) {
            return ct;
        }
        this.getAllCodeTypes("");
        return this.getCodeTypeCache().findCodeTypeById(id);
    }

    public ICodeType findCodeTypeById(Long partitionId, Object id) {
        if (id == null) {
            return null;
        }
        ICodeType ct = this.getCodeTypeCache(partitionId).findCodeTypeById(id);
        if (ct != null) {
            return ct;
        }
        this.getAllCodeTypes("");
        return this.getCodeTypeCache(partitionId).findCodeTypeById(id);
    }

    public ICodeType[] getCodeTypes(Class ... types) {
        return this.getCodeTypeCache().getCodeTypes(types);
    }

    public ICodeType[] getCodeTypes(Long partitionId, Class ... types) {
        return this.getCodeTypeCache(partitionId).getCodeTypes(types);
    }

    public <T extends ICode> T getCode(Class<T> type) {
        return this.getCodeTypeCache().getCode(type);
    }

    public <T extends ICode> T getCode(Long partitionId, Class<T> type) {
        return this.getCodeTypeCache(partitionId).getCode(type);
    }

    public <T extends ICodeType> T reloadCodeType(Class<T> type) {
        if (type == null) {
            return null;
        }
        this.m_codeTypeStore.unloadCodeTypeCache(type);
        return this.getCodeTypeCache().reloadCodeType(type);
    }

    public ICodeType[] reloadCodeTypes(Class ... types) {
        if (types == null) {
            return null;
        }
        this.m_codeTypeStore.unloadCodeTypeCache(types);
        return this.getCodeTypeCache().reloadCodeTypes(types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleClassDescriptor[] getAllCodeTypeClasses(String classPrefix) {
        if (classPrefix == null) {
            return new BundleClassDescriptor[0];
        }
        Object object = this.m_codeTypeClassDescriptorMapLock;
        synchronized (object) {
            BundleClassDescriptor[] a = this.m_codeTypeClassDescriptorMap.get(classPrefix);
            if (a != null) {
                return a;
            }
            HashSet<BundleClassDescriptor> discoveredCodeTypes = new HashSet<BundleClassDescriptor>();
            Bundle[] bundleArray = Activator.getDefault().getBundle().getBundleContext().getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                block14: {
                    Bundle bundle = bundleArray[n2];
                    if ((bundle.getSymbolicName().startsWith(classPrefix) || classPrefix.startsWith(String.valueOf(bundle.getSymbolicName()) + ".")) && this.acceptBundle(bundle, classPrefix)) {
                        String[] classNames;
                        try {
                            BundleBrowser bundleBrowser = new BundleBrowser(bundle.getSymbolicName(), bundle.getSymbolicName());
                            classNames = bundleBrowser.getClasses(false, true);
                        }
                        catch (Exception e1) {
                            LOG.warn(null, (Throwable)e1);
                            break block14;
                        }
                        String[] stringArray = classNames;
                        int n3 = classNames.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String className = stringArray[n4];
                            if (this.acceptClassName(bundle, className)) {
                                try {
                                    Class c = null;
                                    c = bundle.loadClass(className);
                                    if (this.acceptClass(bundle, c)) {
                                        discoveredCodeTypes.add(new BundleClassDescriptor(bundle.getSymbolicName(), c.getName()));
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            a = discoveredCodeTypes.toArray(new BundleClassDescriptor[discoveredCodeTypes.size()]);
            this.m_codeTypeClassDescriptorMap.put(classPrefix, a);
            return a;
        }
    }

    @RemoteServiceAccessDenied
    public ICodeType[] getAllCodeTypes(String classPrefix) {
        ArrayList<Class> list = new ArrayList<Class>();
        BundleClassDescriptor[] bundleClassDescriptorArray = this.getAllCodeTypeClasses(classPrefix);
        int n = bundleClassDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleClassDescriptor d = bundleClassDescriptorArray[n2];
            try {
                list.add(Platform.getBundle((String)d.getBundleSymbolicName()).loadClass(d.getClassName()));
            }
            catch (Throwable t) {
                LOG.warn("Loading " + d.getClassName() + " of bundle " + d.getBundleSymbolicName(), t);
            }
            ++n2;
        }
        return this.getCodeTypes(list.toArray(new Class[list.size()]));
    }

    @RemoteServiceAccessDenied
    public ICodeType[] getAllCodeTypes(String classPrefix, Long partitionId) {
        return this.getAllCodeTypes(classPrefix);
    }

    private CodeTypeCache getCodeTypeCache() {
        return this.m_codeTypeStore.getCodeTypeCache(LocaleThreadLocal.get());
    }

    private CodeTypeCache getCodeTypeCache(Long partitionId) {
        return this.m_codeTypeStore.getCodeTypeCache(partitionId, LocaleThreadLocal.get());
    }

    protected boolean acceptBundle(Bundle bundle, String classPrefix) {
        return !Platform.isFragment((Bundle)bundle);
    }

    protected boolean acceptClassName(Bundle bundle, String className) {
        return className.indexOf("CodeType") >= 0;
    }

    protected boolean acceptClass(Bundle bundle, Class<?> c) {
        int flags;
        return ICodeType.class.isAssignableFrom(c) && !c.isInterface() && Modifier.isPublic(flags = c.getModifiers()) && !Modifier.isAbstract(flags) && !c.getSimpleName().startsWith("Abstract");
    }
}

