/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.code;

import java.util.HashMap;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class CodeTypeCache {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CodeTypeCache.class);
    private Object m_cacheLock = new Object();
    private HashMap<Class<? extends ICodeType>, ICodeType> m_cache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeType findCodeTypeById(Object id) {
        if (id == null) {
            return null;
        }
        Object object = this.m_cacheLock;
        synchronized (object) {
            for (ICodeType ct : this.m_cache.values()) {
                if (!id.equals(ct.getId())) continue;
                return ct;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType> T getCodeType(Class<T> type) {
        Object object = this.m_cacheLock;
        synchronized (object) {
            ICodeType instance = this.m_cache.get(type);
            if (instance == null) {
                try {
                    instance = (ICodeType)type.newInstance();
                    this.m_cache.put(type, instance);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("create " + type.getName(), t));
                }
            }
            return (T)instance;
        }
    }

    public ICodeType[] getCodeTypes(Class ... types) {
        ICodeType[] instances = new ICodeType[types.length];
        int i = 0;
        while (i < instances.length) {
            instances[i] = this.getCodeType(types[i]);
            ++i;
        }
        return instances;
    }

    public <T extends ICode> T getCode(final Class<T> type) {
        if (type == null) {
            return null;
        }
        Class<?> declaringCodeTypeClass = null;
        if (type.getDeclaringClass() != null) {
            Class<?> c = type.getDeclaringClass();
            while (c != null && !ICodeType.class.isAssignableFrom(c)) {
                c = c.getDeclaringClass();
            }
            declaringCodeTypeClass = c;
        }
        if (declaringCodeTypeClass == null) {
            try {
                declaringCodeTypeClass = ((ICode)type.newInstance()).getCodeType().getClass();
            }
            catch (Throwable t) {
                LOG.error("find code " + type, t);
            }
        }
        T codeType = this.getCodeType(declaringCodeTypeClass);
        final Holder codeHolder = new Holder(ICode.class);
        ICodeVisitor v = new ICodeVisitor(){

            public boolean visit(ICode code, int treeLevel) {
                if (code.getClass() == type) {
                    codeHolder.setValue((Object)code);
                    return false;
                }
                return true;
            }
        };
        codeType.visit(v);
        return (T)((ICode)codeHolder.getValue());
    }

    public <T extends ICodeType> T reloadCodeType(Class<T> type) {
        this.unloadCodeTypes(new Class[]{type});
        return this.getCodeType(type);
    }

    public ICodeType[] reloadCodeTypes(Class ... types) {
        this.unloadCodeTypes(types);
        return this.getCodeTypes(types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unloadCodeTypes(Class[] types) {
        Object object = this.m_cacheLock;
        synchronized (object) {
            int i = 0;
            while (i < types.length) {
                this.m_cache.remove(types[i]);
                ++i;
            }
        }
    }
}

