/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc;

import java.lang.reflect.Method;
import java.security.Permission;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.BundleContextUtility;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.LongHolder;
import org.eclipse.scout.commons.holders.StringHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleClassDescriptor;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.services.common.jdbc.AbstractSqlTransactionMember;
import org.eclipse.scout.rt.server.services.common.jdbc.ISelectStreamHandler;
import org.eclipse.scout.rt.server.services.common.jdbc.ISqlService;
import org.eclipse.scout.rt.server.services.common.jdbc.IStatementCache;
import org.eclipse.scout.rt.server.services.common.jdbc.IStatementProcessor;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.PreparedStatementCache;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.StatementProcessor;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.legacy.LegacyStatementBuilder;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.pool.SqlConnectionBuilder;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.pool.SqlConnectionPool;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle2;
import org.eclipse.scout.rt.server.services.common.jdbc.style.OracleSqlStyle;
import org.eclipse.scout.rt.server.transaction.ITransaction;
import org.eclipse.scout.rt.server.transaction.ITransactionMember;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.code.ICodeService;
import org.eclipse.scout.rt.shared.services.common.jdbc.ILegacySqlQueryService;
import org.eclipse.scout.rt.shared.services.common.jdbc.LegacySearchFilter;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.rt.shared.services.common.security.IPermissionService;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.IServiceInventory;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractSqlService
extends AbstractService
implements ISqlService,
ILegacySqlQueryService,
IAdaptable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSqlService.class);
    public static final int DEFAULT_MEMORY_PREFETCH_SIZE = 0x100000;
    private SqlConnectionPool m_pool;
    private Class<? extends ScoutTexts> m_nlsProvider;
    private ISqlStyle m_sqlStyle;
    private String m_transactionMemberId;
    private boolean m_directJdbcConnection;
    private String m_jndiName;
    private String m_jndiInitialContextFactory;
    private String m_jndiProviderUrl;
    private String m_jndiUrlPkgPrefixes;
    private String m_jdbcMappingName;
    private String m_jdbcDriverName;
    private String m_jdbcProps;
    private int m_jdbcPoolSize;
    private long m_jdbcPoolConnectionLifetime;
    private long m_jdbcPoolConnectionBusyTimeout;
    private String m_defaultUser;
    private String m_defaultPass;
    private int m_queryCacheSize;
    private int m_maxFetchMemorySize = 0x100000;
    private HashMap<String, List<BundleClassDescriptor>> m_permissionNameToDescriptor;
    private HashMap<String, List<BundleClassDescriptor>> m_codeNameToDescriptor;

    public AbstractSqlService() {
        this.initConfig();
    }

    public void initializeService() {
        int n;
        super.initializeService();
        this.m_permissionNameToDescriptor = new HashMap();
        IPermissionService psvc = (IPermissionService)SERVICES.getService(IPermissionService.class);
        if (psvc != null) {
            BundleClassDescriptor[] bundleClassDescriptorArray = psvc.getAllPermissionClasses();
            n = bundleClassDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleClassDescriptor d = bundleClassDescriptorArray[n2];
                List<BundleClassDescriptor> list = this.m_permissionNameToDescriptor.get(d.getSimpleClassName());
                if (list == null) {
                    list = new ArrayList<BundleClassDescriptor>();
                    this.m_permissionNameToDescriptor.put(d.getSimpleClassName(), list);
                }
                list.add(d);
                list = this.m_permissionNameToDescriptor.get(d.getClassName());
                if (list == null) {
                    list = new ArrayList<BundleClassDescriptor>();
                    this.m_permissionNameToDescriptor.put(d.getClassName(), list);
                }
                list.add(d);
                ++n2;
            }
        }
        this.m_codeNameToDescriptor = new HashMap();
        ICodeService csvc = (ICodeService)SERVICES.getService(ICodeService.class);
        if (csvc != null) {
            BundleClassDescriptor[] bundleClassDescriptorArray = csvc.getAllCodeTypeClasses("");
            int n3 = bundleClassDescriptorArray.length;
            n = 0;
            while (n < n3) {
                BundleClassDescriptor d = bundleClassDescriptorArray[n];
                List<BundleClassDescriptor> list = this.m_codeNameToDescriptor.get(d.getSimpleClassName());
                if (list == null) {
                    list = new ArrayList<BundleClassDescriptor>();
                    this.m_codeNameToDescriptor.put(d.getSimpleClassName(), list);
                }
                list.add(d);
                list = this.m_codeNameToDescriptor.get(d.getClassName());
                if (list == null) {
                    list = new ArrayList<BundleClassDescriptor>();
                    this.m_codeNameToDescriptor.put(d.getClassName(), list);
                }
                list.add(d);
                ++n;
            }
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredDirectJdbcConnection() {
        return true;
    }

    @ConfigProperty(value="STRING")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredUsername() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=30.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredPassword() {
        return null;
    }

    @ConfigProperty(value="NLS_PROVIDER")
    @Order(value=70.0)
    @ConfigPropertyValue(value="null")
    protected Class<? extends ScoutTexts> getConfiguredNlsProvider() {
        return null;
    }

    @ConfigProperty(value="SQL_STYLE")
    @Order(value=80.0)
    @ConfigPropertyValue(value="null")
    protected Class<? extends ISqlStyle> getConfiguredSqlStyle() {
        return null;
    }

    @Deprecated
    protected String getConfiguredXAResourceId() {
        return this.getConfiguredTransactionMemberId();
    }

    @ConfigProperty(value="STRING")
    @Order(value=90.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTransactionMemberId() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=100.0)
    @ConfigPropertyValue(value="\"oracle.jdbc.OracleDriver\"")
    protected String getConfiguredJdbcDriverName() {
        return "oracle.jdbc.OracleDriver";
    }

    @ConfigProperty(value="STRING")
    @Order(value=110.0)
    @ConfigPropertyValue(value="\"jdbc:oracle:thin:@localhost:1521:ORCL\"")
    protected String getConfiguredJdbcMappingName() {
        return "jdbc:oracle:thin:@localhost:1521:ORCL";
    }

    @ConfigProperty(value="STRING")
    @Order(value=120.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredJdbcProperties() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=130.0)
    @ConfigPropertyValue(value="25")
    protected int getConfiguredJdbcPoolSize() {
        return 25;
    }

    @ConfigProperty(value="LONG")
    @Order(value=140.0)
    @ConfigPropertyValue(value="300000L")
    protected long getConfiguredJdbcPoolConnectionLifetime() {
        return 300000L;
    }

    @ConfigProperty(value="LONG")
    @Order(value=150.0)
    @ConfigPropertyValue(value="21600000L")
    protected long getConfiguredJdbcPoolConnectionBusyTimeout() {
        return 21600000L;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=160.0)
    @ConfigPropertyValue(value="25")
    protected int getConfiguredJdbcStatementCacheSize() {
        return 25;
    }

    @ConfigProperty(value="STRING")
    @Order(value=170.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredJndiName() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=180.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredJndiInitialContextFactory() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=190.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredJndiProviderUrl() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=200.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredJndiUrlPkgPrefixes() {
        return null;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execTestConnection(Connection conn) throws Throwable {
        ISqlStyle s = this.getSqlStyle();
        if (s != null) {
            s.testConnection(conn);
        }
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execAfterConnectionCreated(Connection conn) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execBeginTransaction() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected Connection execCreateConnection() throws Throwable {
        return this.leaseConnectionInternal();
    }

    @ConfigOperation
    @Order(value=35.0)
    protected void execReleaseConnection(Connection conn) throws Throwable {
        this.releaseConnectionInternal(conn);
    }

    @ConfigOperation
    @Order(value=40.0)
    protected Object execCustomBindFunction(String functionName, String[] args, Object[] bindBases) throws ProcessingException {
        if (functionName.equals("level")) {
            IAccessControlService accessControlService;
            Class permissionClass;
            Object ret;
            if (args.length != 1) {
                throw new IllegalArgumentException("expected 1 argument for function '" + functionName + "'");
            }
            String permissionClassName = args[0];
            String levelField = null;
            int levelDot = permissionClassName.indexOf(".LEVEL_");
            if (levelDot >= 0) {
                levelField = permissionClassName.substring(levelDot + 1);
                permissionClassName = permissionClassName.substring(0, levelDot);
            }
            return (ret = this.tryGetPermissionLevel(permissionClass = this.loadBundleClassLenient(this.m_permissionNameToDescriptor, permissionClassName), levelField, accessControlService = (IAccessControlService)SERVICES.getService(IAccessControlService.class))) != null ? ret : new LongHolder();
        }
        if (functionName.equals("code")) {
            if (args.length != 1) {
                throw new IllegalArgumentException("expected 1 argument for function '" + functionName + "'");
            }
            String codeClassName = args[0];
            Class codeClass = this.loadBundleClassLenient(this.m_codeNameToDescriptor, codeClassName);
            if (codeClass == null) {
                throw new ProcessingException("cannot find class for code '" + args[0] + "'");
            }
            try {
                Object ret = codeClass.getField("ID").get(null);
                return ret != null ? ret : new LongHolder();
            }
            catch (Throwable t) {
                throw new ProcessingException("ID of code '" + args[0] + "'", t);
            }
        }
        if (functionName.equals("text")) {
            if (args.length < 1) {
                throw new IllegalArgumentException("expected at least 1 argument for function '" + functionName + "'");
            }
            if (args.length == 1) {
                String[] tmp = new String[]{args[0], null};
                args = tmp;
            }
            try {
                Method m = this.getNlsProvider().getMethod("get", String.class, String[].class);
                Object ret = m.invoke(null, (Object[])args);
                return ret != null ? ret : new StringHolder();
            }
            catch (Throwable t) {
                throw new ProcessingException("unknown function in DynamicNls, check 'getConfiguredNlsProvider' / 'getNlsProvider': get", t);
            }
        }
        throw new IllegalArgumentException("undefined function '" + functionName + "'");
    }

    private Object tryGetPermissionLevel(Class permissionClass, String levelField, IAccessControlService accessControlService) throws ProcessingException {
        if (permissionClass == null) {
            return null;
        }
        try {
            if (levelField != null) {
                return permissionClass.getField(levelField).get(null);
            }
            Permission p = (Permission)permissionClass.newInstance();
            return accessControlService.getPermissionLevel(p);
        }
        catch (Exception e) {
            throw new ProcessingException("getLevel of permission '" + permissionClass + "'", (Throwable)e);
        }
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execEndTransaction(boolean willBeCommitted) throws ProcessingException {
    }

    protected void initConfig() {
        String tid = this.getConfiguredTransactionMemberId();
        if (tid == null) {
            tid = String.valueOf(this.getClass().getSimpleName()) + "." + "transaction";
        }
        this.setTransactionMemberId(tid);
        this.setDirectJdbcConnection(this.getConfiguredDirectJdbcConnection());
        this.setUsername(this.getConfiguredUsername());
        this.setPassword(this.getConfiguredPassword());
        this.setJndiName(this.getConfiguredJndiName());
        this.setJndiInitialContextFactory(this.getConfiguredJndiInitialContextFactory());
        this.setJndiProviderUrl(this.getConfiguredJndiProviderUrl());
        this.setJndiUrlPkgPrefixes(this.getConfiguredJndiUrlPkgPrefixes());
        this.setJdbcMappingName(this.getConfiguredJdbcMappingName());
        this.setJdbcDriverName(this.getConfiguredJdbcDriverName());
        this.setJdbcProperties(this.getConfiguredJdbcProperties());
        this.setJdbcStatementCacheSize(this.getConfiguredJdbcStatementCacheSize());
        this.setJdbcPoolSize(this.getConfiguredJdbcPoolSize());
        this.setJdbcPoolConnectionBusyTimeout(this.getConfiguredJdbcPoolConnectionBusyTimeout());
        this.setJdbcPoolConnectionLifetime(this.getConfiguredJdbcPoolConnectionLifetime());
        this.setNlsProvider(this.getConfiguredNlsProvider());
        Class<? extends ISqlStyle> styleClass = this.getConfiguredSqlStyle();
        if (styleClass != null) {
            try {
                this.setSqlStyle(styleClass.newInstance());
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        } else {
            this.setSqlStyle(new OracleSqlStyle());
        }
    }

    public void callbackAfterConnectionCreated(Connection conn) throws ProcessingException {
        this.execAfterConnectionCreated(conn);
    }

    public void callbackTestConnection(Connection conn) throws Throwable {
        this.execTestConnection(conn);
    }

    public Object callbackCustomBindFunction(String functionName, String[] args, Object[] bindBases) throws ProcessingException {
        return this.execCustomBindFunction(functionName, args, bindBases);
    }

    @Override
    public String getTransactionMemberId() {
        return this.m_transactionMemberId;
    }

    public boolean isDirectJdbcConnection() {
        return this.m_directJdbcConnection;
    }

    public int getJdbcStatementCacheSize() {
        return this.m_queryCacheSize;
    }

    public String getJndiName() {
        return this.m_jndiName;
    }

    public String getJndiInitialContextFactory() {
        return this.m_jndiInitialContextFactory;
    }

    public String getJndiProviderUrl() {
        return this.m_jndiProviderUrl;
    }

    public String getJndiUrlPkgPrefixes() {
        return this.m_jndiUrlPkgPrefixes;
    }

    public String getJdbcMappingName() {
        return this.m_jdbcMappingName;
    }

    public String getJdbcDriverName() {
        return this.m_jdbcDriverName;
    }

    public String getJdbcProperties() {
        return this.m_jdbcProps;
    }

    public String getUsername() {
        return this.m_defaultUser;
    }

    public String getPassword() {
        return this.m_defaultPass;
    }

    public int getJdbcPoolSize() {
        return this.m_jdbcPoolSize;
    }

    public long getJdbcPoolConnectionLifetime() {
        return this.m_jdbcPoolConnectionLifetime;
    }

    public long getJdbcPoolConnectionBusyTimeout() {
        return this.m_jdbcPoolConnectionBusyTimeout;
    }

    public int getMaxFetchMemorySize() {
        return this.m_maxFetchMemorySize;
    }

    public void setTransactionMemberId(String s) {
        this.m_transactionMemberId = s;
    }

    public void setDirectJdbcConnection(boolean b) {
        this.m_directJdbcConnection = b;
    }

    public void setJdbcStatementCacheSize(int n) {
        this.m_queryCacheSize = n;
    }

    public void setJndiName(String s) {
        this.m_jndiName = s;
    }

    public void setJndiInitialContextFactory(String s) {
        this.m_jndiInitialContextFactory = s;
    }

    public void setJndiProviderUrl(String s) {
        this.m_jndiProviderUrl = s;
    }

    public void setJndiUrlPkgPrefixes(String s) {
        this.m_jndiUrlPkgPrefixes = s;
    }

    public void setJdbcMappingName(String s) {
        this.m_jdbcMappingName = BundleContextUtility.resolve((String)s);
    }

    public void setJdbcDriverName(String s) {
        this.m_jdbcDriverName = s;
    }

    public void setJdbcProperties(String s) {
        this.m_jdbcProps = s;
    }

    public void setUsername(String s) {
        this.m_defaultUser = s;
    }

    public void setPassword(String s) {
        this.m_defaultPass = s;
    }

    public void setJdbcPoolSize(int n) {
        this.m_jdbcPoolSize = n;
    }

    public void setJdbcPoolConnectionLifetime(long t) {
        this.m_jdbcPoolConnectionLifetime = t;
    }

    public void setJdbcPoolConnectionBusyTimeout(long t) {
        this.m_jdbcPoolConnectionBusyTimeout = t;
    }

    public void setMaxFetchMemorySize(int maxFetchMemorySize) {
        this.m_maxFetchMemorySize = maxFetchMemorySize;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IServiceInventory.class && this.m_pool != null) {
            return this.m_pool.getInventory();
        }
        return null;
    }

    public Class<? extends ScoutTexts> getNlsProvider() {
        return this.m_nlsProvider;
    }

    public void setNlsProvider(Class<? extends ScoutTexts> nlsProvider) {
        this.m_nlsProvider = nlsProvider;
    }

    @Override
    public ISqlStyle getSqlStyle() {
        return this.m_sqlStyle;
    }

    public void setSqlStyle(ISqlStyle sqlStyle) {
        this.m_sqlStyle = sqlStyle;
    }

    private Connection leaseConnection() throws Throwable {
        Connection conn = this.execCreateConnection();
        return conn;
    }

    private Connection leaseConnectionInternal() throws Throwable {
        try {
            if (this.isDirectJdbcConnection()) {
                Connection conn = this.getSqlConnectionPool().leaseConnection(this);
                return conn;
            }
            Connection conn = new SqlConnectionBuilder().createJndiConnection(this);
            return conn;
        }
        catch (Exception e) {
            ProcessingException pe = e instanceof ProcessingException ? (ProcessingException)((Object)e) : new ProcessingException("unexpected exception", (Throwable)e);
            if (this.isDirectJdbcConnection()) {
                pe.addContextMessage("jdbcDriverName=" + this.getJdbcDriverName() + ", jdbcMappingName=" + this.getJdbcMappingName());
            } else {
                pe.addContextMessage("jndiName=" + this.getJndiName());
            }
            throw pe;
        }
    }

    private void releaseConnection(Connection conn) {
        try {
            this.execReleaseConnection(conn);
        }
        catch (Throwable e) {
            LOG.error(null, e);
        }
    }

    private void releaseConnectionInternal(Connection conn) throws Throwable {
        if (this.isDirectJdbcConnection()) {
            this.getSqlConnectionPool().releaseConnection(conn);
        } else {
            conn.close();
        }
    }

    private synchronized SqlConnectionPool getSqlConnectionPool() {
        if (this.m_pool == null) {
            this.m_pool = SqlConnectionPool.getPool(this.getClass(), this.getJdbcPoolSize(), this.getJdbcPoolConnectionLifetime(), this.getJdbcPoolConnectionBusyTimeout());
        }
        return this.m_pool;
    }

    @Override
    public Connection getConnection() throws ProcessingException {
        return this.getTransaction();
    }

    protected Connection getTransaction() throws ProcessingException {
        ITransaction reg = ThreadContext.getTransaction();
        if (reg == null) {
            throw new ProcessingException("no ITransaction available, use ServerJob to run truncactions");
        }
        SqlTransactionMember member = (SqlTransactionMember)reg.getMember(this.getTransactionMemberId());
        if (member == null) {
            try {
                Connection conn = this.leaseConnection();
                member = new SqlTransactionMember(this.getTransactionMemberId(), conn);
                reg.registerMember(member);
                this.execBeginTransaction();
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ProcessingException("getTransaction", e);
            }
        }
        return member.getConnection();
    }

    protected final IStatementCache getStatementCache() throws ProcessingException {
        ITransaction reg = ThreadContext.getTransaction();
        if (reg == null) {
            throw new ProcessingException("no ITransaction available, use ServerJob to run truncactions");
        }
        IStatementCache res = (IStatementCache)((Object)reg.getMember("PreparedStatementCache"));
        if (res == null) {
            res = new PreparedStatementCache(this.getJdbcStatementCacheSize());
            reg.registerMember((ITransactionMember)((Object)res));
        }
        return res;
    }

    @Override
    public Object[][] select(String s, Object ... bindBases) throws ProcessingException {
        return this.createStatementProcessor(s, bindBases, 0).processSelect(this.getTransaction(), this.getStatementCache(), null);
    }

    @Override
    public Object[][] selectLimited(String s, int maxRowCount, Object ... bindBases) throws ProcessingException {
        return this.createStatementProcessor(s, bindBases, maxRowCount).processSelect(this.getTransaction(), this.getStatementCache(), null);
    }

    @Override
    public void selectInto(String s, Object ... bindBases) throws ProcessingException {
        this.createStatementProcessor(s, bindBases, 0).processSelectInto(this.getTransaction(), this.getStatementCache(), null);
    }

    @Override
    public void selectIntoLimited(String s, int maxRowCount, Object ... bindBases) throws ProcessingException {
        this.createStatementProcessor(s, bindBases, maxRowCount).processSelectInto(this.getTransaction(), this.getStatementCache(), null);
    }

    @Override
    public void selectStreaming(String s, ISelectStreamHandler handler, Object ... bindBases) throws ProcessingException {
        this.createStatementProcessor(s, bindBases, 0).processSelectStreaming(this.getTransaction(), this.getStatementCache(), handler);
    }

    @Override
    public void selectStreamingLimited(String s, ISelectStreamHandler handler, int maxRowCount, Object ... bindBases) throws ProcessingException {
        this.createStatementProcessor(s, bindBases, maxRowCount).processSelectStreaming(this.getTransaction(), this.getStatementCache(), handler);
    }

    @Override
    public int insert(String s, Object ... bindBases) throws ProcessingException {
        return this.createStatementProcessor(s, bindBases, 0).processModification(this.getTransaction(), this.getStatementCache(), null);
    }

    @Override
    public int update(String s, Object ... bindBases) throws ProcessingException {
        return this.createStatementProcessor(s, bindBases, 0).processModification(this.getTransaction(), this.getStatementCache(), null);
    }

    @Override
    public int delete(String s, Object ... bindBases) throws ProcessingException {
        return this.createStatementProcessor(s, bindBases, 0).processModification(this.getTransaction(), this.getStatementCache(), null);
    }

    @Override
    public boolean callStoredProcedure(String s, Object ... bindBases) throws ProcessingException {
        return this.createStatementProcessor(s, bindBases, 0).processStoredProcedure(this.getTransaction(), this.getStatementCache(), null);
    }

    @Override
    public void commit() throws ProcessingException {
        try {
            this.getTransaction().commit();
            ISqlStyle style = this.getSqlStyle();
            if (style instanceof ISqlStyle2) {
                ((ISqlStyle2)style).commit();
            }
        }
        catch (SQLException e) {
            throw new ProcessingException("unexpected exception", (Throwable)e);
        }
    }

    @Override
    public String createPlainText(String s, Object ... bindBases) throws ProcessingException {
        return this.createStatementProcessor(s, bindBases, 0).createPlainText();
    }

    public LegacySearchFilter.WhereToken resolveSpecialConstraint(Object specialConstraint) throws ProcessingException {
        if (specialConstraint instanceof LegacySearchFilter.StringLikeConstraint) {
            LegacySearchFilter.StringLikeConstraint c = (LegacySearchFilter.StringLikeConstraint)specialConstraint;
            String s = this.getSqlStyle().toLikePattern(c.getValue());
            return new LegacySearchFilter.WhereToken(c.getTerm(), (Object)s, null);
        }
        if (specialConstraint instanceof LegacySearchFilter.ComposerConstraint) {
            LegacySearchFilter.ComposerConstraint c = (LegacySearchFilter.ComposerConstraint)specialConstraint;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String term = c.getTerm();
            for (Map.Entry e : c.getAttributeRefMap().entrySet()) {
                String key = (String)e.getKey();
                LegacySearchFilter.ComposerAttributeRef att = (LegacySearchFilter.ComposerAttributeRef)e.getValue();
                LegacyStatementBuilder b = new LegacyStatementBuilder(this.getSqlStyle());
                String attValue = b.resolveComposerAttribute(att.getOp(), att.getAttribute(), att.getBindName(), att.getValue());
                map.putAll(b.getBindMap());
                term = term.replace(key, attValue);
            }
            return new LegacySearchFilter.WhereToken(term, null, map);
        }
        return null;
    }

    protected IStatementProcessor createStatementProcessor(String s, Object[] bindBases, int maxRowCount) throws ProcessingException {
        return new StatementProcessor(this, s, bindBases, maxRowCount, this.m_maxFetchMemorySize);
    }

    @Override
    public void rollback() throws ProcessingException {
        try {
            this.getTransaction().rollback();
            ISqlStyle style = this.getSqlStyle();
            if (style instanceof ISqlStyle2) {
                ((ISqlStyle2)style).rollback();
            }
        }
        catch (SQLException e) {
            throw new ProcessingException("unexpected exception", (Throwable)e);
        }
    }

    @Override
    public Long getSequenceNextval(String sequenceName) throws ProcessingException {
        String s = "SELECT " + sequenceName + ".NEXTVAL FROM DUAL ";
        Object[][] ret = this.createStatementProcessor(s, null, 0).processSelect(this.getTransaction(), this.getStatementCache(), null);
        if (ret.length == 1) {
            return NumberUtility.toLong((Number)((Number)NumberUtility.nvl((Object)((Number)ret[0][0]), (Object)0)));
        }
        return 0L;
    }

    private Class loadBundleClassLenient(Map<String, List<BundleClassDescriptor>> map, String name) {
        String base = name;
        String suffix = "";
        while (base.length() > 0) {
            String seg;
            int i;
            List<BundleClassDescriptor> list = map.get(base);
            if (list != null) {
                for (BundleClassDescriptor desc : list) {
                    try {
                        Class c = Platform.getBundle((String)desc.getBundleSymbolicName()).loadClass(desc.getClassName());
                        if (suffix.length() > 0) {
                            c = Platform.getBundle((String)desc.getBundleSymbolicName()).loadClass(String.valueOf(desc.getClassName()) + suffix.replace(".", "$"));
                            return c;
                        }
                        return c;
                    }
                    catch (Throwable t) {
                        LOG.warn("Could not load class with lenient name '" + name + "' in bundle " + desc.getBundleSymbolicName());
                    }
                }
            }
            if ((i = base.lastIndexOf(46)) >= 0) {
                seg = base.substring(i);
                base = base.substring(0, i);
                suffix = String.valueOf(seg) + suffix;
                continue;
            }
            seg = base;
            base = "";
            suffix = String.valueOf(seg) + suffix;
        }
        LOG.warn("Could not find class with lenient name '" + name + "'");
        return null;
    }

    private class SqlTransactionMember
    extends AbstractSqlTransactionMember {
        private final Connection m_conn;

        public SqlTransactionMember(String transactionMemberId, Connection conn) {
            super(transactionMemberId);
            this.m_conn = conn;
        }

        public Connection getConnection() {
            return this.m_conn;
        }

        @Override
        public void commitPhase2() {
            try {
                try {
                    this.setFinishingTransaction(true);
                    AbstractSqlService.this.execEndTransaction(false);
                }
                finally {
                    this.setFinishingTransaction(false);
                }
                this.m_conn.commit();
            }
            catch (Exception e) {
                LOG.error(null, (Throwable)e);
            }
        }

        @Override
        public void rollback() {
            block6: {
                try {
                    try {
                        this.setFinishingTransaction(true);
                        AbstractSqlService.this.execEndTransaction(false);
                    }
                    finally {
                        this.setFinishingTransaction(false);
                    }
                    this.m_conn.rollback();
                }
                catch (Exception e) {
                    if (ThreadContext.getTransaction().isCancelled()) break block6;
                    LOG.error(null, (Throwable)e);
                }
            }
        }

        @Override
        public void release() {
            AbstractSqlService.this.releaseConnection(this.m_conn);
        }
    }
}

