/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.transaction.AbstractTransactionMember;

public abstract class AbstractSqlTransactionMember
extends AbstractTransactionMember {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSqlTransactionMember.class);
    private final Object m_activeStatementsLock = new Object();
    private final HashSet<Statement> m_activeStatements = new HashSet();
    private boolean m_cancelled;
    private boolean m_finishingTransaction;

    public AbstractSqlTransactionMember(String transactionMemberId) {
        super(transactionMemberId);
    }

    @Override
    public boolean needsCommit() {
        return true;
    }

    @Override
    public boolean commitPhase1() {
        return true;
    }

    protected void setFinishingTransaction(boolean finishingTransaction) {
        this.m_finishingTransaction = finishingTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActiveStatement(Statement statement) throws SQLException {
        Object object = this.m_activeStatementsLock;
        synchronized (object) {
            if (this.m_cancelled && !this.m_finishingTransaction) {
                throw new SQLException("Transaction was cancelled");
            }
            this.m_activeStatements.add(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterActiveStatement(Statement statement) {
        Object object = this.m_activeStatementsLock;
        synchronized (object) {
            this.m_activeStatements.remove(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        HashSet<Statement> set;
        Object object = this.m_activeStatementsLock;
        synchronized (object) {
            if (this.m_cancelled) {
                return;
            }
            this.m_cancelled = true;
            set = new HashSet<Statement>(this.m_activeStatements);
            this.m_activeStatements.clear();
        }
        for (Statement s : set) {
            try {
                LOG.info("request sent to cancel jdbc statement");
                s.cancel();
            }
            catch (Throwable e) {
                LOG.error("failed to cancel jdbc statement", e);
            }
        }
    }
}

