/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.exception.ProcessingException;

public class AliasMapper {
    private static final Pattern CLEAN_ENTITY_NAME = Pattern.compile("[@]?(parent\\.)?([a-zA-Z0-9_]+)[@]?");
    private static final Pattern ENTITY_NAME = Pattern.compile("[@](parent\\.)?([a-zA-Z0-9_]+)[@]");
    private static final Pattern ENTITY_DEFINITION = Pattern.compile("[@]([a-zA-Z0-9_]+)[@]([^.])");
    private static final Pattern ENTITY_REFERENCE = Pattern.compile("[@](parent\\.)?([a-zA-Z0-9_]+)[@][.]");
    private AtomicInteger m_sequenceProvider;
    private final Map<String, String> m_rootAliases = new HashMap<String, String>();
    private final Map<Object, Map<String, String>> m_nodeAliases = new HashMap<Object, Map<String, String>>();

    public AliasMapper() {
        this.m_sequenceProvider = new AtomicInteger(0);
    }

    public void setSequenceProvider(AtomicInteger sequenceProvider) {
        this.m_sequenceProvider = sequenceProvider;
    }

    public static String cleanEntityName(String e) {
        if (e == null) {
            return e;
        }
        Matcher m = CLEAN_ENTITY_NAME.matcher(e);
        if (m.matches()) {
            return m.group(2).toUpperCase();
        }
        return e.toUpperCase();
    }

    public String nextAlias() {
        int seq = this.m_sequenceProvider.incrementAndGet();
        return "a" + ("" + (10000 + seq)).substring(1);
    }

    public Map<String, String> getRootAliases() {
        return this.m_rootAliases;
    }

    public String getRootAlias(String entityName) {
        return this.m_rootAliases.get(AliasMapper.cleanEntityName(entityName));
    }

    public void setRootAlias(String entityName, String alias) {
        this.m_rootAliases.put(AliasMapper.cleanEntityName(entityName), alias);
    }

    public Map<String, String> getNodeAliases(Object node) {
        Map<String, String> map = this.m_nodeAliases.get(node);
        if (map == null) {
            map = new HashMap<String, String>();
            this.m_nodeAliases.put(node, map);
        }
        return map;
    }

    public String getNodeAlias(Object node, String entityName) {
        Map<String, String> map = this.m_nodeAliases.get(node);
        if (map != null) {
            return map.get(AliasMapper.cleanEntityName(entityName));
        }
        return null;
    }

    public void setNodeAlias(Object node, String entityName, String alias) {
        Map<String, String> map = this.m_nodeAliases.get(node);
        if (map == null) {
            map = new HashMap<String, String>();
            this.m_nodeAliases.put(node, map);
        }
        map.put(AliasMapper.cleanEntityName(entityName), alias);
    }

    public void addAllNodeEntitiesFrom(Object node, String statementPart) {
        Matcher m = ENTITY_DEFINITION.matcher(String.valueOf(statementPart) + " ");
        while (m.find()) {
            this.setNodeAlias(node, m.group(1), this.nextAlias());
        }
    }

    public void addMissingNodeEntitiesFrom(Object node, String statementPart) {
        Matcher m = ENTITY_DEFINITION.matcher(String.valueOf(statementPart) + " ");
        while (m.find()) {
            if (this.getNodeAlias(node, m.group(1)) != null) continue;
            this.setNodeAlias(node, m.group(1), this.nextAlias());
        }
    }

    public void addMissingRootEntitiesFrom(String statementPart) {
        Matcher m = ENTITY_DEFINITION.matcher(String.valueOf(statementPart) + " ");
        while (m.find()) {
            if (this.getRootAlias(m.group(1)) != null) continue;
            this.setRootAlias(m.group(1), this.nextAlias());
        }
    }

    public String replaceMarkersByAliases(String statementPart, Map<String, String> aliasMap, Map<String, String> parentAliasMap) throws ProcessingException {
        String s = statementPart;
        Matcher m = ENTITY_NAME.matcher(s);
        while (m.find()) {
            boolean parent = m.group(1) != null && m.group(1).length() > 0;
            String name = AliasMapper.cleanEntityName(m.group(2));
            String replacement = null;
            replacement = parent ? parentAliasMap.get(name) : aliasMap.get(name);
            if (replacement == null) {
                throw new ProcessingException("missing alias '" + name + "' for entity '" + m.group() + "' in statement part: " + statementPart + "; map=" + aliasMap + " parentMap=" + parentAliasMap);
            }
            s = String.valueOf(s.substring(0, m.start())) + replacement + s.substring(m.end());
            m = ENTITY_NAME.matcher(s);
        }
        return s;
    }
}

