/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.builder;

import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.ListUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.EntityContribution;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.FormDataStatementBuilder;

public final class EntityContributionUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(EntityContributionUtility.class);
    private static final Pattern ANSI_JOIN_PATTERN = Pattern.compile("\\s*(LEFT\\s+|RIGHT\\s+)?(OUTER\\s+|INNER\\s+)?JOIN\\s+.*", 34);
    private static final Pattern CHECK_GROUP_BY_CONTAINS_SELECT_PATTERN = Pattern.compile("[^a-z0-9\"'.%$_]SELECT[^a-z0-9\"'.%$_]", 34);
    public static final int STATUS_CODE_INVALID_GROUP_BY_PART = 0x70000001;

    public static EntityContribution constraintTextToContribution(String wherePart) {
        EntityContribution contrib = new EntityContribution();
        if (wherePart != null) {
            contrib.getWhereParts().add(wherePart);
        }
        return contrib;
    }

    public static String contributionToConstraintText(EntityContribution contrib) {
        EntityContribution whereContribution = EntityContributionUtility.createConstraintsContribution(contrib);
        if (whereContribution == null) {
            return null;
        }
        if (whereContribution.getWhereParts().isEmpty()) {
            return null;
        }
        return ListUtility.format(whereContribution.getWhereParts(), (String)" AND ");
    }

    public static EntityContribution createConstraintsContribution(EntityContribution contrib) {
        if (contrib == null) {
            return null;
        }
        if (contrib.getWhereParts().isEmpty() && contrib.getHavingParts().isEmpty()) {
            return null;
        }
        if (contrib.getFromParts().isEmpty()) {
            EntityContribution result = new EntityContribution();
            result.getWhereParts().addAll(contrib.getWhereParts());
            result.getGroupByParts().addAll(contrib.getGroupByParts());
            result.getHavingParts().addAll(contrib.getHavingParts());
            return result;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" EXISTS (SELECT 1 FROM ");
        sb.append(ListUtility.format(contrib.getFromParts(), (String)", "));
        if (!contrib.getWhereParts().isEmpty()) {
            sb.append(" WHERE ");
            sb.append(ListUtility.format(contrib.getWhereParts(), (String)" AND "));
        }
        if (!contrib.getGroupByParts().isEmpty()) {
            sb.append(" GROUP BY ");
            sb.append(ListUtility.format(contrib.getGroupByParts(), (String)", "));
        }
        if (!contrib.getHavingParts().isEmpty()) {
            sb.append(" HAVING ");
            sb.append(ListUtility.format(contrib.getHavingParts(), (String)" AND "));
        }
        sb.append(")");
        return EntityContribution.create(sb.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EntityContribution mergeContributions(FormDataStatementBuilder.EntityStrategy entityStrategy, String entityPartWithTags, EntityContribution childContributions, boolean consumeChildContributions) throws ProcessingException {
        String havingPart;
        String groupByPart;
        String wherePart;
        String fromPart;
        String entityPart = entityPartWithTags;
        EntityContribution parentContrib = new EntityContribution();
        if (!consumeChildContributions) {
            parentContrib.add(childContributions);
        } else {
            String s3;
            String s2;
            if (childContributions.getSelectParts().size() > 0) {
                StringBuilder selectBuf = new StringBuilder();
                for (String selectPart : childContributions.getSelectParts()) {
                    if (selectBuf.length() > 0) {
                        selectBuf.append(", ");
                    }
                    selectBuf.append(EntityContributionUtility.autoBracketSelectPart(selectPart));
                }
                s2 = selectBuf.toString();
                if (StringUtility.getTag((String)entityPart, (String)"selectParts") == null) throw new IllegalArgumentException("missing <selectParts/> tag");
                entityPart = StringUtility.replaceTags((String)entityPart, (String)"selectParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                    public String processTag(String tagName, String tagContent) {
                        if (tagContent.length() > 0) {
                            return String.valueOf(tagContent) + ", " + s2;
                        }
                        return s2;
                    }
                });
            }
            entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"selectParts");
            TreeSet<String> fromParts = new TreeSet<String>(childContributions.getFromParts());
            if (fromParts.size() > 0) {
                StringBuilder buf = new StringBuilder();
                for (String fromPart2 : fromParts) {
                    if (!EntityContributionUtility.isAnsiJoin(fromPart2)) {
                        buf.append(",");
                    }
                    buf.append(" ");
                    buf.append(fromPart2);
                }
                s3 = buf.toString();
                if (StringUtility.getTag((String)entityPart, (String)"fromParts") == null) throw new IllegalArgumentException("missing <fromParts/> tag");
                entityPart = StringUtility.replaceTags((String)entityPart, (String)"fromParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                    public String processTag(String tagName, String tagContent) {
                        return String.valueOf(tagContent) + s3;
                    }
                });
            }
            entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"fromParts");
            if (childContributions.getWhereParts().size() > 0) {
                s2 = ListUtility.format(childContributions.getWhereParts(), (String)" AND ");
                entityPart = StringUtility.getTag((String)entityPart, (String)"whereParts") != null ? StringUtility.replaceTags((String)entityPart, (String)"whereParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                    public String processTag(String tagName, String tagContent) {
                        return String.valueOf(tagContent) + " AND " + s2;
                    }
                }) : String.valueOf(entityPart) + " AND " + s2;
            }
            if (StringUtility.getTag((String)(entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"whereParts")), (String)"groupBy") != null) {
                int selectGroupByDelta = childContributions.getSelectParts().size() - childContributions.getGroupByParts().size();
                if (selectGroupByDelta > 0 && childContributions.getGroupByParts().size() > 0 || childContributions.getHavingParts().size() > 0) {
                    entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"groupBy");
                    if (childContributions.getGroupByParts().size() > 0) {
                        for (final String s3 : childContributions.getGroupByParts()) {
                            EntityContributionUtility.checkGroupByPart(s3);
                        }
                        s3 = ListUtility.format(childContributions.getGroupByParts(), (String)", ");
                        if (StringUtility.getTag((String)entityPart, (String)"groupByParts") == null) throw new IllegalArgumentException("missing <groupByParts/> tag");
                        entityPart = StringUtility.replaceTags((String)entityPart, (String)"groupByParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                            public String processTag(String tagName, String tagContent) {
                                if (tagContent.length() > 0) {
                                    return String.valueOf(tagContent) + ", " + s3;
                                }
                                return s3;
                            }
                        });
                    } else {
                        entityPart = StringUtility.replaceTags((String)entityPart, (String)"groupByParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                            public String processTag(String tagName, String tagContent) {
                                if (tagContent.length() > 0) {
                                    return tagContent;
                                }
                                return String.valueOf(tagContent) + " 1 ";
                            }
                        });
                    }
                    entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"groupByParts");
                    if (childContributions.getHavingParts().size() > 0) {
                        s3 = ListUtility.format(childContributions.getHavingParts(), (String)" AND ");
                        if (StringUtility.getTag((String)entityPart, (String)"havingParts") == null) throw new IllegalArgumentException("missing <havingParts/> tag");
                        entityPart = StringUtility.replaceTags((String)entityPart, (String)"havingParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                            public String processTag(String tagName, String tagContent) {
                                return String.valueOf(tagContent) + " AND " + s3;
                            }
                        });
                    } else {
                        entityPart = StringUtility.removeTagBounds((String)entityPart, (String)"havingParts");
                    }
                } else {
                    entityPart = StringUtility.replaceTags((String)entityPart, (String)"groupBy", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                        public String processTag(String tagName, String tagContent) {
                            if (!StringUtility.hasText((String)StringUtility.getTag((String)tagContent, (String)"groupByParts")) && !StringUtility.hasText((String)StringUtility.getTag((String)tagContent, (String)"havingParts"))) {
                                return "";
                            }
                            tagContent = StringUtility.replaceTags((String)tagContent, (String)"groupByParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                                public String processTag(String innerTagName, String innerTagContent) {
                                    if (innerTagContent.length() > 0) {
                                        return innerTagContent;
                                    }
                                    return String.valueOf(innerTagContent) + " 1 ";
                                }
                            });
                            tagContent = StringUtility.replaceTags((String)tagContent, (String)"havingParts", (StringUtility.ITagProcessor)new StringUtility.ITagProcessor(){

                                public String processTag(String innerTagName, String innerTagContent) {
                                    return innerTagContent;
                                }
                            });
                            return tagContent;
                        }
                    });
                }
            }
        }
        String selectPart = StringUtility.getTag((String)entityPart, (String)"selectPart");
        if (selectPart != null) {
            parentContrib.getSelectParts().add(selectPart);
            entityPart = StringUtility.removeTag((String)entityPart, (String)"selectPart").trim();
        }
        if ((fromPart = StringUtility.getTag((String)entityPart, (String)"fromPart")) != null) {
            parentContrib.getFromParts().add(fromPart);
            entityPart = StringUtility.removeTag((String)entityPart, (String)"fromPart").trim();
        }
        if ((wherePart = StringUtility.getTag((String)entityPart, (String)"wherePart")) != null) {
            parentContrib.getWhereParts().add(wherePart);
            entityPart = StringUtility.removeTag((String)entityPart, (String)"wherePart").trim();
        }
        if ((groupByPart = StringUtility.getTag((String)entityPart, (String)"groupByPart")) != null) {
            parentContrib.getGroupByParts().add(groupByPart);
            entityPart = StringUtility.removeTag((String)entityPart, (String)"groupByPart").trim();
        }
        if ((havingPart = StringUtility.getTag((String)entityPart, (String)"havingPart")) != null) {
            parentContrib.getHavingParts().add(havingPart);
            entityPart = StringUtility.removeTag((String)entityPart, (String)"havingPart").trim();
        }
        if (parentContrib.isEmpty()) {
            switch (entityStrategy) {
                case BuildConstraints: {
                    parentContrib.getWhereParts().add(entityPart);
                    return parentContrib;
                }
                case BuildQuery: {
                    parentContrib.getSelectParts().add(entityPart);
                    parentContrib.getGroupByParts().add("1");
                }
                default: {
                    return parentContrib;
                }
            }
        } else {
            if (entityPart.length() <= 0) return parentContrib;
            LOG.warn("entityPart " + entityPartWithTags + " contains content that is not wrapped in a tag: " + entityPart);
        }
        return parentContrib;
    }

    public static boolean isAnsiJoin(String fromPart) {
        if (fromPart == null) {
            return false;
        }
        return ANSI_JOIN_PATTERN.matcher(fromPart).matches();
    }

    public static void checkGroupByPart(String groupByPart) throws ProcessingException {
        if (groupByPart == null) {
            return;
        }
        if (CHECK_GROUP_BY_CONTAINS_SELECT_PATTERN.matcher(groupByPart).find()) {
            throw new ProcessingException("Invalid group by clause", null, 0x70000001);
        }
    }

    private static String autoBracketSelectPart(String s) {
        if (s != null && !s.startsWith("(") && s.toLowerCase().contains("select")) {
            return "(" + s + ")";
        }
        return s;
    }
}

