/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import java.util.ArrayList;
import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueOutputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindOutput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

abstract class AbstractBeanPropertyOutput
implements IBindOutput {
    private String m_propertyName;
    private Class m_propertyType;
    private ValueOutputToken m_source;
    private int m_batchIndex = -1;
    private int m_jdbcBindIndex = -1;
    private ArrayList<Object> m_accumulator;

    public AbstractBeanPropertyOutput(Class beanType, String propertyName, ValueOutputToken source) throws ProcessingException {
        this.m_propertyName = propertyName;
        this.m_accumulator = new ArrayList();
        this.m_source = source;
        try {
            FastPropertyDescriptor desc = BeanUtility.getFastBeanInfo((Class)beanType, null).getPropertyDescriptor(this.m_propertyName);
            this.m_propertyType = desc.getPropertyType();
        }
        catch (Exception e) {
            throw new ProcessingException("property " + this.m_propertyName, (Throwable)e);
        }
    }

    @Override
    public IToken getToken() {
        return this.m_source;
    }

    @Override
    public boolean isJdbcBind() {
        return !this.m_source.isSelectInto();
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_jdbcBindIndex;
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_jdbcBindIndex = index;
    }

    @Override
    public boolean isBatch() {
        return this.m_source.isBatch();
    }

    @Override
    public boolean isSelectInto() {
        return this.m_source.isSelectInto();
    }

    @Override
    public Class getBindType() {
        return this.m_propertyType;
    }

    public int getBatchIndex() {
        return this.m_batchIndex;
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_batchIndex = i;
    }

    protected abstract Object[] getFinalBeanArray();

    @Override
    public void finishBatch() throws ProcessingException {
        FastPropertyDescriptor desc = null;
        Object[] beans = this.getFinalBeanArray();
        if (beans != null) {
            int accSize = this.m_accumulator.size();
            int i = 0;
            while (i < beans.length) {
                try {
                    Object bean = beans[i];
                    if (bean != null) {
                        if (desc == null) {
                            desc = BeanUtility.getFastBeanInfo(bean.getClass(), null).getPropertyDescriptor(this.m_propertyName);
                        }
                        Object value = null;
                        if (i < accSize) {
                            value = this.m_accumulator.get(i);
                        }
                        if (IHolder.class.isAssignableFrom(desc.getPropertyType())) {
                            IHolder h = (IHolder)desc.getReadMethod().invoke(bean, new Object[0]);
                            if (h != null) {
                                Object castValue = TypeCastUtility.castValue((Object)value, (Class)h.getHolderType());
                                h.setValue(castValue);
                            }
                        } else {
                            Object castValue = TypeCastUtility.castValue((Object)value, (Class)desc.getPropertyType());
                            desc.getWriteMethod().invoke(bean, castValue);
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProcessingException("property " + this.m_propertyName, (Throwable)e);
                }
                ++i;
            }
        }
    }

    @Override
    public void setReplaceToken(ISqlStyle style) {
        this.m_source.setReplaceToken("?");
    }

    @Override
    public void consumeValue(Object value) {
        this.m_accumulator.add(value);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[bindType=" + this.getBindType() + ", name=" + this.m_propertyName + ", source=" + this.m_source + "]";
    }
}

