/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueInputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.ArrayInput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindInput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.SingleInput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class TriStateInput
implements IBindInput {
    private IBindInput m_delegate;

    public TriStateInput(TriState ts, ValueInputToken target) throws ProcessingException {
        if (ts == null || ts.isUndefined()) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            this.m_delegate = new ArrayInput(nArray, target);
        } else {
            this.m_delegate = new SingleInput(ts.getBooleanValue(), Boolean.class, target);
        }
    }

    @Override
    public IToken getToken() {
        return this.m_delegate.getToken();
    }

    @Override
    public boolean isBatch() {
        return this.m_delegate.isBatch();
    }

    @Override
    public boolean hasBatch(int i) {
        return this.m_delegate.hasBatch(i);
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_delegate.setNextBatchIndex(i);
    }

    @Override
    public boolean isJdbcBind() {
        return this.m_delegate.isJdbcBind();
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_delegate.getJdbcBindIndex();
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_delegate.setJdbcBindIndex(index);
    }

    @Override
    public SqlBind produceSqlBindAndSetReplaceToken(ISqlStyle sqlStyle) throws ProcessingException {
        return this.m_delegate.produceSqlBindAndSetReplaceToken(sqlStyle);
    }
}

