/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.session;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.shared.services.common.session.IJobRunnable;
import org.eclipse.scout.rt.shared.services.common.session.ISessionService;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-1.0f)
public class DefaultServerSessionService
extends AbstractService
implements ISessionService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultServerSessionService.class);

    public IServerSession getCurrentSession() {
        return ServerJob.getCurrentSession();
    }

    public JobEx createAsyncJob(IJobRunnable runnable) {
        return this.createAsyncJob(null, runnable);
    }

    public JobEx createAsyncJob(String name, IJobRunnable runnable) {
        IServerSession session = this.getCurrentSession();
        if (session == null) {
            LOG.error("server session not available");
            return null;
        }
        if (name == null) {
            name = "server session async job";
        }
        return new P_ServerSessionAsyncJob(name, session, runnable);
    }

    private static class P_ServerSessionAsyncJob
    extends ServerJob {
        private final IJobRunnable m_runnable;

        public P_ServerSessionAsyncJob(String name, IServerSession serverSession, IJobRunnable runnable) {
            super(name, serverSession);
            this.m_runnable = runnable;
        }

        @Override
        protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
            return this.m_runnable.run(monitor);
        }
    }
}

