/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.workflow;

import java.util.ArrayList;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.services.common.workflow.IWorkflowService;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.common.workflow.AbstractWorkflowData;
import org.eclipse.scout.rt.shared.services.common.workflow.IWorkflowProviderService;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;

@Priority(value=-1.0f)
public class WorkflowProviderService
extends AbstractService
implements IWorkflowProviderService {
    public AbstractWorkflowData[] getAvailableWorkflowTypes(SearchFilter filter) throws ProcessingException {
        ArrayList<AbstractWorkflowData> list = new ArrayList<AbstractWorkflowData>();
        IWorkflowService[] iWorkflowServiceArray = (IWorkflowService[])SERVICES.getServices(IWorkflowService.class);
        int n = iWorkflowServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkflowService s = iWorkflowServiceArray[n2];
            AbstractWorkflowData[] abstractWorkflowDataArray = s.getAvailableWorkflowTypes(filter);
            int n3 = abstractWorkflowDataArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AbstractWorkflowData data = abstractWorkflowDataArray[n4];
                list.add(data);
                ++n4;
            }
            ++n2;
        }
        return list.toArray(new AbstractWorkflowData[list.size()]);
    }

    public AbstractWorkflowData[] getFilteredWorkflows(SearchFilter filter) throws ProcessingException {
        ArrayList<AbstractWorkflowData> list = new ArrayList<AbstractWorkflowData>();
        IWorkflowService[] iWorkflowServiceArray = (IWorkflowService[])SERVICES.getServices(IWorkflowService.class);
        int n = iWorkflowServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkflowService s = iWorkflowServiceArray[n2];
            AbstractWorkflowData[] abstractWorkflowDataArray = s.getFilteredWorkflows(filter);
            int n3 = abstractWorkflowDataArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AbstractWorkflowData data = abstractWorkflowDataArray[n4];
                list.add(data);
                ++n4;
            }
            ++n2;
        }
        return list.toArray(new AbstractWorkflowData[list.size()]);
    }

    public <T extends AbstractWorkflowData> T create(T spec) throws ProcessingException {
        return this.findWorkflowService(spec).create(spec);
    }

    public <T extends AbstractWorkflowData> T discard(T data) throws ProcessingException {
        return this.findWorkflowService(data).discard(data);
    }

    public <T extends AbstractWorkflowData> T makeStateTransition(T data) throws ProcessingException {
        return this.findWorkflowService(data).makeStateTransition(data);
    }

    public <T extends AbstractWorkflowData> T store(T data) throws ProcessingException {
        return this.findWorkflowService(data).store(data);
    }

    public <T extends AbstractWorkflowData> T finish(T data) throws ProcessingException {
        return this.findWorkflowService(data).finish(data);
    }

    public <T extends AbstractWorkflowData> T resume(T spec) throws ProcessingException {
        return this.findWorkflowService(spec).resume(spec);
    }

    private <T extends AbstractWorkflowData> IWorkflowService<T> findWorkflowService(T spec) throws ProcessingException {
        String className = spec.getDefinitionServiceClass();
        if (className != null) {
            IWorkflowService[] iWorkflowServiceArray = (IWorkflowService[])SERVICES.getServices(IWorkflowService.class);
            int n = iWorkflowServiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkflowService s = iWorkflowServiceArray[n2];
                if (s.getClass().getName().equals(className)) {
                    return s;
                }
                ++n2;
            }
        }
        throw new ProcessingException("service \"" + className + "\" not found");
    }
}

