/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.lookup;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.rt.server.services.common.jdbc.ISqlService;
import org.eclipse.scout.rt.server.services.common.jdbc.SQL;
import org.eclipse.scout.rt.server.services.lookup.AbstractLookupService;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractSqlLookupService
extends AbstractLookupService {
    @ConfigProperty(value="SQL")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredSqlSelect() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=20.0)
    @ConfigPropertyValue(value="1")
    protected int getConfiguredSortColumn() {
        return 1;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected LookupRow[] execLoadLookupRows(String originalSql, String preprocessedSql, LookupCall call) throws ProcessingException {
        Object[][] data = SQL.selectLimited(preprocessedSql, call.getMaxRowCount(), call);
        if (this.getConfiguredSortColumn() >= 0) {
            AbstractSqlLookupService.sortData(data, this.getConfiguredSortColumn());
        }
        return AbstractSqlLookupService.createLookupRowArray(data, call);
    }

    public LookupRow[] getDataByKey(LookupCall call) throws ProcessingException {
        String sql = this.getConfiguredSqlSelect();
        return this.execLoadLookupRows(sql, this.filterSqlByKey(sql), call);
    }

    public LookupRow[] getDataByText(LookupCall call) throws ProcessingException {
        if (call.getText() != null) {
            String s = call.getText();
            String sqlWildcard = ((ISqlService)SERVICES.getService(ISqlService.class)).getSqlStyle().getLikeWildcard();
            call.setText(s.replaceAll("[*]", sqlWildcard));
        }
        String sql = this.getConfiguredSqlSelect();
        return this.execLoadLookupRows(sql, this.filterSqlByText(sql), call);
    }

    public LookupRow[] getDataByAll(LookupCall call) throws ProcessingException {
        String sql = this.getConfiguredSqlSelect();
        if (AbstractSqlLookupService.containsRefusingAllTag(sql)) {
            throw new VetoException(ScoutTexts.get((String)"SearchTextIsTooGeneral", (String[])new String[0]));
        }
        LookupRow[] rows = this.execLoadLookupRows(sql, this.filterSqlByAll(sql), call);
        return rows;
    }

    public LookupRow[] getDataByRec(LookupCall call) throws ProcessingException {
        String sql = this.getConfiguredSqlSelect();
        return this.execLoadLookupRows(sql, this.filterSqlByRec(sql), call);
    }

    protected String filterSqlByKey(String sqlSelect) {
        return StringUtility.removeTagBounds((String)StringUtility.removeTags((String)sqlSelect, (String[])new String[]{"text", "all", "rec"}), (String)"key");
    }

    protected String filterSqlByText(String sqlSelect) {
        return StringUtility.removeTagBounds((String)StringUtility.removeTags((String)sqlSelect, (String[])new String[]{"key", "all", "rec"}), (String)"text");
    }

    protected String filterSqlByAll(String sqlSelect) {
        return StringUtility.removeTagBounds((String)StringUtility.removeTags((String)sqlSelect, (String[])new String[]{"key", "text", "rec"}), (String)"all");
    }

    protected static boolean containsRefusingAllTag(String sqlSelect) {
        Matcher m = Pattern.compile("<all>\\s*and\\s*([0-9]+)\\s*=\\s*([0-9]+)\\s*</all>", 32).matcher(sqlSelect.toLowerCase());
        return m.find() && !m.group(1).equals(m.group(2));
    }

    protected String filterSqlByRec(String sqlSelect) {
        return StringUtility.removeTagBounds((String)StringUtility.removeTags((String)sqlSelect, (String[])new String[]{"key", "text", "all"}), (String)"rec");
    }
}

