/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.transaction;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.transaction.ITransaction;
import org.eclipse.scout.rt.server.transaction.ITransactionMember;

public class BasicTransaction
implements ITransaction {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BasicTransaction.class);
    private final long m_transactionSequence;
    private final Object m_memberMapLock = new Object();
    private final Map<String, ITransactionMember> m_memberMap = new LinkedHashMap<String, ITransactionMember>();
    private ArrayList<Throwable> m_failures = new ArrayList();
    private boolean m_commitPhase;
    private boolean m_cancelled;

    public BasicTransaction() {
        this(0L);
    }

    public BasicTransaction(long transactionSequence) {
        this.m_transactionSequence = transactionSequence;
    }

    @Override
    public long getTransactionSequence() {
        return this.m_transactionSequence;
    }

    @Override
    public void registerResource(ITransactionMember member) {
        try {
            this.registerMember(member);
        }
        catch (ProcessingException e) {
            throw new IllegalStateException("Interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMember(ITransactionMember member) throws ProcessingException {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            ITransactionMember old;
            String memberId = member.getMemberId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("register transaction member {0}", (Object)memberId);
            }
            if ((old = this.m_memberMap.get(memberId)) != null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("releasing overwritten transaction member {0} / {1}.", (Object)memberId, (Object)old.getMemberId());
                }
                old.release();
            }
            this.m_memberMap.put(memberId, member);
            if (this.m_cancelled) {
                throw new ProcessingException("Interrupted", (Throwable)new InterruptedException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITransactionMember getMember(String memberId) {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            ITransactionMember res = this.m_memberMap.get(memberId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("get transaction member '{0}' -> '{1}'.", (Object)memberId, (Object)res);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITransactionMember[] getMembers() {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            return this.getMembersNoLocking();
        }
    }

    private ITransactionMember[] getMembersNoLocking() {
        return this.m_memberMap.values().toArray(new ITransactionMember[this.m_memberMap.size()]);
    }

    @Override
    public void unregisterMember(ITransactionMember member) {
        if (member == null) {
            return;
        }
        this.unregisterMember(member.getMemberId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMember(String memberId) {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            this.m_memberMap.remove(memberId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("unregister transaction member '{0}'.", (Object)memberId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitPhase1() throws ProcessingException {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            if (this.m_cancelled) {
                throw new ProcessingException("Interrupted", (Throwable)new InterruptedException());
            }
            this.m_commitPhase = true;
        }
        boolean allSuccessful = true;
        ITransactionMember[] iTransactionMemberArray = this.getMembers();
        int n = iTransactionMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                ITransactionMember mem = iTransactionMemberArray[n2];
                try {
                    if (!mem.needsCommit()) break block9;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("commit phase 1 of transaction member '{0}'.", (Object)mem.getMemberId());
                    }
                    boolean b = mem.commitPhase1();
                    boolean bl = allSuccessful = allSuccessful && b;
                    if (!allSuccessful) {
                        LOG.error("commit phase 1 failed for transaction member '{}'.", (Object)mem.getMemberId());
                    }
                    break block9;
                }
                catch (Throwable t) {
                    this.addFailure(t);
                    LOG.error("commit phase 1 failed with exception for transaction member '" + mem.getMemberId() + "'.", t);
                }
                break;
            }
            ++n2;
        }
        return allSuccessful && !this.hasFailures();
    }

    @Override
    public void commitPhase2() {
        ITransactionMember[] iTransactionMemberArray = this.getMembers();
        int n = iTransactionMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITransactionMember mem = iTransactionMemberArray[n2];
            try {
                if (mem.needsCommit()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(" " + mem);
                    }
                    mem.commitPhase2();
                }
            }
            catch (Throwable t) {
                this.addFailure(t);
                LOG.error("commit phase 2 failed for transaction member '" + mem.getMemberId() + "'.", t);
            }
            ++n2;
        }
    }

    @Override
    public void rollback() {
        ITransactionMember[] iTransactionMemberArray = this.getMembers();
        int n = iTransactionMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITransactionMember mem = iTransactionMemberArray[n2];
            try {
                if (mem.needsCommit()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(" " + mem);
                    }
                    mem.rollback();
                }
            }
            catch (Throwable t) {
                this.addFailure(t);
                LOG.error("rollback failed for transaction member '" + mem.getMemberId() + "'.", t);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        ITransactionMember[] a;
        Object object = this.m_memberMapLock;
        synchronized (object) {
            a = this.getMembersNoLocking();
            this.m_memberMap.clear();
        }
        ITransactionMember[] iTransactionMemberArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            ITransactionMember mem = iTransactionMemberArray[n2];
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" " + mem);
                }
                mem.release();
            }
            catch (Throwable t) {
                LOG.error("release " + mem, t);
            }
            ++n2;
        }
    }

    @Override
    public boolean hasFailures() {
        return this.m_failures.size() > 0;
    }

    @Override
    public Throwable[] getFailures() {
        return this.m_failures.toArray(new Throwable[this.m_failures.size()]);
    }

    @Override
    public void addFailure(Throwable t) {
        this.m_failures.add(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean cancel() {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            block9: {
                block8: {
                    if (!this.m_commitPhase) break block8;
                    return false;
                }
                if (!this.m_cancelled) break block9;
                return true;
            }
            this.m_cancelled = true;
            this.addFailure(new InterruptedException());
        }
        ITransactionMember[] iTransactionMemberArray = this.getMembers();
        int n = iTransactionMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITransactionMember mem = iTransactionMemberArray[n2];
            try {
                mem.cancel();
            }
            catch (Throwable t) {
                LOG.error("cancel " + mem, t);
            }
            ++n2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            return this.m_cancelled;
        }
    }
}

