/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.rt.shared.ui;

/**
 * @since 3.8.0
 */
public enum UiDeviceType implements IUiDeviceType {
  DESKTOP,
  TABLET(true),
  MOBILE(true),
  UNKNOWN;

  boolean m_touchDevice;

  private UiDeviceType(boolean touchDevice) {
    m_touchDevice = touchDevice;
  }

  private UiDeviceType() {
    this(false);
  }

  @Override
  public boolean isTouchDevice() {
    return m_touchDevice;
  }

  @Override
  public String getIdentifier() {
    return name();
  }

  public static IUiDeviceType createByIdentifier(String identifier) {
    return valueOf(identifier);
  }

}
