/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.common.code.CodeRow;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;

public abstract class AbstractCode<T>
implements ICode<T>,
Serializable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCode.class);
    private static final long serialVersionUID = 1L;
    private transient ICodeType m_codeType;
    private CodeRow m_row;
    private transient ICode m_parentCode;
    private transient HashMap<Object, ICode> m_codeMap = null;
    private ArrayList<ICode> m_codeList = null;

    public AbstractCode(CodeRow row) {
        this.m_row = row;
    }

    public AbstractCode() {
        this.initConfig();
    }

    @ConfigProperty(value="TEXT")
    @Order(value=50.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredActive() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=65.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=40.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=70.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTooltipText() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredBackgroundColor() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredForegroundColor() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=30.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFont() {
        return null;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=80.0)
    @ConfigPropertyValue(value="null")
    protected Double getConfiguredValue() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=80.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredExtKey() {
        return null;
    }

    private Class<? extends ICode>[] getConfiguredCodes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, ICode.class);
    }

    protected void initConfig() {
        this.m_row = this.interceptCodeRow(new CodeRow(this.getId(), this.getConfiguredText(), this.getConfiguredIconId(), this.getConfiguredTooltipText() != null ? this.getConfiguredTooltipText() : null, this.getConfiguredBackgroundColor(), this.getConfiguredForegroundColor(), FontSpec.parse(this.getConfiguredFont()), this.getConfiguredEnabled(), null, this.getConfiguredActive(), this.getConfiguredExtKey(), this.getConfiguredValue(), 0L));
        for (ICode<?> childCode : this.execCreateChildCodes()) {
            this.addChildCodeInternal(childCode);
        }
    }

    protected List<ICode<?>> execCreateChildCodes() {
        ArrayList codes = new ArrayList();
        Class<ICode>[] a = this.getConfiguredCodes();
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                try {
                    ICode code = (ICode)ConfigurationUtility.newInnerInstance((Object)this, a[i]);
                    codes.add(code);
                }
                catch (Exception e) {
                    LOG.warn(null, (Throwable)e);
                }
                ++i;
            }
        }
        return codes;
    }

    protected CodeRow interceptCodeRow(CodeRow row) {
        return row;
    }

    @Override
    public T getId() {
        return (T)this.m_row.getKey();
    }

    @Override
    public String getText() {
        return this.m_row.getText();
    }

    @Override
    public boolean isActive() {
        return this.m_row.isActive();
    }

    public void setActiveInternal(boolean b) {
        this.m_row.setActive(b);
    }

    @Override
    public boolean isEnabled() {
        return this.m_row.isEnabled();
    }

    public void setEnabledInternal(boolean b) {
        this.m_row.setEnabled(b);
    }

    @Override
    public String getIconId() {
        String id = this.m_row.getIconId();
        if (id == null && this.m_codeType != null) {
            id = this.m_codeType.getIconId();
        }
        return id;
    }

    @Override
    public String getTooltipText() {
        return this.m_row.getTooltip();
    }

    @Override
    public String getBackgroundColor() {
        return this.m_row.getBackgroundColor();
    }

    @Override
    public String getForegroundColor() {
        return this.m_row.getForegroundColor();
    }

    @Override
    public FontSpec getFont() {
        return this.m_row.getFont();
    }

    @Override
    public ICode getParentCode() {
        return this.m_parentCode;
    }

    @Override
    public long getPartitionId() {
        return this.m_row.getPartitionId();
    }

    @Override
    public String getExtKey() {
        return this.m_row.getExtKey();
    }

    @Override
    public Number getValue() {
        return this.m_row.getValue();
    }

    @Override
    public ICode[] getChildCodes() {
        return this.getChildCodes(true);
    }

    @Override
    public ICode[] getChildCodes(boolean activeOnly) {
        if (this.m_codeList == null) {
            return new ICode[0];
        }
        ArrayList<ICode> list = new ArrayList<ICode>(this.m_codeList);
        if (activeOnly) {
            Iterator<ICode> it = list.iterator();
            while (it.hasNext()) {
                ICode code = it.next();
                if (code.isActive()) continue;
                it.remove();
            }
        }
        return list.toArray(new ICode[0]);
    }

    @Override
    public ICode getChildCode(Object id) {
        ICode c = null;
        if (this.m_codeMap != null) {
            c = this.m_codeMap.get(id);
        }
        if (c == null) {
            if (this.m_codeList == null) {
                return null;
            }
            for (ICode childCode : this.m_codeList) {
                c = childCode.getChildCode(id);
                if (c == null) continue;
                return c;
            }
        }
        return c;
    }

    @Override
    public ICode getChildCodeByExtKey(Object extKey) {
        if (this.m_codeList == null) {
            return null;
        }
        ICode c = null;
        for (ICode childCode : this.m_codeList) {
            c = extKey.equals(childCode.getExtKey()) ? childCode : childCode.getChildCodeByExtKey(extKey);
            if (c == null) continue;
            return c;
        }
        return c;
    }

    @Override
    public ICodeType getCodeType() {
        return this.m_codeType;
    }

    @Override
    public void addChildCodeInternal(ICode code) {
        code.setCodeTypeInternal(this.m_codeType);
        code.setParentCodeInternal(this);
        if (this.m_codeMap == null) {
            this.m_codeMap = new HashMap();
        }
        this.m_codeMap.put(code.getId(), code);
        if (this.m_codeList == null) {
            this.m_codeList = new ArrayList();
        }
        this.m_codeList.add(code);
    }

    @Override
    public void setParentCodeInternal(ICode c) {
        this.m_parentCode = c;
    }

    @Override
    public void setCodeTypeInternal(ICodeType type) {
        this.m_codeType = type;
        if (this.m_codeList != null) {
            for (ICode c : this.m_codeList) {
                c.setCodeTypeInternal(type);
            }
        }
    }

    public String toString() {
        return "Code[id=" + this.getId() + ", text='" + this.getText() + "' " + (this.isActive() ? "active" : "inactive") + "]";
    }

    @Override
    public boolean visit(ICodeVisitor visitor, int level, boolean activeOnly) {
        ICode[] a = this.getChildCodes(activeOnly);
        int i = 0;
        while (i < a.length) {
            ICode code = a[i];
            if (!visitor.visit(code, level)) {
                return false;
            }
            if (!code.visit(visitor, level + 1, activeOnly)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.m_codeMap = new HashMap();
        if (this.m_codeList == null) {
            this.m_codeList = new ArrayList();
        } else {
            for (ICode c : this.m_codeList) {
                this.m_codeMap.put(c.getId(), c);
                c.setParentCodeInternal(this);
            }
        }
        return this;
    }

    @Override
    public CodeRow toCodeRow() {
        return new CodeRow(this.m_row);
    }
}

