/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.jdbc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;

public class SearchFilter
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    private boolean m_completed;
    private AbstractFormData m_formData;
    private ArrayList<String> m_displayTexts = new ArrayList();

    public AbstractFormData getFormData() {
        return this.m_formData;
    }

    public void setFormData(AbstractFormData formData) {
        this.m_formData = formData;
    }

    public void addDisplayText(String s) {
        this.m_displayTexts.add(s);
    }

    public void clear() {
        this.m_completed = false;
        this.m_displayTexts.clear();
        this.m_formData = null;
    }

    public String[] getDisplayTexts() {
        return this.m_displayTexts.toArray(new String[0]);
    }

    public void setDisplayTexts(String[] displayTexts) {
        if (displayTexts == null) {
            displayTexts = new String[]{};
        }
        this.m_displayTexts = new ArrayList<String>(Arrays.asList(displayTexts));
    }

    public String getDisplayTextsPlain() {
        StringBuffer buf = new StringBuffer();
        String[] stringArray = this.getDisplayTexts();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                buf.append(s.trim());
                buf.append("\n");
            }
            ++n2;
        }
        return buf.toString().trim();
    }

    public boolean isCompleted() {
        return this.m_completed;
    }

    public void setCompleted(boolean b) {
        this.m_completed = b;
    }

    public Object clone() {
        SearchFilter f;
        try {
            f = (SearchFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        f.m_completed = this.m_completed;
        if (this.m_formData != null) {
            f.m_formData = (AbstractFormData)this.m_formData.clone();
        }
        f.m_displayTexts = new ArrayList<String>(this.m_displayTexts);
        return f;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getSimpleName());
        buf.append("[");
        if (this.m_formData != null) {
            buf.append(this.m_formData.toString());
        }
        buf.append("]");
        return buf.toString();
    }
}

