/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.security;

import java.security.Permission;
import java.security.Permissions;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleClassDescriptor;
import org.eclipse.scout.rt.shared.security.BasicHierarchyPermission;
import org.eclipse.scout.rt.shared.services.common.security.IPermissionService;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;

public final class AccessControlUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AccessControlUtility.class);

    private AccessControlUtility() {
    }

    @Deprecated
    public static Permissions createPermissions(Object[][] permissionData, Bundle classLoaderBundle) {
        return AccessControlUtility.createPermissions(permissionData);
    }

    public static Permissions createPermissions(Object[][] permissionData) {
        int n;
        HashMap<String, BundleClassDescriptor> permissionNameToBundleClassDesc = new HashMap<String, BundleClassDescriptor>();
        IPermissionService psvc = (IPermissionService)SERVICES.getService(IPermissionService.class);
        if (psvc != null) {
            BundleClassDescriptor[] bundleClassDescriptorArray = psvc.getAllPermissionClasses();
            n = bundleClassDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleClassDescriptor d = bundleClassDescriptorArray[n2];
                permissionNameToBundleClassDesc.put(d.getSimpleClassName(), d);
                permissionNameToBundleClassDesc.put(d.getClassName(), d);
                ++n2;
            }
        }
        Permissions permSet = new Permissions();
        Object[][] objectArray = permissionData;
        int n3 = permissionData.length;
        n = 0;
        while (n < n3) {
            Object[] permissionRow = objectArray[n];
            String name = "" + permissionRow[0];
            name = name.replace("com.bsiag.scout.shared.security.", "org.eclipse.scout.rt.shared.security.");
            int level = (Integer)TypeCastUtility.castValue((Object)permissionRow[1], Integer.class);
            try {
                BundleClassDescriptor desc = (BundleClassDescriptor)permissionNameToBundleClassDesc.get(name);
                if (desc == null) {
                    LOG.warn("Unknown permission with name: " + permissionRow[0]);
                } else {
                    Bundle bundle = Platform.getBundle((String)desc.getBundleSymbolicName());
                    Class c = bundle.loadClass(desc.getClassName());
                    Permission p = (Permission)c.newInstance();
                    if (p instanceof BasicHierarchyPermission) {
                        ((BasicHierarchyPermission)p).setLevel(level);
                        ((BasicHierarchyPermission)p).setReadOnly();
                    }
                    permSet.add(p);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Unknown permission with name: " + permissionRow[0]);
            }
            catch (InstantiationException e) {
                LOG.warn("Unable to load user-permission: " + permissionRow[0]);
            }
            catch (IllegalAccessException e) {
                LOG.warn("Unable to access user-permission: " + permissionRow[0]);
            }
            ++n;
        }
        return permSet;
    }
}

