/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class BatchLookupResultCache {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BatchLookupResultCache.class);
    private static final Object globalCacheableLock = new Object();
    private static final HashMap<Class<? extends LookupCall>, Boolean> globalCacheable = new HashMap();
    private HashMap<LookupCall, LookupRow[]> m_cache = new HashMap();

    public void reset() {
        this.m_cache.clear();
    }

    public LookupRow[] getDataByKey(LookupCall call) throws ProcessingException {
        if (call == null || call.getKey() == null) {
            return LookupRow.EMPTY_ARRAY;
        }
        LookupRow[] result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByKey();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public LookupRow[] getDataByText(LookupCall call) throws ProcessingException {
        LookupRow[] result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByText();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public LookupRow[] getDataByAll(LookupCall call) throws ProcessingException {
        LookupRow[] result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByAll();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public LookupRow[] getDataByRec(LookupCall call) throws ProcessingException {
        LookupRow[] result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByRec();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public LookupRow[] getCachedResult(LookupCall call) {
        if (call == null || !BatchLookupResultCache.isCacheable(call.getClass())) {
            return null;
        }
        return this.m_cache.get(call);
    }

    public void putCachedResult(LookupCall call, LookupRow[] result) {
        if (call == null || result == null || !BatchLookupResultCache.isCacheable(call.getClass())) {
            return;
        }
        this.m_cache.put(call, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCacheable(Class<? extends LookupCall> clazz) {
        if (clazz == null) {
            return false;
        }
        Object object = globalCacheableLock;
        synchronized (object) {
            Boolean b = globalCacheable.get(clazz);
            if (b == null) {
                b = BatchLookupResultCache.verifyLookupCallBeanQuality(clazz);
                globalCacheable.put(clazz, b);
            }
            return b;
        }
    }

    private static boolean verifyLookupCallBeanQuality(Class<? extends LookupCall> clazz) {
        if (clazz == LocalLookupCall.class) {
            return true;
        }
        if (clazz == LookupCall.class) {
            return true;
        }
        Class<? extends LookupCall> t = clazz;
        while (t != null && t != LookupCall.class) {
            Field[] fieldArray = t.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!f.isSynthetic() && !f.isEnumConstant() && (f.getModifiers() & 8) == 0) {
                    try {
                        t.getDeclaredMethod("equals", Object.class);
                    }
                    catch (Throwable ex) {
                        LOG.warn(clazz + " subclasses LookupCall with an additional member field '" + t.getSimpleName() + "." + f.getName() + "' and should therefore override the 'boolean equals(Object obj)' and 'int hashCode()' methods");
                        return false;
                    }
                }
                ++n2;
            }
            t = t.getSuperclass();
        }
        return true;
    }
}

