/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.IUserAgentParser;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UserAgent;

public class DefaultUserAgentParser
implements IUserAgentParser {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultUserAgentParser.class);
    public static String DELIMITER = "|";

    @Override
    public UserAgent parseIdentifier(String userAgent) {
        String[] tokens = StringUtility.tokenize((String)userAgent, (char)DELIMITER.charAt(0));
        if (tokens.length != 3) {
            LOG.warn("UserAgentIdentifier could not be parsed. Invalid number of tokens. UserAgent: " + userAgent);
            return UserAgent.createDefault();
        }
        try {
            IUiLayer uiLayer = UiLayer.createByIdentifier(tokens[0]);
            IUiDeviceType uiDeviceType = UiDeviceType.createByIdentifier(tokens[1]);
            String uiDeviceId = tokens[2];
            return UserAgent.create(uiLayer, uiDeviceType, uiDeviceId);
        }
        catch (Throwable t) {
            LOG.warn("UserAgentIdentifier could not be parsed. Exception occured while parsing. UserAgent: " + userAgent, t);
            return UserAgent.createDefault();
        }
    }

    @Override
    public String createIdentifier(UserAgent userAgent) {
        String uiDeviceId = userAgent.getUiDeviceId();
        if (uiDeviceId.contains(DELIMITER)) {
            uiDeviceId = uiDeviceId.replaceAll(DELIMITER, "_");
            LOG.warn("Character which is used as delimiter has been found in uiDeviceId. Replaced with '_'. Old uiDeviceId: " + userAgent.getUiDeviceId() + ". New uiDeviceId: " + uiDeviceId);
            userAgent.setUiDeviceId(uiDeviceId);
        }
        return StringUtility.concatenateTokens((String[])new String[]{userAgent.getUiLayer().getIdentifier(), String.valueOf(DELIMITER), userAgent.getUiDeviceType().getIdentifier(), String.valueOf(DELIMITER), uiDeviceId});
    }
}

