/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.session.IClientSessionRegistryService;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.outline.DefaultOutlineTableForm;
import org.eclipse.scout.rt.client.ui.form.outline.DefaultOutlineTreeForm;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.testing.commons.ScoutAssert;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.scout.testing.client.IGuiMock;
import org.eclipse.scout.testing.client.IGuiMockService;
import org.junit.Test;

public abstract class AbstractTestWithGuiScript {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTestWithGuiScript.class);
    private boolean m_testActive;
    protected IClientSession clientSession;

    protected abstract Class<? extends IClientSession> getSessionClass();

    protected void runGui(IGuiMock gui) throws Throwable {
    }

    protected void runModel() throws Throwable {
    }

    protected void disposeModel() throws Throwable {
    }

    protected void resetSession() throws Throwable {
        IMessageBox f;
        IDesktop desktop = this.clientSession.getDesktop();
        desktop.setAvailableOutlines(null);
        desktop.setOutline(null);
        IMessageBox[] iMessageBoxArray = desktop.getMessageBoxStack();
        int n = iMessageBoxArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMessageBox m = iMessageBoxArray[n2];
            try {
                m.getUIFacade().setResultFromUI(2);
            }
            catch (Throwable t) {
                LOG.warn("closing messagebox " + m.getClass(), t);
            }
            ++n2;
        }
        iMessageBoxArray = desktop.getDialogStack();
        n = iMessageBoxArray.length;
        n2 = 0;
        while (n2 < n) {
            f = iMessageBoxArray[n2];
            try {
                f.doClose();
            }
            catch (Throwable t) {
                LOG.warn("closing dialog " + f.getClass(), t);
            }
            ++n2;
        }
        iMessageBoxArray = desktop.getViewStack();
        n = iMessageBoxArray.length;
        n2 = 0;
        while (n2 < n) {
            f = iMessageBoxArray[n2];
            if (!(f instanceof DefaultOutlineTreeForm) && !(f instanceof DefaultOutlineTableForm)) {
                try {
                    f.doClose();
                }
                catch (Throwable t) {
                    LOG.warn("closing view " + f.getClass(), t);
                }
            }
            ++n2;
        }
    }

    @Test
    public final void test() throws Throwable {
        IGuiMockService guiMockService = (IGuiMockService)SERVICES.getService(IGuiMockService.class);
        if (guiMockService == null) {
            return;
        }
        this.clientSession = ((IClientSessionRegistryService)SERVICES.getService(IClientSessionRegistryService.class)).newClientSession(this.getSessionClass(), guiMockService.initUserAgent());
        final IGuiMock gui = guiMockService.createMock(this.clientSession);
        gui.beforeTest();
        try {
            ClientSyncJob runModelJob = new ClientSyncJob("Run", this.clientSession){

                protected void runVoid(IProgressMonitor m) throws Throwable {
                    AbstractTestWithGuiScript.this.resetSession();
                    AbstractTestWithGuiScript.this.runModel();
                }
            };
            runModelJob.setUser(false);
            runModelJob.setSystem(true);
            ClientSyncJob disposeModelJob = new ClientSyncJob("Dispose", this.clientSession){

                protected void runVoid(IProgressMonitor m) throws Throwable {
                    try {
                        AbstractTestWithGuiScript.this.disposeModel();
                    }
                    finally {
                        AbstractTestWithGuiScript.this.resetSession();
                    }
                }
            };
            disposeModelJob.setUser(false);
            disposeModelJob.setSystem(true);
            JobEx guiScriptJob = new JobEx("Gui Script"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        gui.waitForIdle();
                        AbstractTestWithGuiScript.this.runGui(gui);
                        return Status.OK_STATUS;
                    }
                    catch (Throwable t) {
                        return new Status(2, AbstractTestWithGuiScript.this.getClass().getName(), t.getMessage(), t);
                    }
                }
            };
            guiScriptJob.setUser(false);
            guiScriptJob.setSystem(true);
            try {
                this.m_testActive = true;
                runModelJob.schedule();
                while (!runModelJob.isWaitFor() && runModelJob.getState() != 0) {
                    runModelJob.join(100L);
                }
                guiScriptJob.schedule();
                guiScriptJob.join();
            }
            finally {
                this.m_testActive = false;
                disposeModelJob.schedule();
                disposeModelJob.join();
            }
            runModelJob.join();
            ScoutAssert.jobSuccessfullyCompleted((JobEx)runModelJob);
            ScoutAssert.jobSuccessfullyCompleted((JobEx)guiScriptJob);
            ScoutAssert.jobSuccessfullyCompleted((JobEx)disposeModelJob);
        }
        finally {
            gui.afterTest();
        }
    }

    public boolean isTestActive() {
        return this.m_testActive;
    }
}

