/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client.robot;

import java.awt.AWTException;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.eclipse.scout.testing.client.IGuiMock;

public class JavaRobot {
    private Robot m_robot;
    private int m_x;
    private int m_y;

    public JavaRobot() {
        try {
            this.m_robot = new Robot();
            this.m_robot.setAutoDelay(10);
            this.m_robot.setAutoWaitForIdle(false);
        }
        catch (AWTException e) {
            throw new RuntimeException(e);
        }
    }

    public int getAutoDelay() {
        return this.m_robot.getAutoDelay();
    }

    public void setAutoDelay(int ms) {
        this.m_robot.setAutoDelay(ms);
    }

    public void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ite) {
            ite.printStackTrace();
        }
    }

    public void moveTo(int x, int y) {
        this.m_x = x;
        this.m_y = y;
        this.m_robot.mouseMove(x, y);
    }

    public void moveDelta(int dx, int dy) {
        this.m_x += dx;
        this.m_y += dy;
        this.m_robot.mouseMove(this.m_x, this.m_y);
    }

    public void pressLeft() {
        this.m_robot.mousePress(16);
    }

    public void releaseLeft() {
        this.m_robot.mouseRelease(16);
    }

    public void clickLeft() {
        this.m_robot.mousePress(16);
        this.m_robot.mouseRelease(16);
    }

    public void pressRight() {
        this.m_robot.mousePress(4);
    }

    public void releaseRight() {
        this.m_robot.mouseRelease(4);
    }

    public void clickRight() {
        this.m_robot.mousePress(4);
        this.m_robot.mouseRelease(4);
    }

    public void pressKey(IGuiMock.Key key) {
        this.m_robot.keyPress(this.toKeyCode(key));
    }

    public void releaseKey(IGuiMock.Key key) {
        this.m_robot.keyRelease(this.toKeyCode(key));
    }

    public void typeKey(IGuiMock.Key key) {
        this.m_robot.keyPress(this.toKeyCode(key));
        this.m_robot.keyRelease(this.toKeyCode(key));
    }

    public void typeText(String s) {
        if (s == null || s.length() == 0) {
            return;
        }
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            boolean shift = Character.isUpperCase(c);
            char upperChar = Character.toUpperCase(c);
            if (upperChar == ' ' || upperChar >= 'A' && upperChar <= 'Z' || upperChar >= '0' && upperChar <= '9') {
                try {
                    if (shift) {
                        this.m_robot.keyPress(16);
                    }
                    this.m_robot.keyPress(upperChar);
                    this.m_robot.keyRelease(upperChar);
                }
                finally {
                    if (shift) {
                        this.m_robot.keyRelease(16);
                    }
                }
            } else {
                this.pressSpecialKey(c);
            }
            ++n2;
        }
    }

    private void pressSpecialKey(char ch) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable oldContent = clipboard.getContents(null);
        try {
            StringSelection selection = new StringSelection("" + ch);
            clipboard.setContents(selection, null);
            try {
                this.m_robot.keyPress(17);
                this.m_robot.keyPress(86);
                this.m_robot.keyRelease(86);
                this.m_robot.keyRelease(17);
            }
            catch (Throwable ex) {
                this.m_robot.keyPress(65487);
                this.m_robot.keyRelease(65487);
            }
        }
        finally {
            clipboard.setContents(oldContent, null);
        }
    }

    protected int toKeyCode(IGuiMock.Key key) {
        switch (key) {
            case Shift: {
                return 16;
            }
            case Control: {
                return 17;
            }
            case Alt: {
                return 18;
            }
            case Delete: {
                return 127;
            }
            case Backspace: {
                return 8;
            }
            case Enter: {
                return 10;
            }
            case Esc: {
                return 27;
            }
            case Tab: {
                return 9;
            }
            case ContextMenu: {
                return 525;
            }
            case Up: {
                return 38;
            }
            case Down: {
                return 40;
            }
            case Left: {
                return 37;
            }
            case Right: {
                return 39;
            }
            case Windows: {
                return 524;
            }
            case F1: {
                return 112;
            }
            case F2: {
                return 113;
            }
            case F3: {
                return 114;
            }
            case F4: {
                return 115;
            }
            case F5: {
                return 116;
            }
            case F6: {
                return 117;
            }
            case F7: {
                return 118;
            }
            case F8: {
                return 119;
            }
            case F9: {
                return 120;
            }
            case F10: {
                return 121;
            }
            case F11: {
                return 122;
            }
            case F12: {
                return 123;
            }
            case Home: {
                return 36;
            }
            case End: {
                return 35;
            }
            case PageUp: {
                return 33;
            }
            case PageDown: {
                return 34;
            }
            case NumPad0: {
                return 96;
            }
            case NumPad1: {
                return 97;
            }
            case NumPad2: {
                return 98;
            }
            case NumPad3: {
                return 99;
            }
            case NumPad4: {
                return 100;
            }
            case NumPad5: {
                return 101;
            }
            case NumPad6: {
                return 102;
            }
            case NumPad7: {
                return 103;
            }
            case NumPad8: {
                return 104;
            }
            case NumPadMultiply: {
                return 106;
            }
            case NumPadDivide: {
                return 111;
            }
            case NumPadAdd: {
                return 107;
            }
            case NumPadSubtract: {
                return 109;
            }
            case NumPadDecimal: {
                return 110;
            }
            case NumPadSeparator: {
                return 108;
            }
        }
        throw new IllegalArgumentException("Unknown keyboard key: " + (Object)((Object)key));
    }
}

