/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.shared;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.testing.shared.WaitCondition;
import org.eclipse.scout.service.IService;
import org.eclipse.scout.service.IService2;
import org.eclipse.scout.service.ServiceUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public final class TestingUtility {
    private TestingUtility() {
    }

    public static <T> T waitUntil(long timeout, WaitCondition<T> w) throws Throwable {
        long ts = System.currentTimeMillis() + timeout;
        T t = w.run();
        while (t == null && System.currentTimeMillis() < ts) {
            Thread.sleep(40L);
            t = w.run();
        }
        if (t != null) {
            return t;
        }
        throw new InterruptedException("timeout reached");
    }

    public static List<ServiceRegistration> registerServices(Bundle bundle, int ranking, Object ... services) {
        ArrayList<ServiceRegistration> result = new ArrayList<ServiceRegistration>();
        Hashtable<String, Integer> initParams = new Hashtable<String, Integer>();
        initParams.put("service.ranking", ranking);
        Object[] objectArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            Object service = objectArray[n2];
            ServiceRegistration reg = bundle.getBundleContext().registerService(TestingUtility.computeServiceNames(service), service, initParams);
            result.add(reg);
            if (!Proxy.isProxyClass(service.getClass())) {
                if (service instanceof IService2) {
                    ((IService2)service).initializeService(reg);
                } else if (service instanceof IService) {
                    ((IService)service).initializeService();
                }
            }
            ++n2;
        }
        return result;
    }

    private static String[] computeServiceNames(Object service) {
        ArrayList<String> serviceNames = new ArrayList<String>();
        Class<?> implClass = service.getClass();
        while (implClass != null && implClass != Object.class) {
            serviceNames.add(implClass.getName());
            implClass = implClass.getSuperclass();
        }
        Class[] classArray = ServiceUtility.getInterfacesHierarchy(service.getClass(), Object.class);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            serviceNames.add(c.getName());
            ++n2;
        }
        return serviceNames.toArray(new String[serviceNames.size()]);
    }

    public static void unregisterServices(List<ServiceRegistration> registrationList) {
        if (registrationList == null) {
            return;
        }
        for (ServiceRegistration reg : registrationList) {
            reg.unregister();
        }
    }

    public static boolean clearHttpAuthenticationCache() {
        boolean successful = true;
        try {
            Class<?> c = Class.forName("sun.net.www.protocol.http.AuthCacheValue");
            Field cacheField = c.getDeclaredField("cache");
            cacheField.setAccessible(true);
            Object cache = cacheField.get(null);
            Field hashtableField = cache.getClass().getDeclaredField("hashtable");
            hashtableField.setAccessible(true);
            Map map = (Map)hashtableField.get(cache);
            map.clear();
        }
        catch (Throwable t) {
            successful = false;
        }
        return successful;
    }
}

