/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.shared.services.common.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleClassDescriptor;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeService;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TestingCodeService
extends AbstractService
implements ICodeService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TestingCodeService.class);
    private final Map<Class<? extends ICodeType>, ICodeType<?>> m_codeTypes = new HashMap();
    private final Object m_codeTypeMapLock = new Object();

    public TestingCodeService(ICodeType<?> ... codeTypes) {
        this.addCodeTypes(codeTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCodeTypes(ICodeType<?> ... codeTypes) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            ICodeType<?>[] iCodeTypeArray = codeTypes;
            int n = codeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ICodeType<?> ct = iCodeTypeArray[n2];
                if (ct != null) {
                    this.m_codeTypes.put(ct.getClass(), ct);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType> T getCodeType(Class<T> type) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return (T)this.m_codeTypes.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType> T getCodeType(Long partitionId, Class<T> type) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return this.getCodeType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeType findCodeTypeById(Object id) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            for (ICodeType<?> ct : this.m_codeTypes.values()) {
                if (!CompareUtility.equals((Object)ct.getId(), (Object)id)) continue;
                return ct;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeType findCodeTypeById(Long partitionId, Object id) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return this.findCodeTypeById(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeType[] getCodeTypes(Class ... types) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            ArrayList result = new ArrayList();
            Class[] classArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class type = classArray[n2];
                Object ct = this.getCodeType(type);
                if (ct != null) {
                    result.add(ct);
                }
                ++n2;
            }
            return result.toArray(new ICodeType[result.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeType[] getCodeTypes(Long partitionId, Class ... types) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return this.getCodeTypes(types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICode> T getCode(final Class<T> type) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            block9: {
                if (type != null) break block9;
                return null;
            }
            Class<?> declaringCodeTypeClass = null;
            if (type.getDeclaringClass() != null) {
                Class<?> c = type.getDeclaringClass();
                while (c != null && !ICodeType.class.isAssignableFrom(c)) {
                    c = c.getDeclaringClass();
                }
                declaringCodeTypeClass = c;
            }
            if (declaringCodeTypeClass == null) {
                try {
                    declaringCodeTypeClass = ((ICode)type.newInstance()).getCodeType().getClass();
                }
                catch (Throwable t) {
                    LOG.error("find code " + type, t);
                }
            }
            T codeType = this.getCodeType(declaringCodeTypeClass);
            final Holder codeHolder = new Holder(ICode.class);
            ICodeVisitor v = new ICodeVisitor(){

                public boolean visit(ICode code, int treeLevel) {
                    if (code.getClass() == type) {
                        codeHolder.setValue((Object)code);
                        return false;
                    }
                    return true;
                }
            };
            codeType.visit(v);
            return (T)((ICode)codeHolder.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICode> T getCode(Long partitionId, Class<T> type) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return this.getCode(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType> T reloadCodeType(Class<T> type) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            LOG.warn("reloading code types is not supported by this testing ICodeService");
            return this.getCodeType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeType[] reloadCodeTypes(Class ... types) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            LOG.warn("reloading code types is not supported by this testing ICodeService");
            return this.getCodeTypes(types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleClassDescriptor[] getAllCodeTypeClasses(String classPrefix) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            ArrayList<BundleClassDescriptor> result = new ArrayList<BundleClassDescriptor>();
            for (Class<? extends ICodeType> type : this.m_codeTypes.keySet()) {
                Bundle bundle = FrameworkUtil.getBundle(type);
                result.add(new BundleClassDescriptor(bundle.getSymbolicName(), type.getName()));
            }
            return result.toArray(new BundleClassDescriptor[result.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeType[] getAllCodeTypes(String classPrefix) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            ArrayList result = new ArrayList();
            for (ICodeType<?> ct : this.m_codeTypes.values()) {
                if (!ct.getClass().getName().startsWith(classPrefix)) continue;
                result.add(ct);
            }
            return result.toArray(new ICodeType[result.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeType[] getAllCodeTypes(String classPrefix, Long partitionId) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return this.getAllCodeTypes(classPrefix);
        }
    }
}

